/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityDefect;
import jenkins.plugins.coverity.CoverityProjectAction;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.tasks.SimpleBuildStep;

public class CoverityBuildAction
implements SimpleBuildStep.LastBuildAction {
    public static final String BUILD_ACTION_IDENTIFIER = "coverity_defects";
    private transient List<Long> defectIds;
    private final Run<?, ?> build;
    private final String projectId;
    private final String streamId;
    private final String cimInstance;
    private final List<CoverityDefect> defects;

    public CoverityBuildAction(Run<?, ?> build, String projectId, String streamId, String cimInstance, List<CoverityDefect> defects) {
        this.build = build;
        this.projectId = projectId;
        this.streamId = streamId;
        this.cimInstance = cimInstance;
        this.defects = defects;
    }

    public AbstractBuild getBuild() {
        return (AbstractBuild)this.build;
    }

    public List<CoverityDefect> getDefects() {
        if (this.defectIds != null && !this.defectIds.isEmpty()) {
            ArrayList<CoverityDefect> covDefects = new ArrayList<CoverityDefect>();
            for (Long defectId : this.defectIds) {
                covDefects.add(new CoverityDefect(defectId, "---", "View in Coverity Connect", ""));
            }
            return covDefects;
        }
        return this.defects != null ? this.defects : new ArrayList<CoverityDefect>();
    }

    public String getURL(CoverityDefect defect) throws IOException, CovRemoteServiceException_Exception {
        CIMInstance instance = ((CoverityPublisher.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class)).getInstance(this.cimInstance);
        if (instance == null) {
            return "";
        }
        String header = "http";
        if (instance.isUseSSL()) {
            header = "https";
        }
        return String.format(header + "://%s:%d/sourcebrowser.htm?projectId=%s&mergedDefectId=%d", instance.getHost(), instance.getPort(), instance.getProjectKey(this.projectId), defect.getCid());
    }

    public String getIconFileName() {
        return "/plugin/coverity/icons/coverity-logo-400px.png";
    }

    public String getDisplayName() {
        return "Coverity Defects ";
    }

    public String getGraphDisplayName() {
        return "Coverity Defects (" + this.streamId + ")";
    }

    public String getUrlName() {
        return BUILD_ACTION_IDENTIFIER;
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.build != null) {
            AbstractProject project;
            CoverityPublisher coverityPublisher;
            Job parent = this.build.getParent();
            if (parent instanceof AbstractProject && (coverityPublisher = (CoverityPublisher)(project = (AbstractProject)parent).getPublishersList().get(CoverityPublisher.class)) != null && coverityPublisher.getHideChart()) {
                return Collections.emptyList();
            }
            return Collections.singleton(new CoverityProjectAction(this.build.getParent()));
        }
        return Collections.emptyList();
    }
}

