/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import com.coverity.ws.v9.StreamDataObj;
import com.coverity.ws.v9.StreamFilterSpecDataObj;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityToolInstallation;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.CoverityVersion;
import jenkins.plugins.coverity.ScmOptionBlock;
import jenkins.plugins.coverity.TaOptionBlock;
import org.jenkinsci.remoting.RoleChecker;

public class CheckConfig
extends AbstractDescribableImpl<CheckConfig> {
    private CoverityPublisher publisher;
    private final List<Status> status;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;

    public CheckConfig(CoverityPublisher publisher, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.publisher = publisher;
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.status = new ArrayList<Status>();
    }

    public boolean isValid() {
        for (Status s : this.status) {
            if (s.isValid()) continue;
            return false;
        }
        return true;
    }

    public List<Status> getStatus() {
        return this.status;
    }

    public CoverityPublisher getPublisher() {
        return this.publisher;
    }

    public void check() {
        ScmOptionBlock scmOptionBlock;
        TaOptionBlock taOptionBlock;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.status.clear();
        this.status.add(CheckConfig.checkStream(this.publisher, this.publisher.getCimStream()));
        if (this.launcher != null) {
            NodeStatus ns = CheckConfig.checkNode(this.publisher, this.build, this.launcher, (TaskListener)this.listener);
            this.status.add(ns);
            if (!this.isValid()) {
                return;
            }
            CoverityVersion analysisVersion = ns.getVersion();
            ArrayList<Status> newStatus = new ArrayList<Status>();
            for (Status s : this.status) {
                if (!(s instanceof StreamStatus)) continue;
                StreamStatus ss = (StreamStatus)s;
                CoverityVersion cimVersion = ss.getVersion();
                CIMStream stream = ss.getStream();
                if (cimVersion == null || cimVersion.compareToAnalysis(analysisVersion) || stream == null) continue;
                newStatus.add(new Status(false, "Connect instance " + stream.toPrettyString() + " (version " + cimVersion.toString() + ") is incompatible with analysis version " + analysisVersion));
            }
            this.status.addAll(newStatus);
        }
        if ((taOptionBlock = this.publisher.getTaOptionBlock()) != null) {
            this.status.add(CheckConfig.checkTaOptionBlock(taOptionBlock));
        }
        if ((scmOptionBlock = this.publisher.getScmOptionBlock()) != null) {
            this.status.add(CheckConfig.checkScmOptionBlock(scmOptionBlock));
        }
    }

    public static StreamStatus checkStream(CoverityPublisher publisher, CIMStream cs) {
        if (cs == null || cs.getInstance() == null) {
            return new StreamStatus(false, "Could not connect to a Coverity instance. \n Verify that a Coverity instance has been configured for this job", cs, null);
        }
        CIMInstance ci = publisher.getDescriptor().getInstance(publisher);
        if (ci == null) {
            return new StreamStatus(false, "Could not connect to a Coverity instance. \n Verify that a Coverity instance has been configured for this job", cs, null);
        }
        if (cs.getStream() == null) {
            return new StreamStatus(false, "Could not find any Stream that matches the given configuration for this job.", cs, null);
        }
        try {
            FormValidation fv = ci.doCheck();
            if (fv.kind == FormValidation.Kind.ERROR) {
                return new StreamStatus(false, "Could not connect to instance: " + fv, cs, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new StreamStatus(false, "Could not connect to instance: " + e, cs, null);
        }
        CoverityVersion version = null;
        try {
            version = CoverityVersion.parse(ci.getConfigurationService().getVersion().getExternalVersion());
        }
        catch (CovRemoteServiceException_Exception e) {
            e.printStackTrace();
            return new StreamStatus(false, "Could not retrieve version info: " + e, cs, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new StreamStatus(false, "Could not retrieve version info: " + e, cs, null);
        }
        try {
            StreamFilterSpecDataObj sf = new StreamFilterSpecDataObj();
            sf.setNamePattern(cs.getStream());
            List<StreamDataObj> ls = ci.getConfigurationService().getStreams(sf);
            if (ls.size() == 0) {
                return new StreamStatus(false, "Stream does not exist", cs, version);
            }
        }
        catch (CovRemoteServiceException_Exception e) {
            e.printStackTrace();
            return new StreamStatus(false, "Could not find stream: " + e, cs, version);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new StreamStatus(false, "Could not find stream: " + e, cs, version);
        }
        return new StreamStatus(true, "OK (version: " + version + ")", cs, version);
    }

    public static NodeStatus checkNode(CoverityPublisher publisher, AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) {
        Node node = Executor.currentExecutor().getOwner().getNode();
        try {
            CoverityToolInstallation installation = CoverityUtils.findToolInstallationForBuild(node, build.getEnvironment(listener), listener);
            if (installation == null) {
                return new NodeStatus(false, "Could not find Coverity Analysis tools installation.", node, null);
            }
            listener.getLogger().println("[Coverity] Node '" + node.getDisplayName() + "' found Tools installation '" + installation.getName() + "' with directory '" + installation.getHome() + "'");
            try {
                CoverityUtils.checkDir(launcher.getChannel(), installation.getHome());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new NodeStatus(false, "Could not find Coverity Analysis tools installation '" + installation.getName() + "'. [" + installation.getHome() + "]", node, null);
            }
            FilePath homePath = new FilePath(launcher.getChannel(), installation.getHome());
            CoverityVersion version = CheckConfig.getVersion(homePath);
            if (version.compareTo(CoverityVersion.MINIMUM_SUPPORTED_VERSION) < 0) {
                return new NodeStatus(false, "\"Coverity Static Analysis\" version " + version.toString() + " is not supported. The minimum supported version is " + CoverityVersion.MINIMUM_SUPPORTED_VERSION.toString(), node, version);
            }
            return new NodeStatus(true, "version " + version, node, version);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new NodeStatus(false, "Error checking node: " + e.toString(), node, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return new NodeStatus(false, "Interrupted while checking node.", node, null);
        }
    }

    public static Status checkTaOptionBlock(TaOptionBlock taOptionBlock) {
        String taCheck = taOptionBlock.checkTaConfig();
        if (!taCheck.equals("Pass")) {
            return new Status(false, taCheck);
        }
        return new Status(true, "[Test Advisor] Configuration is valid!");
    }

    public static Status checkScmOptionBlock(ScmOptionBlock scmOptionBlock) {
        String scmCheck = scmOptionBlock.checkScmConfig();
        if (!scmCheck.equals("Pass")) {
            return new Status(false, scmCheck);
        }
        return new Status(true, "[SCM] Configuration is valid!");
    }

    public static CoverityVersion getVersion(FilePath homePath) throws IOException, InterruptedException {
        CoverityVersion version = (CoverityVersion)homePath.child("VERSION").act((FilePath.FileCallable)new FilePath.FileCallable<CoverityVersion>(){

            public void checkRoles(RoleChecker roleChecker) throws SecurityException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CoverityVersion invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
                String prefix = "externalVersion=";
                String version = "";
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("externalVersion=")) continue;
                        version = line.substring("externalVersion=".length(), line.length());
                        return version;
                    }
                }
                finally {
                    br.close();
                    return CoverityVersion.parse(version);
                }
            }
        });
        return version;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CheckConfig> {
        public String getDisplayName() {
            return "";
        }
    }

    public static class NodeStatus
    extends Status {
        private final Node node;
        private final CoverityVersion version;

        public NodeStatus(boolean valid, String status, Node node, CoverityVersion version) {
            super(valid, status);
            this.version = version;
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public CoverityVersion getVersion() {
            return this.version;
        }

        @Override
        public String getStatus() {
            if (this.node != null) {
                return "[Node] " + this.node.getDisplayName() + " : " + this.status;
            }
            return this.status;
        }
    }

    public static class StreamStatus
    extends Status {
        private final CIMStream stream;
        private final CoverityVersion version;

        public StreamStatus(boolean valid, String status, CIMStream stream, CoverityVersion version) {
            super(valid, status);
            this.stream = stream;
            this.version = version;
        }

        public CIMStream getStream() {
            return this.stream;
        }

        public CoverityVersion getVersion() {
            return this.version;
        }

        @Override
        public String getStatus() {
            if (this.stream != null) {
                return "[Stream] " + this.stream.toPrettyString() + " : " + this.status;
            }
            return this.status;
        }
    }

    public static class Status {
        boolean valid;
        String status;

        private Status(boolean valid, String status) {
            this.valid = valid;
            this.status = status;
        }

        public String toString() {
            return this.status;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

