/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v9.AttributeDefinitionDataObj;
import com.coverity.ws.v9.AttributeDefinitionIdDataObj;
import com.coverity.ws.v9.AttributeValueDataObj;
import com.coverity.ws.v9.ComponentDataObj;
import com.coverity.ws.v9.ComponentMapDataObj;
import com.coverity.ws.v9.ComponentMapFilterSpecDataObj;
import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import com.coverity.ws.v9.StreamDataObj;
import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ws.CimCache;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class CIMStream
extends AbstractDescribableImpl<CIMStream> {
    private transient InvocationAssistance invocationAssistanceOverride;
    private final String instance;
    private final String project;
    private final String stream;
    private String credentialId;
    private DefectFilters defectFilters;

    @DataBoundConstructor
    public CIMStream(String instance, String project, String stream) {
        this.instance = Util.fixEmpty((String)instance);
        this.project = Util.fixEmpty((String)project);
        this.stream = Util.fixEmpty((String)stream);
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    @DataBoundSetter
    public void setDefectFilters(DefectFilters defectFilters) {
        this.defectFilters = defectFilters;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    @Deprecated
    public InvocationAssistance getInvocationAssistanceOverride() {
        return this.invocationAssistanceOverride;
    }

    public String toPrettyString() {
        return this.instance + "/" + this.project + "/" + this.stream;
    }

    public String toString() {
        return "CIMStream{instance='" + this.instance + '\'' + ", project='" + this.project + '\'' + ", stream='" + this.stream + '\'' + ", defectFilters=" + this.defectFilters + '}';
    }

    public boolean isValid() {
        return this.instance != null && this.project != null && this.stream != null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CIMStream> {
        public String getDisplayName() {
            return "";
        }

        public CoverityPublisher.DescriptorImpl getPublisherDescriptor() {
            return (CoverityPublisher.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class);
        }

        public List<CIMInstance> getInstances() {
            return this.getPublisherDescriptor().getInstances();
        }

        public CIMInstance getInstance(String name) {
            if (!StringUtils.isEmpty((String)name)) {
                for (CIMInstance instance : this.getInstances()) {
                    if (!instance.getName().equals(name)) continue;
                    return instance;
                }
            }
            return null;
        }

        public ListBoxModel doFillInstanceItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("");
            for (CIMInstance instance : this.getInstances()) {
                result.add(instance.getName());
            }
            return result;
        }

        public FormValidation doCheckInstance(@QueryParameter String instance) {
            CIMInstance cimInstance = this.getInstance(instance);
            if (cimInstance != null) {
                FormValidation checkResult = cimInstance.doCheck();
                CimCache.getInstance().cacheCimInstance(cimInstance);
                return checkResult.kind.equals((Object)FormValidation.Kind.OK) ? FormValidation.ok() : checkResult;
            }
            return FormValidation.warning((String)"Coverity Connect instance is required to select project and stream");
        }

        public List<String> loadProjects(@QueryParameter String instance, @QueryParameter String project) {
            CIMInstance cimInstance;
            ArrayList<String> projects = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)instance) && (cimInstance = this.getInstance(instance)) != null) {
                for (String projectFromCim : CimCache.getInstance().getProjects(cimInstance)) {
                    projects.add(projectFromCim);
                }
            }
            if (!StringUtils.isEmpty((String)project) && !projects.contains(project)) {
                projects.add(project);
            }
            return projects;
        }

        public boolean checkProjectIsValid(@QueryParameter String instance, @QueryParameter String project) {
            if (StringUtils.isEmpty((String)project)) {
                return true;
            }
            CIMInstance cimInstance = this.getInstance(instance);
            if (cimInstance != null) {
                for (String projectName : CimCache.getInstance().getProjects(cimInstance)) {
                    if (!projectName.equalsIgnoreCase(project)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<String> loadStreams(@QueryParameter String instance, @QueryParameter String project, @QueryParameter String stream) {
            CIMInstance cimInstance;
            ArrayList<String> streams = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)instance) && !StringUtils.isEmpty((String)project) && (cimInstance = this.getInstance(instance)) != null) {
                for (String streamFromCim : CimCache.getInstance().getStreams(cimInstance, project)) {
                    streams.add(streamFromCim);
                }
            }
            if (!StringUtils.isEmpty((String)stream) && !streams.contains(stream)) {
                streams.add(stream);
            }
            return streams;
        }

        public boolean checkStreamIsValid(@QueryParameter String instance, @QueryParameter String project, @QueryParameter String stream) {
            if (StringUtils.isEmpty((String)stream)) {
                return true;
            }
            CIMInstance cimInstance = this.getInstance(instance);
            if (cimInstance != null && !StringUtils.isEmpty((String)project)) {
                for (String streamFromCIM : CimCache.getInstance().getStreams(cimInstance, project)) {
                    if (!streamFromCIM.equalsIgnoreCase(stream)) continue;
                    return true;
                }
            }
            return false;
        }

        public ListBoxModel doFillClassificationDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                AttributeDefinitionIdDataObj adido = new AttributeDefinitionIdDataObj();
                adido.setName("Classification");
                AttributeDefinitionDataObj addo = instance.getConfigurationService().getAttribute(adido);
                for (AttributeValueDataObj classification : addo.getConfigurableValues()) {
                    result.add(classification.getAttributeValueId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillActionDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                AttributeDefinitionIdDataObj adido = new AttributeDefinitionIdDataObj();
                adido.setName("Action");
                AttributeDefinitionDataObj addo = instance.getConfigurationService().getAttribute(adido);
                for (AttributeValueDataObj classification : addo.getConfigurableValues()) {
                    result.add(classification.getAttributeValueId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillImpactDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) {
            ListBoxModel result = new ListBoxModel();
            result.add("High");
            result.add("Medium");
            result.add("Low");
            return result;
        }

        public ListBoxModel doFillSeveritiesDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                AttributeDefinitionIdDataObj adido = new AttributeDefinitionIdDataObj();
                adido.setName("Severity");
                AttributeDefinitionDataObj addo = instance.getConfigurationService().getAttribute(adido);
                for (AttributeValueDataObj classification : addo.getConfigurableValues()) {
                    result.add(classification.getAttributeValueId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillComponentDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance, @QueryParameter(value="../stream") String streamId) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                ComponentMapFilterSpecDataObj componentMapFilterSpec = new ComponentMapFilterSpecDataObj();
                if (!StringUtils.isEmpty((String)streamId)) {
                    StreamDataObj stream = instance.getStream(streamId);
                    String componentMapId = stream.getComponentMapId().getName();
                    componentMapFilterSpec.setNamePattern(componentMapId);
                } else {
                    componentMapFilterSpec.setNamePattern("*");
                }
                for (ComponentMapDataObj map : instance.getConfigurationService().getComponentMaps(componentMapFilterSpec)) {
                    for (ComponentDataObj component : map.getComponents()) {
                        result.add(component.getComponentId().getName());
                    }
                }
            }
            return result;
        }

        public ListBoxModel doFillCheckerDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance, @QueryParameter(value="../stream") String streamId) throws IOException, CovRemoteServiceException_Exception {
            if (StringUtils.isEmpty((String)streamId)) {
                return new ListBoxModel();
            }
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance == null) {
                return new ListBoxModel();
            }
            ImmutableList<String> checkers = instance.getCimInstanceCheckers();
            ListBoxModel result = new ListBoxModel();
            for (String checker : checkers) {
                result.add(checker);
            }
            return result;
        }
    }
}

