/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.coverity.ws.v9.ConfigurationService;
import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import com.coverity.ws.v9.DefectService;
import com.coverity.ws.v9.GroupDataObj;
import com.coverity.ws.v9.GroupIdDataObj;
import com.coverity.ws.v9.PermissionDataObj;
import com.coverity.ws.v9.ProjectDataObj;
import com.coverity.ws.v9.ProjectFilterSpecDataObj;
import com.coverity.ws.v9.RoleAssignmentDataObj;
import com.coverity.ws.v9.RoleDataObj;
import com.coverity.ws.v9.StreamDataObj;
import com.coverity.ws.v9.StreamFilterSpecDataObj;
import com.coverity.ws.v9.UserDataObj;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityDefect;
import jenkins.plugins.coverity.CoverityVersion;
import jenkins.plugins.coverity.ws.ViewContents;
import jenkins.plugins.coverity.ws.ViewsService;
import jenkins.plugins.coverity.ws.WebServiceFactory;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CIMInstance {
    private static final Logger logger = Logger.getLogger(CIMStream.class.getName());
    private final String name;
    private final String host;
    private final int port;
    @Deprecated
    private String user;
    @Deprecated
    private String password;
    private boolean useSSL;
    private String credentialId;
    private transient String lastSuccessfulUser;
    private transient Map<String, Long> projectKeys;

    @DataBoundConstructor
    public CIMInstance(String name, String host, int port, String credentialId) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.credentialId = credentialId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    @DataBoundSetter
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public DefectService getDefectService() throws IOException {
        return WebServiceFactory.getInstance().getDefectService(this);
    }

    public ConfigurationService getConfigurationService() throws IOException {
        return WebServiceFactory.getInstance().getConfigurationService(this);
    }

    public ProjectDataObj getProject(String projectId) throws IOException, CovRemoteServiceException_Exception {
        List<Object> projects = new ArrayList();
        try {
            ProjectFilterSpecDataObj filterSpec = new ProjectFilterSpecDataObj();
            filterSpec.setNamePattern(projectId);
            projects = this.getConfigurationService().getProjects(filterSpec);
        }
        catch (Exception e) {
            logger.warning("Error getting project " + projectId + " from instance " + this.name + " (" + this.host + ":" + this.port + ")");
        }
        if (projects.size() == 0) {
            return null;
        }
        return (ProjectDataObj)projects.get(0);
    }

    public Long getProjectKey(String projectId) throws IOException, CovRemoteServiceException_Exception {
        ProjectDataObj project;
        Long result;
        if (this.projectKeys == null) {
            this.projectKeys = new ConcurrentHashMap<String, Long>();
        }
        if ((result = this.projectKeys.get(projectId)) == null && (project = this.getProject(projectId)) != null) {
            result = project.getProjectKey();
            this.projectKeys.put(projectId, result);
        }
        return result;
    }

    public List<ProjectDataObj> getProjects() throws IOException, CovRemoteServiceException_Exception {
        try {
            return this.getConfigurationService().getProjects(new ProjectFilterSpecDataObj());
        }
        catch (Exception e) {
            logger.warning("Error getting projects from instance " + this.name + " (" + this.host + ":" + this.port + ")");
            return new ArrayList<ProjectDataObj>();
        }
    }

    public StreamDataObj getStream(String streamId) throws IOException, CovRemoteServiceException_Exception {
        StreamFilterSpecDataObj filter = new StreamFilterSpecDataObj();
        filter.setNamePattern(streamId);
        List<StreamDataObj> streams = this.getConfigurationService().getStreams(filter);
        if (streams == null || streams.isEmpty()) {
            throw new IOException("An error occurred while retrieving streams for the given project. Could not find stream: " + streamId);
        }
        StreamDataObj streamDataObj = streams.get(0);
        if (streamDataObj == null) {
            throw new IOException("An error occurred while retrieving streams for the given project. Could not find stream: " + streamId);
        }
        return streams.get(0);
    }

    public FormValidation doCheck() {
        try {
            WebServiceFactory.CheckWsResponse responseCode = WebServiceFactory.getInstance().getCheckWsResponse(this);
            if (responseCode.getResponseCode() != 200) {
                return FormValidation.error((String)("Connection check failed." + System.lineSeparator() + responseCode.toString() + System.lineSeparator() + "(check that the values entered for this instance are correct and ensure the Coverity Connect version is at least " + CoverityVersion.MINIMUM_SUPPORTED_VERSION.toString() + ")"));
            }
            FormValidation userPermissionsValidation = this.checkUserPermissions();
            if (!userPermissionsValidation.kind.equals((Object)FormValidation.Kind.OK)) {
                return userPermissionsValidation;
            }
            return FormValidation.ok((String)"Successfully connected to the instance.");
        }
        catch (WebServiceException e) {
            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"Unauthorized")) {
                return FormValidation.error((String)("User authentication failed." + System.lineSeparator() + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage()));
            }
            return FormValidation.error((Throwable)e, (String)("Web service error occurred. " + System.lineSeparator() + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage()));
        }
        catch (Throwable e) {
            int patch;
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.6.0_") && (patch = Integer.parseInt(javaVersion.substring(javaVersion.indexOf(95) + 1))) < 26) {
                return FormValidation.error((Throwable)e, (String)"Please use Java 1.6.0_26 or later to run Jenkins.");
            }
            return FormValidation.error((Throwable)e, (String)("An unexpected error occurred. " + System.lineSeparator() + e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    public ImmutableList<String> getCimInstanceCheckers() throws IOException, CovRemoteServiceException_Exception {
        List<String> checkerNames = this.getConfigurationService().getCheckerNames();
        Collections.sort(checkerNames);
        return ImmutableList.copyOf(checkerNames);
    }

    public ImmutableSortedMap<Long, String> getViews() {
        Map<Long, String> views;
        try {
            views = WebServiceFactory.getInstance().getViewService(this).getViews();
        }
        catch (MalformedURLException | NoSuchAlgorithmException e) {
            return ImmutableSortedMap.of();
        }
        return ImmutableSortedMap.copyOf(views);
    }

    public List<CoverityDefect> getIssuesVorView(String projectId, String connectView, PrintStream outputLogger) throws Exception {
        ArrayList<CoverityDefect> coverityDefects = new ArrayList<CoverityDefect>();
        try {
            ViewsService viewService = WebServiceFactory.getInstance().getViewService(this);
            int defectSize = 1000;
            int pageSize = 1000;
            for (int pageStart = 0; pageStart < defectSize; pageStart += pageSize) {
                if (pageStart >= pageSize) {
                    outputLogger.println(MessageFormat.format("[Coverity] Retrieving issues for project \"{0}\" and view \"{1}\" (fetched {2} of {3})", projectId, connectView, pageStart, defectSize));
                } else {
                    outputLogger.println(MessageFormat.format("[Coverity] Retrieving issues for project \"{0}\" and view \"{1}\"", projectId, connectView));
                }
                ViewContents viewContents = viewService.getViewContents(projectId, connectView, pageSize, pageStart);
                if (!viewContents.getColumns().contains("cid")) {
                    outputLogger.println(MessageFormat.format("[Coverity] Warning: Issues view \"{0}\" is missing column \"cid\"", connectView));
                }
                if (!viewContents.getColumns().contains("checker")) {
                    outputLogger.println(MessageFormat.format("[Coverity] Warning: Issues view \"{0}\" is missing column \"checker\"", connectView));
                }
                if (!viewContents.getColumns().contains("displayFile")) {
                    outputLogger.println(MessageFormat.format("[Coverity] Warning: Issues view \"{0}\" is missing column \"displayFile\"", connectView));
                }
                if (!viewContents.getColumns().contains("displayFunction")) {
                    outputLogger.println(MessageFormat.format("[Coverity] Warning: Issues view \"{0}\" is missing column \"displayFunction\"", connectView));
                }
                for (Map<String, Object> row : viewContents.getRows()) {
                    Long cid = row.get("cid") != null ? Long.valueOf(Long.parseLong(row.get("cid").toString())) : null;
                    String checker = row.get("checker") != null ? row.get("checker").toString() : null;
                    String displayFunction = row.get("displayFunction") != null ? row.get("displayFunction").toString() : null;
                    String displayFile = row.get("displayFile") != null ? row.get("displayFile").toString() : null;
                    coverityDefects.add(new CoverityDefect(cid, checker, displayFunction, displayFile));
                }
                defectSize = viewContents.getTotalRows().intValue();
            }
            outputLogger.println(MessageFormat.format("[Coverity] Found {0} issues for project \"{1}\" and view \"{2}\"", coverityDefects.size(), projectId, connectView));
        }
        catch (MalformedURLException | NoSuchAlgorithmException e) {
            throw new Exception(e);
        }
        return coverityDefects;
    }

    private FormValidation checkUserPermissions() throws IOException, CovRemoteServiceException_Exception {
        String username = this.getCoverityUser();
        if (StringUtils.isNotEmpty((String)this.lastSuccessfulUser) && this.lastSuccessfulUser.equalsIgnoreCase(username)) {
            return FormValidation.ok();
        }
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("\"" + username + "\" does not have following permission(s): ");
        try {
            boolean canCommit = false;
            boolean canViewIssues = false;
            boolean canCommitGlobal = false;
            boolean canViewIssuesGlobal = false;
            UserDataObj userData = this.getConfigurationService().getUser(username);
            if (userData != null) {
                if (userData.isSuperUser().booleanValue()) {
                    this.lastSuccessfulUser = username;
                    return FormValidation.ok();
                }
                LinkedList<RoleAssignmentDataObj> roleAssignments = new LinkedList<RoleAssignmentDataObj>(userData.getRoleAssignments());
                Iterator<String> groupNameIterator = userData.getGroups().iterator();
                while (!(canCommitGlobal && canViewIssuesGlobal || roleAssignments.isEmpty() && !groupNameIterator.hasNext())) {
                    if (roleAssignments.isEmpty()) {
                        GroupIdDataObj groupId = new GroupIdDataObj();
                        groupId.setName(groupNameIterator.next());
                        GroupDataObj group = this.getConfigurationService().getGroup(groupId);
                        if (group != null) {
                            roleAssignments.addAll(group.getRoleAssignments());
                        }
                    }
                    if (roleAssignments.isEmpty()) continue;
                    RoleAssignmentDataObj roleAssignment = roleAssignments.removeFirst();
                    if (roleAssignment.getRoleId().getName().equals("serverAdmin") || roleAssignment.getRoleId().getName().equals("streamOwner") || roleAssignment.getRoleId().getName().equals("projectOwner")) {
                        if (roleAssignment.getType().equals("global")) {
                            canViewIssuesGlobal = true;
                            canViewIssues = true;
                            canCommitGlobal = true;
                            canCommit = true;
                            continue;
                        }
                        canViewIssues = true;
                        canCommit = true;
                        continue;
                    }
                    RoleDataObj roleData = this.getConfigurationService().getRole(roleAssignment.getRoleId());
                    if (roleData == null) continue;
                    for (PermissionDataObj permission : roleData.getPermissionDataObjs()) {
                        if (permission.getPermissionValue().equalsIgnoreCase("commitToStream")) {
                            if (roleAssignment.getType().equals("global")) {
                                canCommitGlobal = true;
                                canCommit = true;
                                continue;
                            }
                            canCommit = true;
                            continue;
                        }
                        if (!permission.getPermissionValue().equalsIgnoreCase("viewDefects")) continue;
                        if (roleAssignment.getType().equals("global")) {
                            canViewIssuesGlobal = true;
                            canViewIssues = true;
                            continue;
                        }
                        canViewIssues = true;
                    }
                }
            }
            if (!canCommit) {
                errorMessage.append("\"Commit to a stream\" ");
            }
            if (!canViewIssues) {
                errorMessage.append("\"View issues\" ");
            }
            if (!canCommit || !canViewIssues) {
                return FormValidation.error((String)errorMessage.toString());
            }
            if (!canCommitGlobal || !canViewIssuesGlobal) {
                StringBuilder warningMessage = new StringBuilder();
                warningMessage.append("\"" + username + "\" does not have following global permission(s): ");
                if (!canCommitGlobal) {
                    warningMessage.append("\"Commit to a stream\" ");
                }
                if (!canViewIssuesGlobal) {
                    warningMessage.append("\"View issues\" ");
                }
                return FormValidation.warning((String)warningMessage.toString());
            }
        }
        catch (SOAPFaultException e) {
            if (StringUtils.isNotEmpty((String)e.getMessage())) {
                if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)("User " + username + " Doesn't have permissions to perform {invokeWS}"))) {
                    return FormValidation.error((String)errorMessage.append("\"Access web services\"").toString());
                }
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.error((Throwable)e, (String)"An unexpected error occurred.");
        }
        this.lastSuccessfulUser = username;
        logger.info(username + " has all the permissions!");
        return FormValidation.ok();
    }

    public String getCoverityUser() {
        String username = this.retrieveCredentialInfo(true);
        return StringUtils.isNotEmpty((String)username) ? username : this.user;
    }

    public String getCoverityPassword() {
        String password = this.retrieveCredentialInfo(false);
        return StringUtils.isNotEmpty((String)password) ? password : this.password;
    }

    private String retrieveCredentialInfo(boolean getUsername) {
        StandardCredentials credentials;
        if (!StringUtils.isEmpty((String)this.credentialId) && (credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialId))) != null && credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials c = (UsernamePasswordCredentials)credentials;
            if (getUsername) {
                return c.getUsername();
            }
            return c.getPassword().getPlainText();
        }
        return "";
    }

    public CIMInstance cloneWithCredential(String credentialId) {
        CIMInstance instance = new CIMInstance(this.name, this.host, this.port, credentialId);
        instance.setUser(this.user);
        instance.setPassword(this.password);
        instance.setUseSSL(this.useSSL);
        return instance;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.credentialId != null ? this.credentialId.hashCode() : 0);
        return result;
    }
}

