/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.App;
import com.aspectsecurity.contrast.contrastjenkins.TeamServerProfile;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelper;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelperException;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.http.TraceFilterForm;
import com.contrastsecurity.models.Application;
import com.contrastsecurity.models.Organizations;
import com.contrastsecurity.models.SecurityCheck;
import com.contrastsecurity.models.Traces;
import com.contrastsecurity.sdk.ContrastSDK;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VulnerabilityTrendStep
extends AbstractStepImpl {
    private String profile;
    private int count;
    private String rule;
    private String severity;
    private String applicationId;
    private String applicationName;
    private String appVersionTag;
    private int queryBy;
    private String agentType;

    @DataBoundSetter
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @DataBoundSetter
    public void setCount(int count) {
        this.count = count;
    }

    @DataBoundSetter
    public void setRule(String rule) {
        this.rule = rule;
    }

    @DataBoundSetter
    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @DataBoundSetter
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @DataBoundSetter
    public void setAppVersionTag(String appVersionTag) {
        this.appVersionTag = appVersionTag;
    }

    @DataBoundSetter
    public void setQueryBy(int queryBy) {
        this.queryBy = queryBy;
    }

    @DataBoundSetter
    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    @DataBoundConstructor
    public VulnerabilityTrendStep(String profile, int count, String rule, String severity, String applicationId, int queryBy) {
        this.profile = profile;
        this.count = count;
        this.rule = rule;
        this.severity = severity;
        this.applicationId = applicationId;
        this.queryBy = queryBy;
    }

    public VulnerabilityTrendStep() {
    }

    public VulnerabilityTrendStepDescriptorImpl getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            return (VulnerabilityTrendStepDescriptorImpl)instance.getDescriptor(((Object)((Object)this)).getClass());
        }
        return null;
    }

    private String buildStepString() {
        StringBuilder sb = new StringBuilder();
        sb.append("count is ").append(this.count);
        if (this.severity != null) {
            sb.append(", severity is ").append(this.severity);
        }
        if (this.rule != null) {
            sb.append(", rule type is ").append(this.rule);
        }
        if (this.applicationId != null) {
            sb.append(", applicationId is ").append(this.applicationId);
        }
        if (this.queryBy != 0) {
            sb.append(", queryBy is ").append(this.queryBy);
        }
        sb.append(".");
        return sb.toString();
    }

    public String getProfile() {
        return this.profile;
    }

    public int getCount() {
        return this.count;
    }

    public String getRule() {
        return this.rule;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getAppVersionTag() {
        return this.appVersionTag;
    }

    public int getQueryBy() {
        return this.queryBy;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        transient Run<?, ?> build;
        @StepContextParameter
        transient TaskListener taskListener;
        @Inject
        transient VulnerabilityTrendStep step;

        private TraceFilterForm makeFilterFormWithQueryBy() throws IOException, InterruptedException {
            TraceFilterForm filterForm = new TraceFilterForm();
            if (this.step.getQueryBy() == 2) {
                String appVersionTag = VulnerabilityTrendHelper.buildAppVersionTagHierarchical(this.build, this.step.getApplicationId());
                ArrayList<String> appVersionTagsList = new ArrayList<String>();
                appVersionTagsList.add(appVersionTag);
                if (this.step.getApplicationName() != null) {
                    String appVersionTagAppName = VulnerabilityTrendHelper.buildAppVersionTagHierarchical(this.build, this.step.getApplicationName());
                    appVersionTagsList.add(appVersionTagAppName);
                }
                filterForm.setAppVersionTags(appVersionTagsList);
            } else if (this.step.getQueryBy() == 3) {
                filterForm.setStartDate(new Date(this.build.getStartTimeInMillis()));
            } else if (this.step.getQueryBy() == 4) {
                EnvVars env = this.build.getEnvironment(this.taskListener);
                String appVersionTag = this.step.getAppVersionTag() != null ? this.step.getAppVersionTag() : (env.get((Object)"APPVERSIONTAG") != null ? (String)env.get((Object)"APPVERSIONTAG") : "");
                if (appVersionTag.isEmpty()) {
                    VulnerabilityTrendHelper.logMessage(this.taskListener, "Warning: queryBy Parameter is configured, but appVersionTag is not set. All vulnerabilities will be returned for this application");
                }
                ArrayList<String> appVersionTagsList = new ArrayList<String>();
                appVersionTagsList.add(appVersionTag);
                filterForm.setAppVersionTags(appVersionTagsList);
            } else {
                String appVersionTag = VulnerabilityTrendHelper.buildAppVersionTag(this.build, this.step.getApplicationId());
                ArrayList<String> appVersionTagsList = new ArrayList<String>();
                appVersionTagsList.add(appVersionTag);
                if (this.step.getApplicationName() != null) {
                    String appVersionTagAppName = VulnerabilityTrendHelper.buildAppVersionTag(this.build, this.step.getApplicationName());
                    appVersionTagsList.add(appVersionTagAppName);
                }
                filterForm.setAppVersionTags(appVersionTagsList);
            }
            return filterForm;
        }

        private boolean updateBuildResult(TeamServerProfile profile, String message) throws AbortException {
            if (profile.isApplyVulnerableBuildResultOnContrastError()) {
                Result profileVulnerableBuildResult = Result.fromString((String)profile.getVulnerableBuildResult());
                VulnerabilityTrendHelper.logMessage(this.taskListener, "Setting build result to : " + profileVulnerableBuildResult.toString());
                if (Result.FAILURE.equals(profileVulnerableBuildResult)) {
                    throw new AbortException(message);
                }
                this.build.setResult(profileVulnerableBuildResult);
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Void run() throws AbortException, InterruptedException {
            boolean applicationIdExists;
            TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(this.step.getProfile());
            if (teamServerProfile == null) {
                VulnerabilityTrendHelper.logMessage(this.taskListener, "Unable to find TeamServer profile.");
                throw new AbortException("Unable to find TeamServer profile.");
            }
            String CONTRAST_ERROR_PREFIX = teamServerProfile.isApplyVulnerableBuildResultOnContrastError() ? "Error: " : "Warning: ";
            ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(teamServerProfile.getUsername(), teamServerProfile.getServiceKey(), teamServerProfile.getApiKey(), teamServerProfile.getTeamServerUrl());
            try {
                Organizations organizations = contrastSDK.getProfileDefaultOrganizations();
                if (organizations == null || organizations.getOrganization() == null) {
                    String errorMessage = CONTRAST_ERROR_PREFIX + "No organization found, Check your credentials and URL.";
                    VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                    this.updateBuildResult(teamServerProfile, errorMessage);
                    return null;
                }
            }
            catch (UnauthorizedException | IOException e) {
                String errorMessage = CONTRAST_ERROR_PREFIX + "Unable to connect to Contrast.";
                VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                VulnerabilityTrendHelper.logMessage(this.taskListener, e.getMessage());
                this.updateBuildResult(teamServerProfile, errorMessage);
                return null;
            }
            if (this.step.getApplicationId() == null && this.step.getApplicationName() != null && this.step.getAgentType() != null) {
                try {
                    Application app = contrastSDK.getApplicationByNameAndLanguage(teamServerProfile.getOrgUuid(), this.step.getApplicationName(), VulnerabilityTrendHelper.getAgentTypeFromString(this.step.getAgentType()));
                    if (app == null) {
                        String errorMessage = String.format(CONTRAST_ERROR_PREFIX + "Application with [name = %s, agentType = %s] not found.", this.step.getApplicationName(), this.step.getAgentType());
                        VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                        this.updateBuildResult(teamServerProfile, errorMessage);
                        return null;
                    }
                    this.step.setApplicationId(app.getId());
                    VulnerabilityTrendHelper.logMessage(this.taskListener, "Fetched Application : [name = '" + this.step.getApplicationName() + "', displayName = '" + app.getName() + "', agentType='" + app.getLanguage() + "'] with ID: [" + this.step.getApplicationId() + "]");
                }
                catch (UnauthorizedException | IOException e) {
                    String errorMessage = CONTRAST_ERROR_PREFIX + "Unable to retrieve information from TeamServer.";
                    VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                    VulnerabilityTrendHelper.logMessage(this.taskListener, e.getMessage());
                    this.updateBuildResult(teamServerProfile, errorMessage);
                    return null;
                }
            }
            if (this.step.getApplicationId() == null && this.step.getApplicationName() != null && this.step.getAgentType() == null) {
                for (App app : teamServerProfile.getApps()) {
                    String subStr = app.getTitle().substring(0, app.getTitle().lastIndexOf(" ("));
                    if (!subStr.equals(this.step.getApplicationName())) continue;
                    this.step.setApplicationId(app.getName());
                    break;
                }
            }
            if (!(applicationIdExists = VulnerabilityTrendHelper.applicationIdExists(contrastSDK, teamServerProfile.getOrgUuid(), this.step.getApplicationId()))) {
                String errorMessage = CONTRAST_ERROR_PREFIX + "Application with ID '" + this.step.getApplicationId() + "' not found.";
                VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                this.updateBuildResult(teamServerProfile, errorMessage);
                return null;
            }
            VulnerabilityTrendHelper.logMessage(this.taskListener, "Checking the number of vulnerabilities for " + this.step.getApplicationId());
            String stepString = this.step.buildStepString();
            try {
                TraceFilterForm filterForm = this.makeFilterFormWithQueryBy();
                SecurityCheck securityCheck = VulnerabilityTrendHelper.makeSecurityCheck(contrastSDK, teamServerProfile.getOrgUuid(), this.step.getApplicationId(), this.build.getStartTimeInMillis(), this.step.queryBy, filterForm);
                StringBuilder applicationDisplayForConsoleOutputBuilder = new StringBuilder("[");
                if (this.step.getApplicationName() != null && !this.step.getApplicationName().isEmpty()) {
                    applicationDisplayForConsoleOutputBuilder.append("name = " + this.step.getApplicationName());
                }
                if (this.step.getAgentType() != null && !this.step.getAgentType().isEmpty()) {
                    applicationDisplayForConsoleOutputBuilder.append(", agentType = " + this.step.getAgentType());
                }
                if (this.step.getApplicationId() != null && !this.step.getApplicationId().isEmpty()) {
                    applicationDisplayForConsoleOutputBuilder.append(", appId = " + this.step.getApplicationId());
                }
                applicationDisplayForConsoleOutputBuilder.append("]");
                String appicationDisplayForConsoleOutput = applicationDisplayForConsoleOutputBuilder.toString();
                if (securityCheck.getResult() != null) {
                    VulnerabilityTrendHelper.logMessage(this.taskListener, "Your Contrast admin has overridden policies you may have set in Vulnerability Security Controls or the 'query by' parameter");
                    if (securityCheck.getResult().booleanValue()) {
                        VulnerabilityTrendHelper.logMessage(this.taskListener, "This application did not violate any Contrast policies");
                        return null;
                    }
                    try {
                        Result jobResult = VulnerabilityTrendHelper.getJenkinsResultFromJobOutcome(securityCheck.getJobOutcomePolicy().getOutcome());
                        String message = "This application " + appicationDisplayForConsoleOutput + " has failed the Contrast policy '" + securityCheck.getJobOutcomePolicy().getName() + "'";
                        VulnerabilityTrendHelper.logMessage(this.taskListener, message);
                        VulnerabilityTrendHelper.logMessage(this.taskListener, "Setting build result to : " + jobResult);
                        if (Result.FAILURE.equals(jobResult)) {
                            throw new AbortException(message);
                        }
                        this.build.setResult(jobResult);
                        return null;
                    }
                    catch (VulnerabilityTrendHelperException e) {
                        String errorMessage = CONTRAST_ERROR_PREFIX + "Unable to retrieve outcome from job outcome policy";
                        VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                        VulnerabilityTrendHelper.logMessage(this.taskListener, e.getMessage());
                        this.updateBuildResult(teamServerProfile, errorMessage);
                        return null;
                    }
                }
                VulnerabilityTrendHelper.logMessage(this.taskListener, "Checking the step condition where " + stepString);
                if (this.step.getSeverity() != null) {
                    filterForm.setSeverities(VulnerabilityTrendHelper.getSeverityList(this.step.getSeverity()));
                }
                if (this.step.getRule() != null) {
                    filterForm.setVulnTypes(Collections.singletonList(this.step.getRule()));
                }
                VulnerabilityTrendHelper.logMessage(this.taskListener, "filterForm: " + filterForm);
                Traces traces = this.step.getQueryBy() == 3 || this.step.getQueryBy() == 4 ? VulnerabilityTrendHelper.getAllTraces(contrastSDK, teamServerProfile.getOrgUuid(), this.step.getApplicationId(), filterForm) : VulnerabilityTrendHelper.getAllTraces(contrastSDK, teamServerProfile.getOrgUuid(), null, filterForm);
                if (traces.getCount() <= this.step.getCount()) {
                    VulnerabilityTrendHelper.logMessage(this.taskListener, "This step has passed successfully");
                    return null;
                }
                Result buildResult = Result.fromString((String)teamServerProfile.getVulnerableBuildResult());
                VulnerabilityTrendHelper.logMessage(this.taskListener, "Failed on the condition where " + stepString);
                VulnerabilityTrendHelper.logMessage(this.taskListener, VulnerabilityTrendHelper.getVulnerabilityInfoString(traces));
                VulnerabilityTrendHelper.logMessage(this.taskListener, "Setting build result to : " + buildResult);
                if (buildResult.toString().equals(Result.FAILURE.toString())) {
                    throw new AbortException("Failed on the condition where " + stepString);
                }
                this.build.setResult(buildResult);
                return null;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (UnauthorizedException | IOException e) {
                String errorMessage = CONTRAST_ERROR_PREFIX + "Unable to retrieve vulnerability information from TeamServer.";
                VulnerabilityTrendHelper.logMessage(this.taskListener, errorMessage);
                VulnerabilityTrendHelper.logMessage(this.taskListener, e.getMessage());
                this.updateBuildResult(teamServerProfile, errorMessage);
                return null;
            }
        }

        String getBuildName() {
            return this.build.getParent().getFullName();
        }
    }

    @Extension
    public static class VulnerabilityTrendStepDescriptorImpl
    extends AbstractStepDescriptorImpl {
        public VulnerabilityTrendStepDescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "contrastVerification";
        }

        public String getDisplayName() {
            return "Verify vulnerabilities in a build";
        }

        public Step newInstance(Map<String, Object> arguments) {
            Object queryBy;
            VulnerabilityTrendStep step = new VulnerabilityTrendStep();
            if (arguments.containsKey("profile")) {
                Object profile = arguments.get("profile");
                if (profile != null) {
                    step.setProfile((String)profile);
                } else {
                    throw new IllegalArgumentException("Profile must be set.");
                }
            }
            if (arguments.containsKey("count")) {
                Object count = arguments.get("count");
                step.setCount((Integer)count);
            }
            if (arguments.containsKey("rule")) {
                Object rule = arguments.get("rule");
                step.setRule((String)rule);
            }
            if (arguments.containsKey("severity")) {
                Object severity = arguments.get("severity");
                step.setSeverity((String)severity);
            }
            if (arguments.containsKey("applicationId")) {
                String applicationId = (String)arguments.get("applicationId");
                step.setApplicationId(applicationId);
            }
            if (step.getApplicationId() == null) {
                Object applicationName = arguments.get("applicationName");
                if (applicationName != null) {
                    step.setApplicationName((String)applicationName);
                } else {
                    throw new IllegalArgumentException("If Application ID is not set, Application Name must be set.");
                }
            }
            if (step.getApplicationId() == null && arguments.containsKey("agentType")) {
                Object agentType = arguments.get("agentType");
                if (agentType != null) {
                    step.setAgentType((String)agentType);
                } else {
                    throw new IllegalArgumentException("If Application ID is not set, Agent Type must be set.");
                }
            }
            if (arguments.containsKey("queryBy")) {
                queryBy = arguments.get("queryBy");
                step.setQueryBy((Integer)queryBy);
                if (step.getQueryBy() == 4) {
                    step.setAppVersionTag((String)arguments.get("appVersionTag"));
                }
            } else if (arguments.containsKey("appVersionTagFormat")) {
                queryBy = arguments.get("appVersionTagFormat");
                step.setQueryBy((Integer)queryBy);
            }
            return step;
        }

        public ListBoxModel doFillProfileItems() {
            return VulnerabilityTrendHelper.getProfileNames();
        }

        public ListBoxModel doFillApplicationIdItems(@QueryParameter(value="profile") String teamServerProfileName) throws IOException {
            return VulnerabilityTrendHelper.getApplicationIds(teamServerProfileName);
        }

        public ListBoxModel doFillRuleItems(@QueryParameter(value="profile") String teamServerProfileName) {
            return VulnerabilityTrendHelper.getVulnerabilityTypes(teamServerProfileName);
        }

        public ListBoxModel doFillSeverityItems() {
            return VulnerabilityTrendHelper.getSeverityListBoxModel();
        }
    }
}

