/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.App;
import com.aspectsecurity.contrast.contrastjenkins.ContrastPluginConfig;
import com.aspectsecurity.contrast.contrastjenkins.GlobalThresholdCondition;
import com.aspectsecurity.contrast.contrastjenkins.MatchBy;
import com.aspectsecurity.contrast.contrastjenkins.TeamServerProfile;
import com.aspectsecurity.contrast.contrastjenkins.ThresholdCondition;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityFrequencyAction;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelper;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelperException;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendProjectAction;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendResult;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.http.TraceFilterForm;
import com.contrastsecurity.models.Application;
import com.contrastsecurity.models.Organizations;
import com.contrastsecurity.models.SecurityCheck;
import com.contrastsecurity.models.Trace;
import com.contrastsecurity.models.Traces;
import com.contrastsecurity.sdk.ContrastSDK;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class VulnerabilityTrendRecorder
extends Recorder {
    private List<ThresholdCondition> conditions;
    private String teamServerProfileName;
    private boolean overrideGlobalThresholdConditions;
    private int queryBy;

    @DataBoundConstructor
    public VulnerabilityTrendRecorder(List<ThresholdCondition> conditions, String teamServerProfileName, boolean overrideGlobalThresholdConditions, int queryBy) {
        this.conditions = conditions;
        this.teamServerProfileName = teamServerProfileName;
        this.overrideGlobalThresholdConditions = overrideGlobalThresholdConditions;
        this.queryBy = queryBy;
    }

    protected Object readResolve() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            ContrastPluginConfig.ContrastPluginConfigDescriptor contrastPluginConfigDescriptor = (ContrastPluginConfig.ContrastPluginConfigDescriptor)jenkins.getDescriptorByType(ContrastPluginConfig.ContrastPluginConfigDescriptor.class);
            TeamServerProfile[] profiles = contrastPluginConfigDescriptor.getTeamServerProfiles();
            for (TeamServerProfile profile : profiles) {
                if (profile.getApps() != null) continue;
                ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(profile.getUsername(), profile.getServiceKey(), profile.getApiKey(), profile.getTeamServerUrl());
                List<App> apps = VulnerabilityTrendHelper.saveApplicationIds(contrastSDK, profile.getOrgUuid());
                profile.setApps(apps);
                profile.setFailOnWrongApplicationId(profile.isFailOnWrongApplicationName());
                contrastPluginConfigDescriptor.save();
            }
            block1: for (ThresholdCondition thresholdCondition : this.conditions) {
                if (thresholdCondition.getApplicationId() != null || thresholdCondition.getApplicationName() == null) continue;
                TeamServerProfile profile = VulnerabilityTrendHelper.getProfile(this.teamServerProfileName);
                for (App app : profile.getApps()) {
                    String subStr = app.getTitle().substring(0, app.getTitle().lastIndexOf(" ("));
                    if (!subStr.equals(thresholdCondition.getApplicationName())) continue;
                    thresholdCondition.setApplicationId(app.getName());
                    continue block1;
                }
            }
        }
        return this;
    }

    private TraceFilterForm buildFilterFormForCondition(ThresholdCondition condition, AbstractBuild<?, ?> build, String appId, BuildListener listener) throws IOException, InterruptedException {
        TraceFilterForm filterForm = new TraceFilterForm();
        if (this.queryBy == 2) {
            String appVersionTag = VulnerabilityTrendHelper.buildAppVersionTagHierarchical(build, appId);
            ArrayList<String> appVersionTagsList = new ArrayList<String>();
            appVersionTagsList.add(appVersionTag);
            if (condition.getApplicationName() != null) {
                String appVersionTagAppName = VulnerabilityTrendHelper.buildAppVersionTagHierarchical(build, condition.getApplicationName());
                appVersionTagsList.add(appVersionTagAppName);
            }
            filterForm.setAppVersionTags(appVersionTagsList);
        } else if (this.queryBy == 3) {
            filterForm.setStartDate(new Date(build.getStartTimeInMillis()));
        } else if (this.queryBy == 4) {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            String appVersionTag = env.get((Object)"APPVERSIONTAG") != null ? (String)env.get((Object)"APPVERSIONTAG") : "";
            if (appVersionTag.isEmpty()) {
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Warning: queryBy Parameter is configured, but APPVERSIONTAG is not set. All vulnerabilities will be returned for this application");
            }
            ArrayList<String> appVersionTagsList = new ArrayList<String>();
            appVersionTagsList.add(appVersionTag);
            filterForm.setAppVersionTags(appVersionTagsList);
        } else {
            String appVersionTag = VulnerabilityTrendHelper.buildAppVersionTag(build, appId);
            ArrayList<String> appVersionTagsList = new ArrayList<String>();
            appVersionTagsList.add(appVersionTag);
            if (condition.getApplicationName() != null) {
                String appVersionTagAppName = VulnerabilityTrendHelper.buildAppVersionTag(build, condition.getApplicationName());
                appVersionTagsList.add(appVersionTagAppName);
            }
            filterForm.setAppVersionTags(appVersionTagsList);
        }
        if (condition.getThresholdSeverity() != null) {
            filterForm.setSeverities(VulnerabilityTrendHelper.getSeverityList(condition.getThresholdSeverity()));
        }
        if (condition.getThresholdVulnType() != null) {
            filterForm.setVulnTypes(Collections.singletonList(condition.getThresholdVulnType()));
        }
        if (!condition.getVulnerabilityStatuses().isEmpty()) {
            filterForm.setStatus(condition.getVulnerabilityStatuses());
        }
        return filterForm;
    }

    private boolean updateBuildResultOnError(AbstractBuild<?, ?> build, TeamServerProfile profile, String message, BuildListener listener) throws AbortException {
        if (profile.isApplyVulnerableBuildResultOnContrastError()) {
            Result profileVulnerableBuildResult = Result.fromString((String)profile.getVulnerableBuildResult());
            if (Result.FAILURE.equals(profileVulnerableBuildResult)) {
                throw new AbortException(message);
            }
            build.setResult(profileVulnerableBuildResult);
            return true;
        }
        VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Warning: Build result was not updated because the connection " + profile.getName() + " is configured to not update the build status when an error occurs.");
        return false;
    }

    private boolean globalThresholdRequired(List<ThresholdCondition> conditions, ContrastSDK contrastSDK, TeamServerProfile profile) throws IOException, UnauthorizedException {
        for (ThresholdCondition condition : conditions) {
            if (profile.isAllowGlobalThresholdConditionsOverride() && this.overrideGlobalThresholdConditions || VulnerabilityTrendHelper.isApplicableEnabledJobOutcomePolicyExist(contrastSDK, profile.getOrgUuid(), condition.getPreparedApplicationId())) continue;
            return true;
        }
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String errorMessage;
        boolean errorEncountered = false;
        if (!build.isBuilding()) {
            return false;
        }
        VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Checking the number of vulnerabilities for this application.");
        HashSet<Trace> resultTraces = new HashSet<Trace>();
        TeamServerProfile profile = VulnerabilityTrendHelper.getProfile(this.teamServerProfileName);
        if (profile == null) {
            throw new AbortException("Unable to find TeamServer profile.");
        }
        String CONTRAST_ERROR_PREFIX = profile.isApplyVulnerableBuildResultOnContrastError() ? "Error: " : "Warning: ";
        ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(profile.getUsername(), profile.getServiceKey(), profile.getApiKey(), profile.getTeamServerUrl());
        try {
            Organizations organizations = contrastSDK.getProfileDefaultOrganizations();
            if (organizations == null || organizations.getOrganization() == null) {
                String errorMessage2 = CONTRAST_ERROR_PREFIX + "No organization found, Check your credentials and URL.";
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage2);
                this.updateBuildResultOnError(build, profile, errorMessage2, listener);
                return true;
            }
        }
        catch (UnauthorizedException | IOException e) {
            String errorMessage3 = CONTRAST_ERROR_PREFIX + "Unable to connect to Contrast.";
            VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage3);
            VulnerabilityTrendHelper.logMessage((TaskListener)listener, e.getMessage());
            this.updateBuildResultOnError(build, profile, errorMessage3, listener);
            return true;
        }
        boolean ignoreContrastFindings = Boolean.parseBoolean((String)build.getBuildVariableResolver().resolve("ignoreContrastFindings"));
        List<GlobalThresholdCondition> globalThresholdConditions = VulnerabilityTrendHelper.getGlobalThresholdConditions(profile.getName());
        List<ThresholdCondition> thresholdConditions = this.conditions;
        for (ThresholdCondition condition : thresholdConditions) {
            MatchBy matchBy = condition.getMatchBy() == null ? MatchBy.APPLICATION_ID : condition.getMatchBy();
            switch (matchBy) {
                case APPLICATION_ORIGIN_NAME: {
                    try {
                        Application app = contrastSDK.getApplicationByNameAndLanguage(profile.getOrgUuid(), condition.getApplicationOriginName(), VulnerabilityTrendHelper.getAgentTypeFromString(condition.getAgentType()));
                        if (app == null) {
                            errorMessage = String.format(CONTRAST_ERROR_PREFIX + "Application with [name = %s, agentType = %s] not found.", condition.getApplicationOriginName(), condition.getAgentType());
                            VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage);
                            if (condition.isFailOnAppNotFound()) {
                                throw new AbortException(errorMessage);
                            }
                            if (this.updateBuildResultOnError(build, profile, errorMessage, listener)) {
                                return true;
                            }
                            errorEncountered = true;
                            break;
                        }
                        condition.setApplicationId(app.getId());
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Fetched Application : [name = '" + condition.getApplicationOriginName() + "', displayName = '" + app.getName() + "', agentType='" + app.getLanguage() + "'] with ID: [" + condition.getPreparedApplicationId() + "]");
                    }
                    catch (UnauthorizedException e) {
                        errorMessage = CONTRAST_ERROR_PREFIX + "Unable to retrieve application information from Contrast.";
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage);
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, e.getMessage());
                        if (this.updateBuildResultOnError(build, profile, errorMessage, listener)) {
                            return true;
                        }
                        errorEncountered = true;
                    }
                    break;
                }
            }
        }
        try {
            if (this.globalThresholdRequired(thresholdConditions, contrastSDK, profile) && (thresholdConditions = VulnerabilityTrendHelper.getThresholdConditions(this.conditions, globalThresholdConditions)).isEmpty()) {
                String errorMessage4 = CONTRAST_ERROR_PREFIX + "Vulnerability Security Controls for connection '" + profile.getName() + "' are not defined.";
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage4);
                if (this.updateBuildResultOnError(build, profile, errorMessage4, listener)) {
                    return true;
                }
                errorEncountered = true;
            }
        }
        catch (UnauthorizedException e) {
            String errorMessage5 = CONTRAST_ERROR_PREFIX + "Unable to retrieve job outcome policy information from Contrast";
            VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage5);
            VulnerabilityTrendHelper.logMessage((TaskListener)listener, e.getMessage());
            this.updateBuildResultOnError(build, profile, errorMessage5, listener);
            return true;
        }
        for (ThresholdCondition condition : thresholdConditions) {
            String appId = condition.getPreparedApplicationId();
            boolean applicationIdExists = VulnerabilityTrendHelper.applicationIdExists(contrastSDK, profile.getOrgUuid(), appId);
            if (!applicationIdExists) {
                errorMessage = CONTRAST_ERROR_PREFIX + "Application with ID '" + appId + "' not found.";
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, CONTRAST_ERROR_PREFIX + "Application with ID '" + appId + "' not found.");
                if (this.updateBuildResultOnError(build, profile, errorMessage, listener)) {
                    return true;
                }
                errorEncountered = true;
                continue;
            }
            try {
                TraceFilterForm filterForm = this.buildFilterFormForCondition(condition, build, appId, listener);
                SecurityCheck securityCheck = VulnerabilityTrendHelper.makeSecurityCheck(contrastSDK, profile.getOrgUuid(), appId, build.getTimeInMillis(), this.queryBy, filterForm);
                if (securityCheck.getResult() != null) {
                    String applicationDisplayForConsoleOutput = condition.getStringForOverriden();
                    VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Checking application " + applicationDisplayForConsoleOutput);
                    VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Your Contrast admin has overridden policies you may have set in Vulnerability Security Controls or the 'query by' parameter");
                    if (securityCheck.getResult().booleanValue()) {
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, "This application did not violate any Contrast policies");
                        return true;
                    }
                    try {
                        Result jobResult = VulnerabilityTrendHelper.getJenkinsResultFromJobOutcome(securityCheck.getJobOutcomePolicy().getOutcome());
                        String message = "This application " + applicationDisplayForConsoleOutput + " violated the Contrast policy '" + securityCheck.getJobOutcomePolicy().getName() + "'";
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, message);
                        if (Result.FAILURE.equals(jobResult)) {
                            throw new AbortException(message);
                        }
                        build.setResult(jobResult);
                        return true;
                    }
                    catch (VulnerabilityTrendHelperException e) {
                        String errorMessage6 = CONTRAST_ERROR_PREFIX + "Unable to retrieve outcome from job outcome policy";
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage6);
                        VulnerabilityTrendHelper.logMessage((TaskListener)listener, e.getMessage());
                        if (this.updateBuildResultOnError(build, profile, errorMessage6, listener)) {
                            return true;
                        }
                        errorEncountered = true;
                        continue;
                    }
                }
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, "filterForm: " + filterForm);
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Checking the threshold condition where " + condition.toString());
                Traces traces = this.queryBy == 3 || this.queryBy == 4 ? VulnerabilityTrendHelper.getAllTraces(contrastSDK, profile.getOrgUuid(), appId, filterForm) : VulnerabilityTrendHelper.getAllTraces(contrastSDK, profile.getOrgUuid(), null, filterForm);
                resultTraces.addAll(traces.getTraces());
                int thresholdCount = condition.getThresholdCount();
                if (traces.getCount() <= thresholdCount || ignoreContrastFindings) continue;
                this.buildResult(resultTraces, build);
                Result buildResult = Result.fromString((String)profile.getVulnerableBuildResult());
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, "Failed on the threshold condition where " + condition.toString());
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, VulnerabilityTrendHelper.getVulnerabilityInfoString(traces));
                if (buildResult.toString().equals(Result.FAILURE.toString())) {
                    throw new AbortException("Failed on the threshold condition where " + condition.toString());
                }
                build.setResult(buildResult);
                return true;
            }
            catch (UnauthorizedException e) {
                String errorMessage7 = CONTRAST_ERROR_PREFIX + "Unable to retrieve vulnerability information from TeamServer.";
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, errorMessage7);
                VulnerabilityTrendHelper.logMessage((TaskListener)listener, e.getMessage());
                if (this.updateBuildResultOnError(build, profile, errorMessage7, listener)) {
                    return true;
                }
                errorEncountered = true;
            }
        }
        this.buildResult(resultTraces, build);
        if (!errorEncountered) {
            VulnerabilityTrendHelper.logMessage((TaskListener)listener, "This build passes all vulnerability threshold conditions!");
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new VulnerabilityTrendProjectAction(project);
    }

    private void buildResult(Set<Trace> traces, AbstractBuild<?, ?> build) {
        HashMap<String, Integer> traceResult = new HashMap<String, Integer>();
        HashMap<String, Integer> severityResult = new HashMap<String, Integer>();
        for (Trace trace : traces) {
            Integer previousCount;
            if (severityResult.containsKey(trace.getSeverity())) {
                previousCount = (Integer)severityResult.get(trace.getSeverity());
                severityResult.put(trace.getSeverity(), previousCount + 1);
            } else {
                severityResult.put(trace.getSeverity(), 1);
            }
            if (traceResult.containsKey(trace.getRule())) {
                previousCount = (Integer)traceResult.get(trace.getRule());
                traceResult.put(trace.getRule(), previousCount + 1);
                continue;
            }
            traceResult.put(trace.getRule(), 1);
        }
        for (String severity : VulnerabilityTrendHelper.SEVERITIES) {
            if (severityResult.containsKey(severity)) continue;
            severityResult.put(severity, 0);
        }
        VulnerabilityTrendResult result = new VulnerabilityTrendResult(traceResult, severityResult);
        build.addAction((Action)new VulnerabilityFrequencyAction(result, build));
    }

    public List<ThresholdCondition> getConditions() {
        return this.conditions;
    }

    public String getTeamServerProfileName() {
        return this.teamServerProfileName;
    }

    public boolean isOverrideGlobalThresholdConditions() {
        return this.overrideGlobalThresholdConditions;
    }

    public int getQueryBy() {
        return this.queryBy;
    }

    public void setConditions(List<ThresholdCondition> conditions) {
        this.conditions = conditions;
    }

    public void setTeamServerProfileName(String teamServerProfileName) {
        this.teamServerProfileName = teamServerProfileName;
    }

    public void setOverrideGlobalThresholdConditions(boolean overrideGlobalThresholdConditions) {
        this.overrideGlobalThresholdConditions = overrideGlobalThresholdConditions;
    }

    public void setQueryBy(int queryBy) {
        this.queryBy = queryBy;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<ThresholdCondition> conditions;
        private String teamServerProfileName;
        private Boolean overrideGlobalThresholdConditions;
        private Integer queryBy;

        public DescriptorImpl() {
            super(VulnerabilityTrendRecorder.class);
            this.load();
        }

        @JavaScriptMethod
        public boolean isAllowGlobalThresholdConditionsOverride(String teamServerProfileName) {
            return VulnerabilityTrendHelper.getProfile(teamServerProfileName).isAllowGlobalThresholdConditionsOverride();
        }

        public ListBoxModel doFillTeamServerProfileNameItems() {
            return VulnerabilityTrendHelper.getProfileNames();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Contrast Assess";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject json) {
            JSONArray array = json.optJSONArray("conditions");
            if (array != null) {
                this.conditions = req.bindJSONToList(ThresholdCondition.class, (Object)array);
            } else {
                this.conditions = new ArrayList<ThresholdCondition>();
                if (!json.keySet().isEmpty()) {
                    this.conditions.add((ThresholdCondition)((Object)req.bindJSON(ThresholdCondition.class, json.getJSONObject("conditions"))));
                }
            }
            this.teamServerProfileName = (String)json.get("teamServerProfileName");
            this.overrideGlobalThresholdConditions = (Boolean)json.get("overrideGlobalThresholdConditions");
            this.queryBy = Integer.parseInt((String)json.get("queryBy"));
            this.save();
            return new VulnerabilityTrendRecorder(this.conditions, this.teamServerProfileName, this.overrideGlobalThresholdConditions, this.queryBy);
        }

        public List<ThresholdCondition> getConditions() {
            return this.conditions;
        }

        public void setConditions(List<ThresholdCondition> conditions) {
            this.conditions = conditions;
        }
    }
}

