/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.App;
import com.aspectsecurity.contrast.contrastjenkins.ContrastPluginConfig;
import com.aspectsecurity.contrast.contrastjenkins.GlobalThresholdCondition;
import com.aspectsecurity.contrast.contrastjenkins.TeamServerProfile;
import com.aspectsecurity.contrast.contrastjenkins.ThresholdCondition;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelperException;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityType;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.http.RuleSeverity;
import com.contrastsecurity.http.SecurityCheckFilter;
import com.contrastsecurity.http.SecurityCheckForm;
import com.contrastsecurity.http.TraceFilterForm;
import com.contrastsecurity.models.AgentType;
import com.contrastsecurity.models.Application;
import com.contrastsecurity.models.Applications;
import com.contrastsecurity.models.JobOutcomePolicy;
import com.contrastsecurity.models.Rules;
import com.contrastsecurity.models.SecurityCheck;
import com.contrastsecurity.models.Trace;
import com.contrastsecurity.models.Traces;
import com.contrastsecurity.sdk.ContrastSDK;
import hudson.ProxyConfiguration;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class VulnerabilityTrendHelper {
    public static final String EMPTY_SELECT = "All";
    public static final List<String> SEVERITIES = Collections.unmodifiableList(Arrays.asList("Note", "Low", "Medium", "High", "Critical"));

    public static ContrastSDK createSDK(String username, String serviceKey, String apiKey, String teamServerUrl) {
        Proxy proxy;
        Jenkins jenkinsInstance = Jenkins.getInstance();
        ProxyConfiguration proxyConfig = null;
        if (jenkinsInstance != null) {
            proxyConfig = jenkinsInstance.proxy;
        }
        URL url = null;
        Proxy proxyToUse = Proxy.NO_PROXY;
        try {
            url = new URL(teamServerUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (proxyConfig != null && url != null && (proxy = proxyConfig.createProxy(url.getHost())) != null && proxy.type() == Proxy.Type.HTTP) {
            proxyToUse = proxy;
        }
        ContrastSDK contrastSDK = new ContrastSDK.Builder(username, serviceKey, apiKey).withApiUrl(teamServerUrl).withProxy(proxyToUse).build();
        return contrastSDK;
    }

    public static TeamServerProfile getProfile(String profileName) {
        if (profileName == null) {
            return null;
        }
        ContrastPluginConfig.ContrastPluginConfigDescriptor contrastPluginConfigDescriptor = new ContrastPluginConfig.ContrastPluginConfigDescriptor();
        TeamServerProfile[] profiles = contrastPluginConfigDescriptor.getTeamServerProfiles();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)profileName)) {
            return profiles[0];
        }
        for (TeamServerProfile profile : profiles) {
            if (!profileName.trim().equalsIgnoreCase(profile.getName().trim())) continue;
            return profile;
        }
        return null;
    }

    public static TeamServerProfile getProfile(String profileName, ContrastPluginConfig.ContrastPluginConfigDescriptor contrastPluginConfigDescriptor) {
        if (profileName == null) {
            return null;
        }
        TeamServerProfile[] profiles = contrastPluginConfigDescriptor.getTeamServerProfiles();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)profileName)) {
            return profiles[0];
        }
        for (TeamServerProfile profile : profiles) {
            if (!profileName.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    public static List<GlobalThresholdCondition> getGlobalThresholdConditions(String profileName) {
        GlobalThresholdCondition[] globalThresholdConditions = new ContrastPluginConfig.ContrastPluginConfigDescriptor().getGlobalThresholdConditions();
        ArrayList<GlobalThresholdCondition> globalThresholdConditionList = new ArrayList<GlobalThresholdCondition>();
        if (globalThresholdConditions[0] == null) {
            return null;
        }
        for (GlobalThresholdCondition globalThresholdCondition : globalThresholdConditions) {
            if (!profileName.equals(globalThresholdCondition.getTeamServerProfileName())) continue;
            globalThresholdConditionList.add(globalThresholdCondition);
        }
        return globalThresholdConditionList;
    }

    public static List<ThresholdCondition> getThresholdConditions(List<ThresholdCondition> thresholdConditions, List<GlobalThresholdCondition> globalThresholdConditions) {
        ArrayList<ThresholdCondition> newThresholdConditions = new ArrayList<ThresholdCondition>();
        if (thresholdConditions == null || globalThresholdConditions == null) {
            return newThresholdConditions;
        }
        for (ThresholdCondition thresholdCondition : thresholdConditions) {
            for (GlobalThresholdCondition globalThresholdCondition : globalThresholdConditions) {
                ThresholdCondition newThresholdCondition = new ThresholdCondition(globalThresholdCondition.getThresholdCount(), globalThresholdCondition.getThresholdSeverity(), globalThresholdCondition.getThresholdVulnType(), thresholdCondition.getApplicationState(), thresholdCondition.getApplicationDefinition(), thresholdCondition.getApplicationId(), globalThresholdCondition.isAutoRemediated(), globalThresholdCondition.isConfirmed(), globalThresholdCondition.isSuspicious(), globalThresholdCondition.isNotAProblem(), globalThresholdCondition.isRemediated(), globalThresholdCondition.isReported(), globalThresholdCondition.isFixed(), globalThresholdCondition.isBeingTracked(), globalThresholdCondition.isUntracked());
                if (thresholdCondition.getApplicationName() != null) {
                    newThresholdCondition.setApplicationName(thresholdCondition.getApplicationName());
                }
                newThresholdConditions.add(newThresholdCondition);
            }
        }
        return newThresholdConditions;
    }

    public static void logMessage(TaskListener listener, String msg) {
        listener.getLogger().println("[Contrast] - " + msg);
    }

    public static EnumSet<RuleSeverity> getSeverityList(String severity) {
        List<String> severityList = SEVERITIES.subList(SEVERITIES.indexOf(severity), SEVERITIES.size());
        ArrayList<RuleSeverity> ruleSeverities = new ArrayList<RuleSeverity>();
        for (String severityToAdd : severityList) {
            ruleSeverities.add(RuleSeverity.valueOf((String)severityToAdd.toUpperCase()));
        }
        return EnumSet.copyOf(ruleSeverities);
    }

    public static List<VulnerabilityType> saveRules(ContrastSDK sdk, String organizationUuid) {
        Rules rules;
        ArrayList<VulnerabilityType> vulnerabilityTypes = new ArrayList<VulnerabilityType>();
        try {
            rules = sdk.getRules(organizationUuid);
        }
        catch (UnauthorizedException | IOException e) {
            return vulnerabilityTypes;
        }
        for (Rules.Rule rule : rules.getRules()) {
            vulnerabilityTypes.add(new VulnerabilityType(rule.getName(), rule.getTitle()));
        }
        return vulnerabilityTypes;
    }

    public static ListBoxModel getSeverityListBoxModel() {
        ListBoxModel items = new ListBoxModel();
        items.add(EMPTY_SELECT, null);
        for (String severity : SEVERITIES) {
            items.add(severity, severity);
        }
        return items;
    }

    public static ListBoxModel getProfileNames() {
        ListBoxModel model = new ListBoxModel();
        for (TeamServerProfile profile : new ContrastPluginConfig.ContrastPluginConfigDescriptor().getTeamServerProfiles()) {
            model.add(profile.getName(), profile.getName());
        }
        return model;
    }

    public static ListBoxModel getVulnerabilityTypes(String teamServerProfileName) {
        ListBoxModel items = new ListBoxModel();
        TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(teamServerProfileName);
        items.add(EMPTY_SELECT, null);
        if (teamServerProfile != null) {
            for (VulnerabilityType vulnerabilityType : teamServerProfile.getVulnerabilityTypes()) {
                items.add(vulnerabilityType.getTitle(), vulnerabilityType.getName());
            }
        }
        return items;
    }

    public static ListBoxModel getAgentTypeListBoxModel() {
        ListBoxModel items = new ListBoxModel();
        items.add("Java", AgentType.JAVA.toString());
        items.add(".NET", AgentType.DOTNET.toString());
        items.add("Node", AgentType.NODE.toString());
        items.add("Ruby", AgentType.RUBY.toString());
        items.add("Python", AgentType.PYTHON.toString());
        items.add(".NET_Core", AgentType.DOTNET_CORE.toString());
        items.add("Proxy", AgentType.PROXY.toString());
        return items;
    }

    public static AgentType getAgentTypeFromString(String type) {
        switch (type.toUpperCase()) {
            case ".NET": {
                return AgentType.DOTNET;
            }
            case "NODE": {
                return AgentType.NODE;
            }
            case "RUBY": {
                return AgentType.RUBY;
            }
            case "PYTHON": {
                return AgentType.PYTHON;
            }
            case ".NET_CORE": {
                return AgentType.DOTNET_CORE;
            }
            case "PROXY": {
                return AgentType.PROXY;
            }
        }
        return AgentType.JAVA;
    }

    public static String getDefaultAgentFileNameFromString(String type) {
        switch (type.toUpperCase()) {
            case ".NET": {
                return "dotnet-contrast.zip";
            }
            case "NODE": {
                return "node-contrast.tgz";
            }
            case "RUBY": {
                return "ruby-contrast.gem";
            }
            case "PYTHON": {
                return "python-contrast.tar.gz";
            }
            case ".NET_CORE": {
                return "dotnet_core-contrast.zip";
            }
        }
        return "contrast.jar";
    }

    public static String buildAppVersionTag(Run<?, ?> build, String applicationId) {
        return applicationId + "-" + build.getNumber();
    }

    public static String buildAppVersionTagHierarchical(Run<?, ?> build, String applicationId) {
        return applicationId + "-" + build.getParent().getFullName() + "-" + build.getNumber();
    }

    public static String getVulnerabilityInfoString(Traces traces) {
        StringBuilder info = new StringBuilder();
        int note = 0;
        int low = 0;
        int medium = 0;
        int high = 0;
        int critical = 0;
        if (traces == null || traces.getTraces() == null || traces.getTraces().isEmpty()) {
            return info.toString();
        }
        info.append("Found vulnerabilities: ");
        for (Trace trace : traces.getTraces()) {
            switch (trace.getSeverity()) {
                case "Note": {
                    ++note;
                    break;
                }
                case "Low": {
                    ++low;
                    break;
                }
                case "Medium": {
                    ++medium;
                    break;
                }
                case "High": {
                    ++high;
                    break;
                }
                case "Critical": {
                    ++critical;
                    break;
                }
            }
        }
        if (note > 0) {
            info.append("Note - " + String.valueOf(note) + " ");
        }
        if (low > 0) {
            info.append("Low - " + String.valueOf(low) + " ");
        }
        if (medium > 0) {
            info.append("Medium - " + String.valueOf(medium) + " ");
        }
        if (high > 0) {
            info.append("High - " + String.valueOf(high) + " ");
        }
        if (critical > 0) {
            info.append("Critical - " + String.valueOf(critical) + " ");
        }
        info.append(".");
        return info.toString();
    }

    public static Traces getAllTraces(ContrastSDK sdk, String organizationId, String applicationId, TraceFilterForm filter) throws IOException, UnauthorizedException {
        Traces traces = new Traces();
        int page = 0;
        int pageSize = 50;
        filter.setLimit(pageSize);
        do {
            filter.setOffset(page * pageSize);
            Traces intermediateTraces = applicationId == null ? sdk.getTracesInOrg(organizationId, filter) : sdk.getTraces(organizationId, applicationId, filter);
            if (page == 0) {
                traces = intermediateTraces;
            } else {
                traces.getTraces().addAll(intermediateTraces.getTraces());
            }
            ++page;
        } while (traces.getTraces().size() < traces.getCount());
        return traces;
    }

    static boolean applicationIdExists(ContrastSDK sdk, String organizationUuid, String applicationId) {
        Applications applications;
        if (applicationId == null || applicationId.isEmpty()) {
            return false;
        }
        try {
            applications = sdk.getApplications(organizationUuid);
        }
        catch (UnauthorizedException | IOException e) {
            return false;
        }
        for (Application application : applications.getApplications()) {
            if (!applicationId.equals(application.getId())) continue;
            return true;
        }
        return false;
    }

    public static ListBoxModel getApplicationIds(String teamServerProfileName) {
        ListBoxModel items = new ListBoxModel();
        TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(teamServerProfileName);
        if (teamServerProfile != null) {
            for (App app : teamServerProfile.getApps()) {
                items.add(app.getTitle(), app.getName());
            }
        }
        return items;
    }

    public static ComboBoxModel getApplicationIdsComboBoxModel(String teamServerProfileName) {
        ComboBoxModel items = new ComboBoxModel();
        TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(teamServerProfileName);
        if (teamServerProfile != null) {
            for (App app : teamServerProfile.getApps()) {
                items.add((Object)app.getTitle());
            }
        }
        return items;
    }

    public static boolean appExistsInProfile(String teamServerProfileName, String appTitle) {
        TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(teamServerProfileName);
        if (teamServerProfile != null) {
            for (App app : teamServerProfile.getApps()) {
                if (!appTitle.equals(app.getTitle()) && !appTitle.equals(app.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String getAppIdFromAppTitle(String appTitle) {
        int beginIndex = StringUtils.lastIndexOf((String)appTitle, (String)"(");
        int endIndex = StringUtils.lastIndexOf((String)appTitle, (String)")");
        if (beginIndex >= 0 && endIndex >= 0 && endIndex > beginIndex) {
            return appTitle.substring(beginIndex + 1, endIndex);
        }
        return null;
    }

    public static String getAppNameFromAppTitle(String appTitle) {
        return appTitle.substring(0, appTitle.lastIndexOf(" ("));
    }

    public static List<App> saveApplicationIds(ContrastSDK sdk, String organizationUuid) {
        Applications applications;
        ArrayList<App> apps = new ArrayList<App>();
        try {
            applications = sdk.getApplications(organizationUuid);
        }
        catch (UnauthorizedException | IOException e) {
            return apps;
        }
        for (Application application : applications.getApplications()) {
            apps.add(new App(application.getId(), application.getName() + " (" + application.getId() + ")"));
        }
        return apps;
    }

    public static SecurityCheck makeSecurityCheck(ContrastSDK sdk, String organizationUuid, String applicationId, Long jobStartTime, int queryBy, TraceFilterForm filterForm) throws IOException, UnauthorizedException {
        SecurityCheckForm form = new SecurityCheckForm(applicationId);
        form.setJobStartTime(jobStartTime);
        SecurityCheckFilter securityCheckFilter = new SecurityCheckFilter();
        if (3 == queryBy) {
            securityCheckFilter.setQueryBy(SecurityCheckFilter.QueryBy.START_DATE);
            securityCheckFilter.setStartDate(Long.valueOf(filterForm.getStartDate().toInstant().toEpochMilli()));
        } else {
            securityCheckFilter.setQueryBy(SecurityCheckFilter.QueryBy.APP_VERSION_TAG);
            securityCheckFilter.setAppVersionTags(filterForm.getAppVersionTags());
        }
        form.setSecurityCheckFilter(securityCheckFilter);
        return sdk.makeSecurityCheck(organizationUuid, form);
    }

    public static Result getJenkinsResultFromJobOutcome(JobOutcomePolicy.Outcome outcome) throws VulnerabilityTrendHelperException {
        switch (outcome) {
            case FAIL: {
                return Result.FAILURE;
            }
            case SUCCESS: {
                return Result.SUCCESS;
            }
            case UNSTABLE: {
                return Result.UNSTABLE;
            }
        }
        throw new VulnerabilityTrendHelperException("Unrecognized Job Outcome: " + outcome.toString());
    }

    public static boolean isEnabledJobOutcomePolicyExist(ContrastSDK sdk, String organizationUuid) throws IOException, UnauthorizedException {
        return sdk.getEnabledJobOutcomePolicies(organizationUuid).size() > 0;
    }

    public static boolean isApplicableEnabledJobOutcomePolicyExist(ContrastSDK sdk, String organizationUuid, String applicationId) throws IOException, UnauthorizedException {
        return VulnerabilityTrendHelper.applicationIdExists(sdk, organizationUuid, applicationId) && sdk.getEnabledJoboutcomePoliciesByApplication(organizationUuid, applicationId).size() > 0;
    }
}

