/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.ApplicationDefinition;
import com.aspectsecurity.contrast.contrastjenkins.ContrastPluginConfig;
import com.aspectsecurity.contrast.contrastjenkins.MatchBy;
import com.aspectsecurity.contrast.contrastjenkins.TeamServerProfile;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelper;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.sdk.ContrastSDK;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringJoiner;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ThresholdCondition
extends AbstractDescribableImpl<ThresholdCondition> {
    private Integer thresholdCount;
    private String thresholdSeverity;
    private String thresholdVulnType;
    private ApplicationDefinition applicationDefinition;
    private String applicationId;
    private String applicationName;
    private String applicationOriginName;
    private String agentType;
    private boolean failOnAppNotFound;
    private int applicationState;
    private MatchBy matchBy;
    private boolean autoRemediated;
    private boolean confirmed;
    private boolean suspicious;
    private boolean notAProblem;
    private boolean remediated;
    private boolean reported;
    private boolean fixed;
    private boolean beingTracked;
    private boolean untracked;

    @DataBoundSetter
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @DataBoundConstructor
    public ThresholdCondition(Integer thresholdCount, String thresholdSeverity, String thresholdVulnType, int applicationState, ApplicationDefinition applicationDefinition, String applicationId, boolean autoRemediated, boolean confirmed, boolean suspicious, boolean notAProblem, boolean remediated, boolean reported, boolean fixed, boolean beingTracked, boolean untracked) {
        this.thresholdCount = thresholdCount;
        this.thresholdSeverity = thresholdSeverity;
        this.thresholdVulnType = thresholdVulnType;
        this.applicationDefinition = applicationDefinition;
        this.applicationId = applicationId;
        this.applicationState = applicationState;
        if (applicationState == 0) {
            this.matchBy = MatchBy.APPLICATION_ID;
        } else if (applicationDefinition != null) {
            this.matchBy = applicationDefinition.getMatchBy();
            this.applicationOriginName = applicationDefinition.getApplicationOriginName();
            this.agentType = applicationDefinition.getAgentType();
            this.failOnAppNotFound = applicationDefinition.isFailOnAppNotFound();
        }
        this.autoRemediated = autoRemediated;
        this.confirmed = confirmed;
        this.suspicious = suspicious;
        this.notAProblem = notAProblem;
        this.remediated = remediated;
        this.reported = reported;
        this.fixed = fixed;
        this.beingTracked = beingTracked;
        this.untracked = untracked;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("count is ").append(this.thresholdCount);
        if (this.thresholdSeverity != null) {
            sb.append(", severity is ").append(this.thresholdSeverity);
        }
        if (this.thresholdVulnType != null) {
            sb.append(", rule type is ").append(this.thresholdVulnType);
        }
        if (this.applicationId != null) {
            sb.append(", application ID is ").append(this.applicationId);
        }
        sb.append(".");
        return sb.toString();
    }

    public String getStringForOverriden() {
        StringJoiner sj = new StringJoiner(", ");
        String preString = "[";
        String postString = "]";
        if (this.applicationOriginName != null) {
            sj.add("name='" + this.applicationOriginName + "'");
        }
        if (this.agentType != null) {
            sj.add("language='" + this.agentType + "'");
        }
        if (this.applicationId != null) {
            sj.add("applicationId='" + this.getPreparedApplicationId() + "'");
        }
        if (this.applicationId != null && this.applicationOriginName == null) {
            sj.add(this.applicationId);
        }
        return preString + sj.toString() + postString;
    }

    public String getPreparedApplicationId() {
        if (VulnerabilityTrendHelper.getAppIdFromAppTitle(this.applicationId) != null) {
            return VulnerabilityTrendHelper.getAppIdFromAppTitle(this.applicationId);
        }
        return this.applicationId;
    }

    public List<String> getVulnerabilityStatuses() {
        ArrayList<String> status = new ArrayList<String>();
        if (this.autoRemediated) {
            status.add("Auto-Remediated");
        }
        if (this.confirmed) {
            status.add("Confirmed");
        }
        if (this.suspicious) {
            status.add("Suspicious");
        }
        if (this.notAProblem) {
            status.add("NotAProblem");
        }
        if (this.remediated) {
            status.add("Remediated");
        }
        if (this.reported) {
            status.add("Reported");
        }
        if (this.fixed) {
            status.add("Fixed");
        }
        if (this.beingTracked) {
            status.add("Being+Tracked");
        }
        if (this.untracked) {
            status.add("Untracked");
        }
        return status;
    }

    public void setThresholdCount(Integer thresholdCount) {
        this.thresholdCount = thresholdCount;
    }

    public Integer getThresholdCount() {
        return this.thresholdCount;
    }

    public void setThresholdSeverity(String thresholdSeverity) {
        this.thresholdSeverity = thresholdSeverity;
    }

    public String getThresholdSeverity() {
        return this.thresholdSeverity;
    }

    public void setThresholdVulnType(String thresholdVulnType) {
        this.thresholdVulnType = thresholdVulnType;
    }

    public String getThresholdVulnType() {
        return this.thresholdVulnType;
    }

    public void setApplicationDefinition(ApplicationDefinition applicationDefinition) {
        this.applicationDefinition = applicationDefinition;
    }

    public ApplicationDefinition getApplicationDefinition() {
        return this.applicationDefinition;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationOriginName(String applicationOriginName) {
        this.applicationOriginName = applicationOriginName;
    }

    public String getApplicationOriginName() {
        return this.applicationOriginName;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public void setFailOnAppNotFound(boolean failOnAppNotFound) {
        this.failOnAppNotFound = failOnAppNotFound;
    }

    public boolean isFailOnAppNotFound() {
        return this.failOnAppNotFound;
    }

    public void setApplicationState(int applicationState) {
        this.applicationState = applicationState;
    }

    public int getApplicationState() {
        return this.applicationState;
    }

    public void setMatchBy(MatchBy matchBy) {
        this.matchBy = matchBy;
    }

    public MatchBy getMatchBy() {
        return this.matchBy;
    }

    public void setAutoRemediated(boolean autoRemediated) {
        this.autoRemediated = autoRemediated;
    }

    public boolean isAutoRemediated() {
        return this.autoRemediated;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setSuspicious(boolean suspicious) {
        this.suspicious = suspicious;
    }

    public boolean isSuspicious() {
        return this.suspicious;
    }

    public void setNotAProblem(boolean notAProblem) {
        this.notAProblem = notAProblem;
    }

    public boolean isNotAProblem() {
        return this.notAProblem;
    }

    public void setRemediated(boolean remediated) {
        this.remediated = remediated;
    }

    public boolean isRemediated() {
        return this.remediated;
    }

    public void setReported(boolean reported) {
        this.reported = reported;
    }

    public boolean isReported() {
        return this.reported;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setBeingTracked(boolean beingTracked) {
        this.beingTracked = beingTracked;
    }

    public boolean isBeingTracked() {
        return this.beingTracked;
    }

    public void setUntracked(boolean untracked) {
        this.untracked = untracked;
    }

    public boolean isUntracked() {
        return this.untracked;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ThresholdCondition> {
        Calendar lastAppsRefresh;
        int appsRefreshIntervalMinutes = 1;

        public FormValidation doCheckThresholdCount(@QueryParameter String value) {
            block4: {
                if (!value.isEmpty()) {
                    try {
                        int temp = Integer.parseInt(value);
                        if (temp < 0) {
                            return FormValidation.error((String)"Please enter a positive integer.");
                        }
                        break block4;
                    }
                    catch (NumberFormatException e) {
                        return FormValidation.error((String)"Please enter a valid integer.");
                    }
                }
                return FormValidation.error((String)"Please enter a positive integer.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckThresholdSeverity(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckThresholdVulnType(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckApplicationId(@QueryParameter(value="teamServerProfileName") @RelativePath(value="..") String teamServerProfileName, @QueryParameter String value) {
            block6: {
                if (VulnerabilityTrendHelper.appExistsInProfile(teamServerProfileName, value)) {
                    TeamServerProfile profile = VulnerabilityTrendHelper.getProfile(teamServerProfileName);
                    ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(profile.getUsername(), profile.getServiceKey(), profile.getApiKey(), profile.getTeamServerUrl());
                    String appId = value;
                    if (value.contains("(") && value.contains(")")) {
                        appId = VulnerabilityTrendHelper.getAppIdFromAppTitle(value);
                    }
                    try {
                        if (VulnerabilityTrendHelper.isApplicableEnabledJobOutcomePolicyExist(contrastSDK, profile.getOrgUuid(), appId)) {
                            return FormValidation.warning((String)"Your Contrast administrator has set a policy for vulnerability thresholds for this application. The Contrast policy overrides Jenkins vulnerability security controls and 'query vulnerabilities by' selection.");
                        }
                        break block6;
                    }
                    catch (UnauthorizedException | IOException e) {
                        return FormValidation.warning((String)("Unable to make connection with Contrast: " + e.getMessage()));
                    }
                }
                if (!value.isEmpty()) {
                    return FormValidation.warning((String)"Application not found.");
                }
            }
            return FormValidation.ok();
        }

        public ComboBoxModel doFillApplicationIdItems(@QueryParameter(value="teamServerProfileName") @RelativePath(value="..") String teamServerProfileName) {
            if (this.lastAppsRefresh == null || (Calendar.getInstance().getTimeInMillis() - this.lastAppsRefresh.getTimeInMillis()) / 60000L >= (long)this.appsRefreshIntervalMinutes) {
                this.refreshApps(teamServerProfileName);
                this.lastAppsRefresh = Calendar.getInstance();
            }
            return VulnerabilityTrendHelper.getApplicationIdsComboBoxModel(teamServerProfileName);
        }

        public void refreshApps(String teamServerProfileName) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                ContrastPluginConfig.ContrastPluginConfigDescriptor contrastPluginConfigDescriptor = (ContrastPluginConfig.ContrastPluginConfigDescriptor)jenkins.getDescriptorByType(ContrastPluginConfig.ContrastPluginConfigDescriptor.class);
                TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(teamServerProfileName, contrastPluginConfigDescriptor);
                ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(teamServerProfile.getUsername(), teamServerProfile.getServiceKey(), teamServerProfile.getApiKey(), teamServerProfile.getTeamServerUrl());
                teamServerProfile.setApps(VulnerabilityTrendHelper.saveApplicationIds(contrastSDK, teamServerProfile.getOrgUuid()));
                contrastPluginConfigDescriptor.save();
            }
        }

        public ListBoxModel doFillAgentTypeItems() {
            return VulnerabilityTrendHelper.getAgentTypeListBoxModel();
        }

        public ListBoxModel doFillThresholdVulnTypeItems(@QueryParameter(value="teamServerProfileName") @RelativePath(value="..") String teamServerProfileName) throws IOException {
            return VulnerabilityTrendHelper.getVulnerabilityTypes(teamServerProfileName);
        }

        public ListBoxModel doFillThresholdSeverityItems() {
            return VulnerabilityTrendHelper.getSeverityListBoxModel();
        }

        public String getDisplayName() {
            return "Threshold Condition";
        }
    }
}

