/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.Cons3rtPublisher;
import io.jenkins.plugins.datatype.Network;
import io.jenkins.plugins.utils.HttpWrapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

public class Cons3rtSite
extends AbstractDescribableImpl<Cons3rtSite> {
    public static final Logger LOGGER = Logger.getLogger(Cons3rtSite.class.getName());
    public static final List<DomainRequirement> NO_REQUIREMENTS = Collections.emptyList();
    public static final String certificateAuthentication = "certificate";
    public static final String usernameAuthentication = "username";
    String url;
    String tokenId;
    String token;
    String authenticationType;
    String username;
    String certificateId;
    StandardCertificateCredentials certificate;

    @DataBoundConstructor
    public Cons3rtSite(String url, String tokenId, String authenticationType, String certificateId, String username) {
        this.url = url;
        this.tokenId = tokenId;
        LOGGER.log(Level.INFO, "Set site url to: " + this.url + " and tokenId to: " + this.tokenId);
        StringCredentials tokenCredential = this.lookupTokenCredentialsById(tokenId);
        if (tokenCredential != null) {
            this.token = tokenCredential.getSecret().getPlainText();
            LOGGER.log(Level.INFO, "Set token to: " + this.token);
        } else {
            LOGGER.log(Level.WARNING, "Could not find token credential for id");
        }
        this.authenticationType = authenticationType;
        LOGGER.log(Level.INFO, "Received Authentication type of: " + this.authenticationType);
        switch (this.authenticationType) {
            case "username": {
                this.setCertificate(null);
                this.setCertificateId(null);
                this.username = username;
                LOGGER.log(Level.INFO, "Based on username authentication. Set username to: " + this.username + " and purged certificate information.");
                break;
            }
            case "certificate": {
                this.setUsername(null);
                this.certificateId = certificateId;
                LOGGER.log(Level.INFO, "Based on certificate authentication. Set certificateId to: " + this.certificateId + " and purged username information.");
                StandardCertificateCredentials certificateCredential = this.lookupCertificateCredentialsById(certificateId);
                if (certificateCredential != null) {
                    this.certificate = certificateCredential;
                    LOGGER.log(Level.INFO, "Set certificate to " + this.certificate.getDescription());
                    break;
                }
                LOGGER.log(Level.WARNING, "Could not find certificate credential for id");
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Default case.");
                this.setCertificate(null);
                this.setCertificateId(null);
                this.username = username;
                LOGGER.log(Level.INFO, "Based on username authentication. Set username to: " + this.username + " and purged certificate information.");
            }
        }
        LOGGER.log(Level.INFO, "Site: authentication type " + authenticationType + " username " + username + " certificate id " + certificateId);
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public StandardCertificateCredentials getCertificate() {
        return this.certificate;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public void setCertificate(StandardCertificateCredentials certificate) {
        this.certificate = certificate;
    }

    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private StringCredentials lookupTokenCredentialsById(String tokenCredentialId) {
        HashSet all = new HashSet();
        Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
        List userBased = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)Jenkins.getAuthentication(), NO_REQUIREMENTS);
        List jobBased = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), NO_REQUIREMENTS);
        all.addAll(userBased);
        all.addAll(jobBased);
        return (StringCredentials)CredentialsMatchers.firstOrNull(all, (CredentialsMatcher)CredentialsMatchers.withId((String)tokenCredentialId));
    }

    private StandardCertificateCredentials lookupCertificateCredentialsById(String certificateCredentialId) {
        HashSet all = new HashSet();
        Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
        List userBased = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)item, (Authentication)Jenkins.getAuthentication(), NO_REQUIREMENTS);
        List jobBased = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), NO_REQUIREMENTS);
        all.addAll(userBased);
        all.addAll(jobBased);
        return (StandardCertificateCredentials)CredentialsMatchers.firstOrNull(all, (CredentialsMatcher)CredentialsMatchers.withId((String)certificateCredentialId));
    }

    public boolean isAuthenticationType(String given) {
        return this.authenticationType.equals(given);
    }

    public String authenticationTypeEquals(String given) {
        String retval = String.valueOf(this.authenticationType != null && this.authenticationType.equals(given));
        Cons3rtPublisher.LOGGER.log(Level.INFO, "given: " + given + " authentication equals: " + retval);
        return retval;
    }

    public void testConnection(Logger logger) throws HttpWrapper.HTTPException {
        HttpWrapper.HttpWrapperBuilder builder = new HttpWrapper.HttpWrapperBuilder(this.url, this.token, this.authenticationType);
        if (Cons3rtPublisher.isCeritificateAuthentication(this.authenticationType)) {
            builder.certificate(this.certificate);
        } else if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
            builder.username(this.username);
        }
        HttpWrapper wrapper = builder.build();
        String result = wrapper.validateCredentials();
        logger.log(Level.INFO, "Attempt to validate connection returned: " + result);
    }

    public Set<Map.Entry<String, Integer>> getAvailableProjects(Logger logger) throws HttpWrapper.HTTPException {
        HttpWrapper.HttpWrapperBuilder builder = new HttpWrapper.HttpWrapperBuilder(this.url, this.token, this.authenticationType);
        if (Cons3rtPublisher.isCeritificateAuthentication(this.authenticationType)) {
            builder.certificate(this.certificate);
        } else if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
            builder.username(this.username);
        }
        HttpWrapper wrapper = builder.build();
        return wrapper.getProjects();
    }

    public Set<Map.Entry<String, Integer>> getAvailableCloudspaces(Logger logger, Integer deploymentId) throws HttpWrapper.HTTPException {
        LOGGER.info("Attempting to get available cloudspaces for deployment id: " + deploymentId + " in site with url: " + this.getUrl());
        HttpWrapper.HttpWrapperBuilder builder = new HttpWrapper.HttpWrapperBuilder(this.url, this.token, this.authenticationType);
        if (Cons3rtPublisher.isCeritificateAuthentication(this.authenticationType)) {
            builder.certificate(this.certificate);
        } else if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
            builder.username(this.username);
        }
        HttpWrapper wrapper = builder.build();
        return wrapper.getCloudspaces(deploymentId);
    }

    public Set<String> getHostRoles(Logger logger, Integer deploymentId) throws HttpWrapper.HTTPException {
        HttpWrapper.HttpWrapperBuilder builder = new HttpWrapper.HttpWrapperBuilder(this.url, this.token, this.authenticationType);
        if (Cons3rtPublisher.isCeritificateAuthentication(this.authenticationType)) {
            builder.certificate(this.certificate);
        } else if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
            builder.username(this.username);
        }
        HttpWrapper wrapper = builder.build();
        return wrapper.getRoles(deploymentId);
    }

    public Set<Network> getAvailableNetworks(Logger logger, Integer deploymentId, Integer cloudspaceId) throws HttpWrapper.HTTPException {
        HttpWrapper.HttpWrapperBuilder builder = new HttpWrapper.HttpWrapperBuilder(this.url, this.token, this.authenticationType);
        if (Cons3rtPublisher.isCeritificateAuthentication(this.authenticationType)) {
            builder.certificate(this.certificate);
        } else if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
            builder.username(this.username);
        }
        HttpWrapper wrapper = builder.build();
        return wrapper.getNetworks(deploymentId, cloudspaceId);
    }

    public static Cons3rtSite fromStapler(@RelativePath(value="../site") @QueryParameter String url, @RelativePath(value="../site") @QueryParameter String tokenId, @RelativePath(value="../site") @QueryParameter String authenticationType, @RelativePath(value="../site") @QueryParameter String certificateId, @RelativePath(value="../site") @QueryParameter String username) {
        LOGGER.info("From Stapler got url: " + url + " and auth type: " + (certificateId != null ? certificateAuthentication : usernameAuthentication));
        if (url != null && tokenId != null) {
            if (certificateId != null && !certificateId.isEmpty()) {
                return new Cons3rtSite(url, tokenId, certificateAuthentication, certificateId, username);
            }
            if (username != null) {
                return new Cons3rtSite(url, tokenId, usernameAuthentication, certificateId, username);
            }
            return null;
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cons3rtSite> {
        public static final Logger LOGGER = Logger.getLogger(Cons3rtSite.class.getName());

        public String getDisplayName() {
            return "CONS3RT Site";
        }

        public ListBoxModel doFillCertificateIdItems(@AncestorInPath Item job) {
            ListBoxModel result = new ListBoxModel();
            HashSet creds = new HashSet();
            HashSet<String> ids = new HashSet<String>();
            List userBased = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)job, (Authentication)Jenkins.getAuthentication(), NO_REQUIREMENTS);
            List jobBased = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)job, (Authentication)(job instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)job)) : ACL.SYSTEM), NO_REQUIREMENTS);
            creds.addAll(userBased);
            creds.addAll(jobBased);
            for (StandardCertificateCredentials cred : creds) {
                if (!ids.add(cred.getId())) continue;
                result.add(CredentialsNameProvider.name((Credentials)cred), cred.getId());
            }
            return result;
        }

        public ListBoxModel doFillTokenIdItems(@AncestorInPath Item job) {
            ListBoxModel result = new ListBoxModel();
            HashSet creds = new HashSet();
            HashSet<String> ids = new HashSet<String>();
            List userBased = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)job, (Authentication)Jenkins.getAuthentication(), NO_REQUIREMENTS);
            List jobBased = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)job, (Authentication)(job instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)job)) : ACL.SYSTEM), NO_REQUIREMENTS);
            creds.addAll(userBased);
            creds.addAll(jobBased);
            for (StringCredentials cred : creds) {
                if (!ids.add(cred.getId())) continue;
                result.add(CredentialsNameProvider.name((Credentials)cred), cred.getId());
            }
            return result;
        }

        public FormValidation doUsernameLoginCheck(@QueryParameter(value="url") String url, @QueryParameter(value="tokenId") String tokenId, @QueryParameter(value="username") String username) {
            LOGGER.log(Level.INFO, "Received url " + url + " tokenId " + tokenId);
            if (url == null || tokenId == null) {
                return FormValidation.warning((String)"Please provide a url and token");
            }
            if (username == null) {
                return FormValidation.warning((String)"Please provide username");
            }
            Cons3rtSite site = new Cons3rtSite(url, tokenId, Cons3rtSite.usernameAuthentication, null, username);
            try {
                try {
                    site.testConnection(LOGGER);
                }
                catch (HttpWrapper.HTTPException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Connection Failed.");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"Successful connection");
        }

        public FormValidation doCertificateLoginCheck(@QueryParameter(value="url") String url, @QueryParameter(value="tokenId") String tokenId, @QueryParameter(value="certificateId") String certificateId) {
            LOGGER.log(Level.INFO, "Received url " + url + " tokenId " + tokenId);
            if (url == null || tokenId == null) {
                return FormValidation.warning((String)"Please provide a url and token");
            }
            if (certificateId == null) {
                return FormValidation.warning((String)"Please provide certificate");
            }
            Cons3rtSite site = new Cons3rtSite(url, tokenId, Cons3rtSite.certificateAuthentication, certificateId, null);
            try {
                try {
                    site.testConnection(LOGGER);
                }
                catch (HttpWrapper.HTTPException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Connection Failed.");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"Successful connection");
        }
    }
}

