/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.timer;

import antlr.ANTLRException;
import configurationslicing.AbstractJob;
import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTimerSliceSpec
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<Job> {
    public static final String DISABLED = "(Disabled)";
    private Class triggerClass;

    protected AbstractTimerSliceSpec(Class triggerClass) {
        this.triggerClass = triggerClass;
    }

    @Override
    public String getDefaultValueString() {
        return DISABLED;
    }

    public Class getTriggerClass() {
        return this.triggerClass;
    }

    @Override
    public String getName(Job item) {
        return item.getFullName();
    }

    @Override
    public List<String> getValues(Job item) {
        Object trigger = AbstractJob.fix(item).getTrigger(this.triggerClass);
        return AbstractTimerSliceSpec.getValues(trigger);
    }

    public static List<String> getValues(Trigger trigger) {
        if (trigger == null) {
            return Collections.singletonList(DISABLED);
        }
        String spec = trigger.getSpec();
        return AbstractTimerSliceSpec.splitChronSpec(spec);
    }

    @Override
    public List<Job> getWorkDomain() {
        return TopLevelItemSelector.getAllTopLevelItems(Job.class);
    }

    public abstract Trigger newTrigger(String var1, Trigger var2) throws ANTLRException;

    @Override
    public boolean setValues(Job item, List<String> set) {
        String oldSpec;
        if (set.isEmpty()) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>(set);
        String spec = AbstractTimerSliceSpec.joinChronSpec(list);
        boolean disabled = DISABLED.equals(spec);
        Object oldTrigger = AbstractJob.fix(item).getTrigger(this.triggerClass);
        if (oldTrigger != null && (oldSpec = oldTrigger.getSpec()).equals(spec)) {
            return false;
        }
        try {
            Trigger newtrigger = null;
            if (!disabled) {
                newtrigger = this.newTrigger(spec, (Trigger)oldTrigger);
            }
            if (oldTrigger != null) {
                AbstractJob.fix(item).removeTrigger(oldTrigger.getDescriptor());
            }
            if (newtrigger != null) {
                AbstractJob.fix(item).addTrigger(newtrigger);
                newtrigger.start((Item)item, true);
            }
            return true;
        }
        catch (ANTLRException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<String> splitChronSpec(String spec) {
        String[] split = spec.trim().split("\n");
        ArrayList<String> specs = new ArrayList<String>();
        boolean lastWasComment = false;
        StringBuilder currentSpec = new StringBuilder();
        for (String line : split) {
            if ((line = line.trim()).length() == 0) continue;
            boolean isComment = line.startsWith("#");
            if (currentSpec.length() > 0) {
                boolean startNew;
                boolean bl = startNew = !isComment && !lastWasComment || isComment && !lastWasComment;
                if (startNew) {
                    specs.add(currentSpec.toString().trim());
                    currentSpec = new StringBuilder();
                }
            }
            currentSpec.append(line);
            currentSpec.append("\n");
            lastWasComment = isComment;
        }
        if (currentSpec.length() > 0) {
            specs.add(currentSpec.toString().trim());
        }
        return specs;
    }

    public static String joinChronSpec(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            List<String> splitOne = AbstractTimerSliceSpec.splitChronSpec(line);
            for (String one : splitOne) {
                if (builder.length() > 0) {
                    builder.append("\n\n");
                }
                builder.append(one);
            }
        }
        return builder.toString();
    }
}

