/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.parameters;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BooleanParameterValue;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TextParameterDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;

@Extension
public class ParametersSlicer
extends UnorderedStringSlicer<Job> {
    public ParametersSlicer() {
        super(new ParametersSliceSpec());
    }

    public static class ParametersSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<Job> {
        @Override
        public String getName() {
            return "Parameters";
        }

        @Override
        public String getUrl() {
            return "parameters";
        }

        @Override
        public String getDefaultValueString() {
            return "";
        }

        @Override
        public String getName(Job item) {
            return item.getFullName();
        }

        @Override
        public boolean isIndexUsed(int count) {
            return true;
        }

        @Override
        public boolean isValueTrimmed() {
            return false;
        }

        @Override
        public String getValueIndex(Job item, int index) {
            List<ParameterItem> pitems = this.getParameterItems(item);
            return pitems.get((int)index).name;
        }

        @Override
        public int getValueIndex(Job item, String indexName) {
            List<ParameterItem> pitems = this.getParameterItems(item);
            for (ParameterItem pitem : pitems) {
                if (!pitem.name.equals(indexName)) continue;
                return pitem.index;
            }
            throw new IllegalArgumentException(indexName);
        }

        @Override
        public List<String> getValues(Job item) {
            ArrayList<String> values = new ArrayList<String>();
            List<ParameterItem> pitems = this.getParameterItems(item);
            for (ParameterItem pitem : pitems) {
                values.add(pitem.value);
            }
            return values;
        }

        @Override
        public boolean setValues(Job item, List<String> list) {
            ParametersDefinitionProperty prop = (ParametersDefinitionProperty)item.getProperty(ParametersDefinitionProperty.class);
            List defs = prop.getParameterDefinitions();
            if (prop != null) {
                List<ParameterItem> pitems = this.getParameterItems(item);
                boolean changes = false;
                for (int i = 0; i < list.size(); ++i) {
                    String oldValue;
                    ParameterItem pitem = pitems.get(i);
                    String newValue = list.get(i);
                    if (newValue.equals(oldValue = pitem.value)) continue;
                    this.replace(pitem, newValue, defs);
                    changes = true;
                }
                if (changes) {
                    try {
                        item.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }

        private void replace(ParameterItem item, String newValue, List<ParameterDefinition> defs) {
            for (int i = 0; i < defs.size(); ++i) {
                ParameterDefinition def = defs.get(i);
                if (!def.getName().equals(item.name)) continue;
                ParameterDefinition newDef = this.newParameterDefinition(newValue, def);
                defs.set(i, newDef);
            }
        }

        private ParameterDefinition newParameterDefinition(String newValue, ParameterDefinition old) {
            if (old instanceof TextParameterDefinition) {
                return new TextParameterDefinition(old.getName(), newValue, old.getDescription());
            }
            if (old instanceof StringParameterDefinition) {
                return new StringParameterDefinition(old.getName(), newValue, old.getDescription());
            }
            if (old instanceof BooleanParameterDefinition) {
                return new BooleanParameterDefinition(old.getName(), Boolean.parseBoolean(newValue), old.getDescription());
            }
            if (old instanceof ChoiceParameterDefinition) {
                return new ChoiceParameterDefinition(old.getName(), newValue, old.getDescription());
            }
            return null;
        }

        private List<ParameterItem> getParameterItems(Job item) {
            ArrayList<ParameterItem> items = new ArrayList<ParameterItem>();
            ParametersDefinitionProperty prop = (ParametersDefinitionProperty)item.getProperty(ParametersDefinitionProperty.class);
            if (prop != null) {
                int count = 0;
                for (ParameterDefinition def : prop.getParameterDefinitions()) {
                    if (!this.isSliceableProperty(def)) continue;
                    ParameterValue value = def.getDefaultParameterValue();
                    String stringValue = this.toStringValue(value, def);
                    ParameterItem pitem = new ParameterItem();
                    pitem.index = count++;
                    pitem.value = stringValue;
                    pitem.name = value.getName();
                    items.add(pitem);
                }
            }
            return items;
        }

        @Override
        public List<Job> getWorkDomain() {
            List jobs = Jenkins.getInstance().getAllItems(Job.class);
            return jobs;
        }

        public String toStringValue(ParameterValue value, ParameterDefinition def) {
            if (value instanceof BooleanParameterValue) {
                return String.valueOf(((BooleanParameterValue)value).value);
            }
            if (value instanceof StringParameterValue) {
                return ((StringParameterValue)value).getValue();
            }
            if (def instanceof ChoiceParameterDefinition) {
                ChoiceParameterDefinition cdef = (ChoiceParameterDefinition)def;
                List choices = cdef.getChoices();
                StringBuilder buf = new StringBuilder();
                for (String choice : choices) {
                    if (buf.length() > 0) {
                        buf.append("\n");
                    }
                    buf.append(choice);
                }
                return buf.toString();
            }
            throw new IllegalArgumentException("Don't know how to convert " + value);
        }

        public boolean isSliceableProperty(ParameterDefinition def) {
            return def instanceof BooleanParameterDefinition || def instanceof StringParameterDefinition || def instanceof ChoiceParameterDefinition;
        }

        private static class ParameterItem {
            String name;
            String value;
            int index;

            private ParameterItem() {
            }
        }
    }
}

