/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.jdk;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.JDK;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

@Extension
public class JdkSlicer
extends UnorderedStringSlicer<AbstractProject> {
    public JdkSlicer() {
        super(new JdkSlicerSpec());
    }

    public static class JdkSlicerSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject> {
        private static final String DEFAULT = "(Default)";

        @Override
        public String getDefaultValueString() {
            return DEFAULT;
        }

        @Override
        public String getName() {
            return "JDK per project";
        }

        @Override
        public String getName(AbstractProject item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "projectjdk";
        }

        @Override
        public List<String> getValues(AbstractProject item) {
            ArrayList<String> ret = new ArrayList<String>();
            JDK jdk = item.getJDK();
            String name = jdk == null ? DEFAULT : jdk.getName();
            ret.add(name);
            return ret;
        }

        @Override
        public List<AbstractProject> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject item, List<String> set) {
            String val;
            if (set.size() == 0) {
                return false;
            }
            Jenkins hudson = Jenkins.getInstance();
            JDK jdk = null;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext() && (jdk = hudson.getJDK(val = iterator.next())) == null) {
            }
            JDK oldJdk = item.getJDK();
            if (!JdkSlicerSpec.equals(oldJdk, jdk)) {
                try {
                    item.setJDK(jdk);
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }

        public static boolean equals(JDK j1, JDK j2) {
            if (ObjectUtils.equals((Object)j1, (Object)j2)) {
                return true;
            }
            if (j1 == null || j2 == null) {
                return false;
            }
            if (!StringUtils.equals((String)j1.getHome(), (String)j2.getHome())) {
                return false;
            }
            return StringUtils.equals((String)j1.getName(), (String)j2.getName());
        }
    }
}

