/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.concurrentbuilds;

import configurationslicing.AbstractJob;
import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.Job;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Extension
public class ConcurrentBuildsStringSlicer
extends UnorderedStringSlicer<Job> {
    public ConcurrentBuildsStringSlicer() {
        super(new ConcurrentBuildsStringSliceSpec());
    }

    public static class ConcurrentBuildsStringSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<Job> {
        @Override
        public String getDefaultValueString() {
            return null;
        }

        @Override
        public String getName() {
            return "Job Concurrent Build Slicer (String)";
        }

        @Override
        public String getName(Job item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "concurrentbuildsstring";
        }

        @Override
        public boolean isBlankNeededForValues() {
            return false;
        }

        @Override
        public List<String> getCommonValueStrings() {
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(true));
            values.add(String.valueOf(false));
            return values;
        }

        @Override
        public List<String> getValues(Job job) {
            ArrayList<String> values = new ArrayList<String>();
            boolean isConcurrent = AbstractJob.fix(job).isConcurrentBuilds();
            values.add(String.valueOf(isConcurrent));
            return values;
        }

        @Override
        public List<Job> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(Job.class);
        }

        @Override
        public boolean setValues(Job job, List<String> set) {
            boolean newConcurrent;
            String value = set.iterator().next();
            boolean oldConcurrent = AbstractJob.fix(job).isConcurrentBuilds();
            if (oldConcurrent != (newConcurrent = Boolean.parseBoolean(value))) {
                try {
                    AbstractJob.fix(job).makeConcurrentBuilds(newConcurrent);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

