/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.concurrentbuilds;

import configurationslicing.AbstractJob;
import configurationslicing.BooleanSlicer;
import configurationslicing.TopLevelItemSelector;
import hudson.Extension;
import hudson.model.Job;
import java.io.IOException;
import java.util.List;

@Extension
public class ConcurrentBuildsBoolSlicer
extends BooleanSlicer<Job> {
    public ConcurrentBuildsBoolSlicer() {
        super(new ConcurrentBuildsBoolSpec());
    }

    public static class ConcurrentBuildsBoolSpec
    implements BooleanSlicer.BooleanSlicerSpec<Job> {
        @Override
        public String getName() {
            return "Job Concurrent Builds Slicer (Bool)";
        }

        @Override
        public String getName(Job item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "concurrentbuildsbool";
        }

        @Override
        public boolean getValue(Job item) {
            return AbstractJob.fix(item).isConcurrentBuilds();
        }

        @Override
        public List<Job> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(Job.class);
        }

        @Override
        public boolean setValue(Job item, boolean value) {
            boolean oldval = AbstractJob.fix(item).isConcurrentBuilds();
            if (oldval != value) {
                try {
                    AbstractJob.fix(item).makeConcurrentBuilds(value);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

