/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class AbstractJob {
    private Job item;

    public AbstractJob(Job item) {
        this.item = item;
    }

    public static AbstractJob fix(Job item) {
        return new AbstractJob(item);
    }

    public boolean isConcurrentBuilds() {
        if (this.item instanceof AbstractProject) {
            return ((AbstractProject)this.item).isConcurrentBuild();
        }
        if (this.item instanceof WorkflowJob) {
            return ((WorkflowJob)this.item).isConcurrentBuild();
        }
        return true;
    }

    public void makeConcurrentBuilds(boolean value) throws IOException {
        if (this.item instanceof AbstractProject) {
            ((AbstractProject)this.item).setConcurrentBuild(value);
        }
        if (this.item instanceof WorkflowJob) {
            ((WorkflowJob)this.item).setConcurrentBuild(value);
        }
        throw new IOException("Unsupported job type");
    }

    public <T extends Trigger> T getTrigger(Class<T> clazz) {
        if (this.item instanceof AbstractProject) {
            return (T)((AbstractProject)this.item).getTrigger(clazz);
        }
        if (this.item instanceof WorkflowJob) {
            return this.getTrigger((WorkflowJob)this.item, clazz);
        }
        return null;
    }

    public void removeTrigger(TriggerDescriptor trigger) throws IOException {
        if (this.item instanceof AbstractProject) {
            ((AbstractProject)this.item).removeTrigger(trigger);
        }
        if (this.item instanceof WorkflowJob) {
            this.removeTrigger((WorkflowJob)this.item, trigger);
        }
    }

    public void addTrigger(Trigger<?> trigger) throws IOException {
        if (this.item instanceof AbstractProject) {
            ((AbstractProject)this.item).addTrigger(trigger);
        }
        if (this.item instanceof WorkflowJob) {
            ((WorkflowJob)this.item).addTrigger(trigger);
        }
    }

    private <T extends Trigger> T getTrigger(WorkflowJob pipeline, Class<T> clazz) {
        for (Trigger p : pipeline.getTriggersJobProperty().getTriggers()) {
            if (!clazz.isInstance(p)) continue;
            return (T)((Trigger)clazz.cast(p));
        }
        return null;
    }

    private void removeTrigger(WorkflowJob pipeline, TriggerDescriptor triggerDescriptor) {
        Trigger trigger = (Trigger)pipeline.getTriggers().get(triggerDescriptor);
        if (trigger != null) {
            pipeline.getTriggersJobProperty().removeTrigger(trigger);
        }
    }
}

