/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.AbstractCompactColumn;
import com.robestone.hudson.compactcolumns.AbstractStatusesColumn;
import com.robestone.hudson.compactcolumns.BuildInfo;
import com.robestone.hudson.compactcolumns.Messages;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobNameColorColumn
extends AbstractCompactColumn {
    private boolean showColor;
    private boolean showDescription;
    private boolean showLastBuild;

    @DataBoundConstructor
    public JobNameColorColumn(boolean showColor, boolean showDescription, boolean showLastBuild, String colorblindHint) {
        super(colorblindHint);
        this.showColor = showColor;
        this.showDescription = showDescription;
        this.showLastBuild = showLastBuild;
    }

    public String getStyle(Job job) {
        String underline;
        String color;
        Run run;
        Result result = null;
        if (job != null && (run = job.getLastBuild()) != null) {
            result = run.getResult();
        }
        if (result == null) {
            color = BuildInfo.OTHER_COLOR;
            underline = "1px dashed";
        } else if (Result.ABORTED.equals(result)) {
            color = BuildInfo.OTHER_COLOR;
            underline = "1px dashed";
        } else if (Result.FAILURE.equals(result)) {
            color = BuildInfo.FAILED_COLOR;
            underline = "1px solid";
        } else if (Result.NOT_BUILT.equals(result)) {
            color = BuildInfo.OTHER_COLOR;
            underline = "1px dashed";
        } else if (Result.SUCCESS.equals(result)) {
            color = BuildInfo.getStableColorString();
            underline = "0px solid";
        } else if (Result.UNSTABLE.equals(result)) {
            color = BuildInfo.UNSTABLE_COLOR;
            underline = "1px dashed";
        } else {
            color = BuildInfo.OTHER_COLOR;
            underline = "1px dashed";
        }
        String style = "";
        if (this.showColor) {
            style = style + "color: " + color + ";";
        }
        if (this.isShowColorblindUnderlineHint()) {
            style = style + "text-decoration: none; border-bottom: " + underline + ";";
        }
        return style;
    }

    public String getToolTip(Job job, Locale locale) {
        BuildInfo build;
        String desc;
        List<BuildInfo> builds;
        String desc2;
        StringBuilder tip = new StringBuilder();
        if (this.showDescription && !StringUtils.isEmpty((String)(desc2 = job.getDescription()))) {
            tip.append(desc2);
        }
        if (this.showLastBuild && !(builds = AbstractStatusesColumn.getBuilds(job, locale, false, false, true, this.isShowColorblindUnderlineHint(), AbstractStatusesColumn.TimeAgoType.DIFF, 0)).isEmpty() && !StringUtils.isEmpty((String)(desc = AbstractStatusesColumn.getBuildDescriptionToolTip(build = builds.get(0), locale)))) {
            if (tip.length() > 0) {
                tip.append("<hr/>");
            }
            tip.append(desc);
        }
        return tip.length() > 0 ? tip.toString() : null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public boolean isShowLastBuild() {
        return this.showLastBuild;
    }

    @Extension
    @Symbol(value={"compactJobNameColor"})
    public static class DescriptorImpl
    extends AbstractStatusesColumn.AbstractCompactColumnDescriptor {
        public String getColumnDisplayName() {
            return hudson.views.Messages.JobColumn_DisplayName();
        }

        public String getDisplayName() {
            return Messages.Compact_Column_Job_Name_w_Options();
        }

        public String getHelpFile() {
            return "/plugin/compact-columns/job-name-color-column.html";
        }
    }
}

