/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.AbstractCompactColumn;
import com.robestone.hudson.compactcolumns.BuildInfo;
import com.robestone.hudson.compactcolumns.Messages;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.views.ListViewColumnDescriptor;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class AbstractStatusesColumn
extends AbstractCompactColumn {
    public static final String OTHER_UNDERLINE_STYLE = "1px dashed";
    public static final String UNSTABLE_UNDERLINE_STYLE = "1px dashed";
    public static final String STABLE_UNDERLINE_STYLE = "0px solid";
    public static final String FAILED_UNDERLINE_STYLE = "1px solid";
    private static final long ONE_SECOND_MS = 1000L;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final long ONE_HOUR_MS = 3600000L;
    static final long ONE_DAY_MS = 86400000L;
    private static final long ONE_MONTH_MS = 2592000000L;
    private static final long ONE_YEAR_MS = 31536000000L;
    private transient TimeAgoType timeAgoType;
    private String timeAgoTypeString;

    public AbstractStatusesColumn(String colorblindHint, String timeAgoTypeString) {
        super(colorblindHint);
        this.timeAgoTypeString = timeAgoTypeString;
        this.setTimeAgoType();
    }

    public static List<BuildInfo> getBuilds(Job<?, ?> job, Locale locale, boolean isFailedShownOnlyIfLast, boolean isUnstableShownOnlyIfLast, boolean isOnlyShowLastStatus, boolean isShowColorblindUnderlineHint, TimeAgoType timeAgoType, int hideDays) {
        BuildInfo info;
        int i;
        ArrayList<BuildInfo> builds = new ArrayList<BuildInfo>();
        AbstractStatusesColumn.addNonNull(builds, AbstractStatusesColumn.getLastFailedBuild(job, locale, isFailedShownOnlyIfLast, isShowColorblindUnderlineHint, true, timeAgoType));
        AbstractStatusesColumn.addNonNull(builds, AbstractStatusesColumn.getLastUnstableBuild(job, locale, isUnstableShownOnlyIfLast, isShowColorblindUnderlineHint, builds.isEmpty(), timeAgoType));
        AbstractStatusesColumn.addNonNull(builds, AbstractStatusesColumn.getLastStableBuild(job, locale, isShowColorblindUnderlineHint, builds.isEmpty(), timeAgoType));
        if (builds.isEmpty()) {
            BuildInfo aborted = AbstractStatusesColumn.createBuildInfo(AbstractStatusesColumn.getLastAbortedBuild(job), BuildInfo.OTHER_COLOR, "1px dashed", AbstractStatusesColumn.getAbortedMessage(), null, job, locale, isShowColorblindUnderlineHint, true, timeAgoType);
            AbstractStatusesColumn.addNonNull(builds, aborted);
        }
        Collections.sort(builds);
        ArrayList<BuildInfo> filtered = new ArrayList<BuildInfo>();
        long now = System.currentTimeMillis();
        long maxDiff = (long)hideDays * 86400000L;
        for (i = 0; i < builds.size(); ++i) {
            info = (BuildInfo)builds.get(i);
            boolean show = true;
            if (hideDays > 0) {
                long time = info.getBuildTime();
                long diff = now - time;
                boolean bl = show = diff <= maxDiff;
            }
            if (!filtered.isEmpty() && !show) continue;
            filtered.add(info);
            if (isOnlyShowLastStatus) break;
        }
        builds = filtered;
        for (i = 0; i < builds.size(); ++i) {
            info = (BuildInfo)builds.get(i);
            info.setFirst(i == 0);
            info.setMultipleBuilds(builds.size() > 1);
            AbstractStatusesColumn.assignTimeAgoString(info, locale, timeAgoType);
        }
        return builds;
    }

    public static BuildInfo getLastFailedBuild(Job<?, ?> job, Locale locale, boolean onlyIfLastCompleted, boolean isShowColorblindUnderlineHint, boolean isFirst, TimeAgoType timeAgoType) {
        Run lastFailedBuild = job.getLastFailedBuild();
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastFailedBuild == null) {
            return null;
        }
        if (!onlyIfLastCompleted || lastCompletedBuild.number == lastFailedBuild.number) {
            return AbstractStatusesColumn.createBuildInfo(job.getLastFailedBuild(), BuildInfo.FAILED_COLOR, FAILED_UNDERLINE_STYLE, AbstractStatusesColumn.getFailedMessage(), "lastFailedBuild", job, locale, isShowColorblindUnderlineHint, isFirst, timeAgoType);
        }
        return null;
    }

    public static BuildInfo getLastStableBuild(Job<?, ?> job, Locale locale, boolean isShowColorblindUnderlineHint, boolean isFirst, TimeAgoType timeAgoType) {
        return AbstractStatusesColumn.createBuildInfo(job.getLastStableBuild(), BuildInfo.getStableColorString(), STABLE_UNDERLINE_STYLE, AbstractStatusesColumn.getStableMessage(), "lastStableBuild", job, locale, isShowColorblindUnderlineHint, isFirst, timeAgoType);
    }

    public static BuildInfo getLastUnstableBuild(Job<?, ?> job, Locale locale, boolean isUnstableShownOnlyIfLast, boolean isShowColorblindUnderlineHint, boolean isFirst, TimeAgoType timeAgoType) {
        boolean isLastCompleted;
        Run lastUnstable = job.getLastUnstableBuild();
        if (lastUnstable == null) {
            return null;
        }
        Run lastCompleted = job.getLastCompletedBuild();
        boolean bl = isLastCompleted = lastCompleted != null && lastCompleted.number == lastUnstable.number;
        if (isUnstableShownOnlyIfLast && !isLastCompleted) {
            return null;
        }
        return AbstractStatusesColumn.createBuildInfo(lastUnstable, BuildInfo.UNSTABLE_COLOR, "1px dashed", AbstractStatusesColumn.getUnstableMessage(), String.valueOf(lastUnstable.number), job, locale, isShowColorblindUnderlineHint, isFirst, timeAgoType);
    }

    private static void addNonNull(List<BuildInfo> builds, BuildInfo info) {
        if (info != null) {
            builds.add(info);
        }
    }

    private static Run<?, ?> getLastAbortedBuild(Job<?, ?> job) {
        int i = 0;
        for (Run latest = job.getLastBuild(); latest != null && i++ < 20; latest = latest.getPreviousBuild()) {
            if (latest.getResult() != Result.ABORTED) continue;
            return latest;
        }
        return null;
    }

    private static void assignTimeAgoString(BuildInfo info, Locale locale, TimeAgoType timeAgoType) {
        String timeAgoString = AbstractStatusesColumn.getTimeAgoString(locale, info.getBuildTime(), info.isMultipleBuilds(), timeAgoType);
        info.setTimeAgoString(timeAgoString);
    }

    private static BuildInfo createBuildInfo(Run<?, ?> run, String color, String underlineStyle, String status, String urlPart, Job<?, ?> job, Locale locale, boolean isShowColorblindUnderlineHint, boolean isFirst, TimeAgoType timeAgoType) {
        if (run != null) {
            Run latest;
            long buildTime = run.getTime().getTime();
            if (urlPart == null) {
                urlPart = String.valueOf(run.number);
            }
            if ((latest = job.getLastCompletedBuild()) == null) {
                latest = job.getLastBuild();
            }
            if (!isShowColorblindUnderlineHint) {
                underlineStyle = null;
            }
            BuildInfo build = new BuildInfo(run, color, underlineStyle, buildTime, status, urlPart, run.number == latest.number);
            return build;
        }
        return null;
    }

    protected static String getTimeAgoString(Locale locale, long timestamp, boolean isMultiple, TimeAgoType timeAgoType) {
        boolean isToday;
        if (timeAgoType == TimeAgoType.DIFF) {
            long now = System.currentTimeMillis();
            float diff = now - timestamp;
            String stime = AbstractStatusesColumn.getShortTimestamp(diff);
            return stime;
        }
        if (timeAgoType == TimeAgoType.PREFER_DATE_TIME && !isMultiple) {
            return AbstractStatusesColumn.getBuildTimeString(timestamp, locale, true, true, true);
        }
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTimeInMillis(System.currentTimeMillis());
        Calendar thenCal = Calendar.getInstance();
        thenCal.setTimeInMillis(timestamp);
        int nowDay = nowCal.get(6);
        int thenDay = thenCal.get(6);
        boolean bl = isToday = nowDay == thenDay;
        if (isToday) {
            return AbstractStatusesColumn.getBuildTimeString(timestamp, locale, false, true, false);
        }
        return AbstractStatusesColumn.getBuildTimeString(timestamp, locale, true, false, false);
    }

    protected static String getBuildTimeString(long timeMs, Locale locale) {
        return AbstractStatusesColumn.getBuildTimeString(timeMs, locale, true, true, false);
    }

    protected static String getBuildTimeString(long timeMs, Locale locale, boolean addDate, boolean addTime, boolean useDefaultFormat) {
        Date time = new Date(timeMs);
        if (addTime && addDate && useDefaultFormat) {
            DateFormat dateFormat = AbstractStatusesColumn.getDateTimePattern(locale);
            String dateString = dateFormat.format(time);
            return dateString;
        }
        StringBuilder buf = new StringBuilder();
        if (addTime) {
            DateFormat timeFormat = DateFormat.getTimeInstance(3, locale);
            String timeString = timeFormat.format(time);
            buf.append(timeString);
        }
        if (addDate) {
            DateFormat dateFormat = AbstractStatusesColumn.getDatePattern(locale);
            String dateString = dateFormat.format(time);
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(dateString);
        }
        return buf.toString();
    }

    protected static DateFormat getDatePattern(Locale locale) {
        DateFormat format = DateFormat.getDateInstance(3, locale);
        return AbstractStatusesColumn.getDatePattern(format, locale);
    }

    protected static DateFormat getDateTimePattern(Locale locale) {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3, locale);
        return AbstractStatusesColumn.getDatePattern(format, locale);
    }

    private static DateFormat getDatePattern(DateFormat format, Locale locale) {
        if (format instanceof SimpleDateFormat) {
            String s = ((SimpleDateFormat)format).toPattern();
            if (!s.contains("yyyy")) {
                s = s.replace("yy", "yyyy");
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(s, locale);
            return dateFormat;
        }
        throw new IllegalArgumentException("Can't handle locale: " + locale);
    }

    protected static String getShortTimestamp(float time) {
        String ts;
        if (time >= 3.1536E10f) {
            float number = AbstractStatusesColumn.getRoundedNumber(time / 3.1536E10f);
            ts = hudson.Messages.Util_year((Object)Float.valueOf(number));
        } else if (time >= 2.592E9f) {
            float number = AbstractStatusesColumn.getRoundedNumber(time / 2.592E9f);
            ts = hudson.Messages.Util_month((Object)Float.valueOf(number));
        } else if (time >= 8.64E7f) {
            float number = AbstractStatusesColumn.getRoundedNumber(time / 8.64E7f);
            ts = hudson.Messages.Util_day((Object)Float.valueOf(number));
        } else if (time >= 3600000.0f) {
            float number = AbstractStatusesColumn.getRoundedNumber(time / 3600000.0f);
            ts = hudson.Messages.Util_hour((Object)Float.valueOf(number));
        } else if (time >= 60000.0f) {
            float number = AbstractStatusesColumn.getRoundedNumber(time / 60000.0f);
            ts = hudson.Messages.Util_minute((Object)Float.valueOf(number));
        } else if (time >= 1000.0f) {
            float number = AbstractStatusesColumn.getRoundedNumber(time / 1000.0f);
            ts = hudson.Messages.Util_second((Object)Float.valueOf(number));
        } else {
            ts = hudson.Messages.Util_second((Object)0);
        }
        return ts;
    }

    protected static float getRoundedNumber(float number) {
        int scale = number >= 10.0f ? 0 : 1;
        return new BigDecimal(number).setScale(scale, 5).floatValue();
    }

    public static final String getFailedMessage() {
        return hudson.model.Messages.BallColor_Failed();
    }

    public static final String getUnstableMessage() {
        return hudson.model.Messages.BallColor_Unstable();
    }

    public static final String getAbortedMessage() {
        return hudson.model.Messages.BallColor_Aborted();
    }

    public static final String getBuildDescriptionToolTip(BuildInfo build, Locale locale) {
        StringBuilder buf = new StringBuilder();
        buf.append("<b><u>");
        buf.append(Messages.buildNumber());
        buf.append(build.getRun().number);
        buf.append(build.getLatestBuildString(locale));
        buf.append("</u></b>\n");
        buf.append("<ul>\n");
        buf.append("<li>");
        buf.append(build.getBuiltAt(locale));
        buf.append("</li>\n");
        buf.append("<li>");
        buf.append(build.getStartedAgo(locale));
        buf.append("</li>\n");
        buf.append("<li>");
        buf.append(build.getLastedDuration(locale));
        buf.append("</li>\n");
        buf.append("<li><b>");
        buf.append(build.getStatus());
        buf.append("</b></li>\n");
        buf.append("</ul>");
        return buf.toString();
    }

    public static final String getStableMessage() {
        char c;
        String message = hudson.model.Messages.Run_Summary_Stable();
        if (message != null && message.length() > 1 && Character.isLowerCase(c = message.charAt(0))) {
            c = Character.toUpperCase(c);
            message = c + message.substring(1);
        }
        return message;
    }

    Object readResolve() {
        this.setTimeAgoType();
        return this;
    }

    private void setTimeAgoType() {
        if (this.timeAgoTypeString == null) {
            this.timeAgoTypeString = TimeAgoType.DIFF.toString();
        }
        this.timeAgoType = TimeAgoType.valueOf(this.timeAgoTypeString);
    }

    public String getColumnSortData(Job<?, ?> job) {
        List<BuildInfo> builds = this.getBuilds(job, Locale.getDefault());
        if (builds.isEmpty()) {
            return "0";
        }
        BuildInfo latest = builds.get(0);
        return String.valueOf(latest.getBuildTime());
    }

    public int getHideDays() {
        return 0;
    }

    public boolean isBuildsEmpty(Job<?, ?> job) {
        return this.getBuilds(job, Locale.getDefault()).isEmpty();
    }

    public List<BuildInfo> getBuilds(Job<?, ?> job, Locale locale) {
        return AbstractStatusesColumn.getBuilds(job, locale, this.isFailedShownOnlyIfLast(), this.isUnstableShownOnlyIfLast(), this.isOnlyShowLastStatus(), this.isShowColorblindUnderlineHint(), this.timeAgoType, this.getHideDays());
    }

    protected abstract boolean isFailedShownOnlyIfLast();

    protected abstract boolean isUnstableShownOnlyIfLast();

    public boolean isOnlyShowLastStatus() {
        return false;
    }

    public final String getToolTip(BuildInfo build, Locale locale) {
        return AbstractStatusesColumn.getBuildDescriptionToolTip(build, locale);
    }

    public String getTimeAgoTypeString() {
        return this.timeAgoTypeString;
    }

    public static abstract class AbstractCompactColumnDescriptor
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }
    }

    public static enum TimeAgoType {
        DIFF,
        PREFER_DATES,
        PREFER_DATE_TIME;

    }
}

