/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.webservices.CTFPackage;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFRelease;
import com.collabnet.ce.webservices.CTFScmRepository;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.util.VersionNumber;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

public class CNHudsonUtil {
    private static Logger log = Logger.getLogger("CNHudsonUtil");

    private CNHudsonUtil() {
    }

    public static CollabNetApp getCollabNetApp(String url, String username, String password) {
        if (CommonUtil.unset(url)) {
            return null;
        }
        try {
            return new CollabNetApp(url, username, password);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getCollabNetApp", re);
            log.log(Level.SEVERE, "getCollabNetApp failed", re);
            return null;
        }
    }

    public static CollabNetApp recreateCollabNetApp(String url, String username, String sessionId) {
        if (CommonUtil.unset(url)) {
            return null;
        }
        return new CollabNetApp(url, username, null, sessionId);
    }

    public static CollabNetApp getCollabNetApp(StaplerRequest request) {
        String url = null;
        String username = null;
        String password = null;
        String override_auth = request.getParameter("override_auth");
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        if (descriptor != null && descriptor.useGlobal() && override_auth != null && override_auth.equals("false")) {
            url = descriptor.getCollabNetUrl();
            username = descriptor.getUsername();
            password = descriptor.getPassword();
        } else {
            url = request.getParameter("url");
            username = request.getParameter("username");
            password = request.getParameter("password");
        }
        if (CommonUtil.unset(url) || CommonUtil.unset(username) || CommonUtil.unset(password)) {
            return null;
        }
        return CNHudsonUtil.getCollabNetApp(url, username, password);
    }

    public static String getUsername(StaplerRequest request) {
        String username = null;
        String override_auth = request.getParameter("override_auth");
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        username = descriptor != null && descriptor.useGlobal() && override_auth != null && override_auth.equals("false") ? descriptor.getUsername() : request.getParameter("username");
        return username;
    }

    public static void logoff(CollabNetApp cna) {
        if (cna != null) {
            try {
                cna.logoff();
            }
            catch (RemoteException re) {
                CommonUtil.logRE(log, "logoff", re);
            }
        }
    }

    public static CTFRelease getProjectReleaseId(CTFProject project, String release) throws RemoteException {
        if (project == null) {
            return null;
        }
        for (CTFPackage pkg : project.getPackages()) {
            CTFRelease r = pkg.getReleaseByTitle(release);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static boolean isUserValid(CollabNetApp cna, String username) {
        boolean valid = false;
        try {
            valid = cna.isUsernameValid(username);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "userExists", re);
        }
        return valid;
    }

    public static String getScmViewerUrl(CollabNetApp cna, String collabnetUrl, String projectName, String repoName) throws RemoteException {
        String url = null;
        CTFScmRepository repo = CNHudsonUtil.getRepoData(cna, projectName, repoName);
        if (repo != null) {
            url = repo.getScmViewerUrl();
            if (cna != null) {
                VersionNumber apiVersion;
                try {
                    apiVersion = new VersionNumber(cna.getApiVersion());
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getScmViewerUrl", re);
                    return null;
                }
                if (new VersionNumber("5.3.0.0").compareTo(apiVersion) <= 0 && apiVersion.compareTo(new VersionNumber("6.0.0.0")) < 0) {
                    url = collabnetUrl + "/sf/scm/do/viewRepositorySource/" + repo.getPath();
                }
            }
        }
        return url;
    }

    public static int[] getVersionArray(String apiVersionStr) {
        int[] versionNums = null;
        if (apiVersionStr != null) {
            String[] versionArr = apiVersionStr.split("\\.");
            versionNums = new int[versionArr.length];
            for (int i = 0; i < versionArr.length; ++i) {
                versionNums[i] = Integer.parseInt(versionArr[i]);
            }
        }
        return versionNums;
    }

    public static String getSystemId(CollabNetApp cna, String projectName, String repoName) throws RemoteException {
        CTFProject p = cna.getProjectByTitle(projectName);
        if (p == null) {
            return null;
        }
        CTFScmRepository r = p.getScmRepositories().byTitle(repoName);
        if (r == null) {
            return null;
        }
        return r.getSystemId();
    }

    private static CTFScmRepository getRepoData(CollabNetApp cna, String projectName, String repoName) throws RemoteException {
        CTFProject p = cna.getProjectByTitle(projectName);
        if (p == null) {
            return null;
        }
        return p.getScmRepositories().byTitle(repoName);
    }

    public static String sanitizeCollabNetUrl(String url) {
        if (url != null && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

