/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet;

import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.collabnet.AbstractTeamForgeNotifier;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

@Extension
public class CNChangeLogAnnotator
extends ChangeLogAnnotator {
    private static final Pattern OBJECT_IDS = Pattern.compile("\\b(cmmt|doc|frs|news|post|report|task|forum|pkg|rel|docr|docf|topc|tracker|user|proj|reps|taskgrp|wiki|page|srch|plan|artf)[0-9]{4,}(#\\d+)?\\b");

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        String base = this.getCollabNetUrl(build);
        if (base == null) {
            return;
        }
        for (MarkupText.SubText t : text.findTokens(OBJECT_IDS)) {
            t.href(base + "/sf/go/" + t.getText());
        }
    }

    private String getCollabNetUrl(AbstractBuild<?, ?> build) {
        AbstractTeamForgeNotifier n = (AbstractTeamForgeNotifier)((AbstractProject)build.getParent()).getPublishersList().get(AbstractTeamForgeNotifier.class);
        if (n != null) {
            return n.getCollabNetUrl();
        }
        return AbstractTeamForgeNotifier.getTeamForgeShareDescriptor().getCollabNetUrl();
    }
}

