/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.share;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.actionhub.ActionHubPlugin;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TeamForgeShare
extends JobProperty<Job<?, ?>> {
    public TeamForgeShareDescriptor getDescriptor() {
        return (TeamForgeShareDescriptor)Hudson.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public static TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        return (TeamForgeShareDescriptor)Hudson.getInstance().getDescriptor(TeamForgeShare.class);
    }

    @Extension
    public static final class TeamForgeShareDescriptor
    extends JobPropertyDescriptor {
        private static Logger log = Logger.getLogger("TeamForgeShareDescriptor");
        private String collabNetUrl = null;
        private String username = null;
        private Secret password = null;
        private boolean useGlobal = false;
        private String actionHubMqHost = null;
        private int actionHubMqPort = 0;
        private String actionHubMqUsername = null;
        private String actionHubMqPassword = null;
        private String actionHubMqExchange = null;
        private String actionHubMqWorkflowQueue = null;
        private String actionHubMqActionsQueue = null;
        private String actionHubMsgIncludeRadio = null;
        private boolean actionHubMsgManual = false;
        private boolean actionHubMsgWorkitem = false;
        private boolean actionHubMsgBuild = false;
        private boolean actionHubMsgReview = false;
        private boolean actionHubMsgCustom = false;
        private boolean actionHubMsgCommit = false;
        private String actionHubMsgCustomTxt = null;

        public TeamForgeShareDescriptor() {
            super(TeamForgeShare.class);
            this.load();
        }

        public String getDisplayName() {
            return "Global CollabNet Teamforge Configuration";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            if (json.has("connectionFactory")) {
                this.setConnectionFactory((ConnectionFactory)((Object)staplerRequest.bindJSON(ConnectionFactory.class, json.getJSONObject("connectionFactory"))));
            } else {
                this.setConnectionFactory(null);
            }
            if (json.has("actionHubMqHost")) {
                this.actionHubMqHost = json.getString("actionHubMqHost");
                this.actionHubMqPort = json.getInt("actionHubMqPort");
                this.actionHubMqUsername = json.getString("actionHubMqUsername");
                this.actionHubMqPassword = json.getString("actionHubMqPassword");
                this.actionHubMqExchange = json.getString("actionHubMqExchange");
                this.actionHubMqWorkflowQueue = json.getString("actionHubMqWorkflowQueue");
                this.actionHubMqActionsQueue = json.getString("actionHubMqActionsQueue");
                this.actionHubMsgIncludeRadio = (String)json.get("actionHubMsgIncludeRadio");
                this.actionHubMsgManual = json.getBoolean("actionHubMsgManual");
                this.actionHubMsgWorkitem = json.getBoolean("actionHubMsgWorkitem");
                this.actionHubMsgCommit = json.getBoolean("actionHubMsgCommit");
                this.actionHubMsgBuild = json.getBoolean("actionHubMsgBuild");
                this.actionHubMsgReview = json.getBoolean("actionHubMsgReview");
                this.actionHubMsgCustom = json.getBoolean("actionHubMsgCustom");
                this.actionHubMsgCustomTxt = json.getString("actionHubMsgCustomTxt");
                this.save();
                log.info("ActionHub Connection Settings saved.");
                try {
                    ActionHubPlugin.init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }

        public void setConnectionFactory(ConnectionFactory cf) {
            boolean bl = this.useGlobal = cf != null;
            if (this.useGlobal) {
                this.collabNetUrl = cf.getUrl();
                this.username = cf.getUsername();
                this.password = cf.getPassword();
            } else {
                this.collabNetUrl = null;
                this.username = null;
                this.password = null;
            }
            this.save();
        }

        public FormValidation doCheckActionHubMqHost(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a host name for where the rabbit mq instance is running.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckActionHubMqPort(@QueryParameter int value) throws IOException, ServletException {
            if (value < 1) {
                return FormValidation.error((String)"Please set a port for where the rabbit mq instance is running.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckActionHubMqUsername(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Enter a username to the rabbit mq instance.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckActionHubMqPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Enter a password for the username above.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckActionHubMqExchange(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an exchange for where the rabbit mq instance is listening.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckActionHubMqWorkflowQueue(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please input the workflow routing key.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckActionHubMqActionsQueue(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please input the actions routing key.");
            }
            return FormValidation.ok();
        }

        public boolean useGlobal() {
            return this.useGlobal;
        }

        public String getCollabNetUrl() {
            return this.collabNetUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return Secret.toString((Secret)this.password);
        }

        public String getActionHubMqHost() {
            return this.actionHubMqHost;
        }

        public int getActionHubMqPort() {
            return this.actionHubMqPort;
        }

        public String getActionHubMqUsername() {
            return this.actionHubMqUsername;
        }

        public String getActionHubMqPassword() {
            return this.actionHubMqPassword;
        }

        public String getActionHubMqExchange() {
            return this.actionHubMqExchange;
        }

        public String getActionHubMqWorkflowQueue() {
            return this.actionHubMqWorkflowQueue;
        }

        public String getActionHubMqActionsQueue() {
            return this.actionHubMqActionsQueue;
        }

        public ConnectionFactory getConnectionFactory() {
            return this.useGlobal ? new ConnectionFactory(this.collabNetUrl, this.username, this.password) : null;
        }

        public String getActionHubMsgIncludeRadio() {
            return this.actionHubMsgIncludeRadio;
        }

        public void setActionHubMsgIncludeRadio(String actionHubMsgIncludeRadio) {
            this.actionHubMsgIncludeRadio = actionHubMsgIncludeRadio;
        }

        public boolean isActionHubMsgManual() {
            return this.actionHubMsgManual;
        }

        public boolean isActionHubMsgWorkitem() {
            return this.actionHubMsgWorkitem;
        }

        public boolean isActionHubMsgCommit() {
            return this.actionHubMsgCommit;
        }

        public boolean isActionHubMsgBuild() {
            return this.actionHubMsgBuild;
        }

        public boolean isActionHubMsgReview() {
            return this.actionHubMsgReview;
        }

        public boolean isActionHubMsgCustom() {
            return this.actionHubMsgCustom;
        }

        public String getActionHubMsgCustomTxt() {
            return this.actionHubMsgCustomTxt;
        }

        public boolean areActionHubSettingsValid() {
            boolean retVal = true;
            if (this.actionHubMqHost == null || this.actionHubMqHost.length() == 0) {
                retVal = false;
            } else if (this.actionHubMqPort < 1) {
                retVal = false;
            } else if (this.actionHubMqUsername == null || this.actionHubMqUsername.length() == 0) {
                retVal = false;
            } else if (this.actionHubMqPassword == null || this.actionHubMqPassword.length() == 0) {
                retVal = false;
            } else if (this.actionHubMqExchange == null || this.actionHubMqExchange.length() == 0) {
                retVal = false;
            } else if (this.actionHubMqWorkflowQueue == null || this.actionHubMqWorkflowQueue.length() == 0) {
                retVal = false;
            } else if (this.actionHubMqActionsQueue == null || this.actionHubMqActionsQueue.length() == 0) {
                retVal = false;
            }
            return retVal;
        }
    }
}

