/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.util.Helper;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;

public class BuildEvent {
    static Logger logger = Logger.getLogger("hudson.plugins.collab.orchestrate");

    public static JSONObject constructJson(Run build, TaskListener listener, String status, boolean excludeCommitInfo) throws IOException {
        JSONObject response = BuildEvent.getBuildData(build, listener, status, excludeCommitInfo);
        return response;
    }

    public static JSONObject toJson(Object object) throws IOException {
        StringWriter writer = new StringWriter();
        Model model = new ModelBuilder().get(object.getClass());
        model.writeTo(object, Flavor.JSON.createDataWriter(object, (Writer)writer));
        ((Writer)writer).close();
        return JSONObject.fromObject((Object)((Object)writer).toString());
    }

    public static JSONObject getBuildData(Run run, TaskListener listener, String status, boolean excludeCommitInfo) throws IOException {
        Run rawBuild;
        Run useRun = run;
        if (!(useRun instanceof AbstractBuild) && (rawBuild = BuildEvent.getRawBuild(useRun)) != null) {
            useRun = rawBuild;
        }
        JSONObject buildData = new JSONObject().element("buildId", (Object)String.valueOf(useRun.getNumber())).element("eventTime", (Object)BuildEvent.convertTime(useRun.getTime())).element("buildUrl", (Object)BuildEvent.getBuildURL(useRun)).element("status", (Object)BuildEvent.getStatus(useRun, status)).element("createdBy", (Object)BuildEvent.updateStartedBy(run)).element("testResult", (Object)BuildEvent.getTestResults(useRun));
        if (!excludeCommitInfo) {
            buildData = buildData.element("repository", (Object)BuildEvent.getRevisions(useRun, listener));
        }
        long duration = System.currentTimeMillis() - useRun.getTimeInMillis();
        long duration_s = Math.round((double)duration / 1000.0);
        buildData.put("duration", (Object)String.valueOf(duration_s));
        return buildData;
    }

    private static String updateStartedBy(Run run) {
        Cause.UpstreamCause upstream = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
        if (upstream != null) {
            return "upstream project " + upstream.getUpstreamProject() + " build number " + upstream.getUpstreamBuild();
        }
        SCMTrigger.SCMTriggerCause scmTrigger = (SCMTrigger.SCMTriggerCause)run.getCause(SCMTrigger.SCMTriggerCause.class);
        if (scmTrigger != null) {
            String description = scmTrigger.getShortDescription();
            return description.replaceFirst("((.+?(?:y)))", "").trim();
        }
        Cause.UserIdCause user = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
        if (user != null) {
            return user.getUserName();
        }
        return null;
    }

    public static URI stripUserAndPassword(String repositoryString) {
        URI repositoryURI;
        try {
            URI fullURI = new URI(repositoryString);
            repositoryURI = new URI(fullURI.getScheme(), null, fullURI.getHost(), fullURI.getPort(), fullURI.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Unable to parse URL", e);
            repositoryURI = null;
        }
        return repositoryURI;
    }

    public static String convertTime(Date time) {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
        return dateTimeFormatter.print(time.getTime());
    }

    public static JSONObject getTestResults(Run run) {
        AbstractTestResultAction testResultAction = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        if (testResultAction == null) {
            return null;
        }
        int totalCount = testResultAction.getTotalCount();
        int passCount = totalCount - (testResultAction.getFailCount() + testResultAction.getSkipCount());
        return new JSONObject().element("passedCount", passCount).element("failedCount", testResultAction.getFailCount()).element("ignoredCount", testResultAction.getSkipCount()).element("url", (Object)BuildEvent.getTestResultsURL(run, testResultAction));
    }

    public static String getStatus(Run run) {
        Result result = run.getResult();
        String status = null;
        if (result != null) {
            status = result.isBetterOrEqualTo(Result.SUCCESS) ? "Successful" : (result.isBetterOrEqualTo(Result.UNSTABLE) ? "Unstable" : (result == Result.ABORTED ? "Aborted" : "Failed"));
        }
        return status;
    }

    private static String getStatus(Run run, String statusName) {
        return statusName != null && statusName.trim().length() > 0 ? BuildEvent.getStatus(statusName) : BuildEvent.getStatus(run);
    }

    private static String getStatus(String statusName) {
        String status = "Successful";
        if (statusName != null && statusName.trim().length() > 0) {
            if (statusName.toLowerCase().startsWith("success")) {
                return status;
            }
            status = statusName.toLowerCase().startsWith("unstable") ? "Unstable" : (statusName.toLowerCase().startsWith("aborted") ? "Aborted" : "Failed");
        }
        return status;
    }

    public static URI getBuildURI(Run run) throws URISyntaxException {
        return new URI(run.getAbsoluteUrl());
    }

    public static JSONObject getRevisions(Run run, TaskListener listener) throws IOException {
        JSONObject repositoryInfo = BuildEvent.getRepositoryInfo(run, listener);
        if (repositoryInfo == null) {
            Helper.markUnstable(run, listener.getLogger(), "SCM not configured.", "hudson.plugins.collab.orchestrate.BuildEvent");
            return null;
        }
        JSONArray revisions = new JSONArray();
        for (ChangeLogSet.Entry entry : BuildEvent.findChangeSet(run)) {
            revisions.add((Object)entry.getCommitId());
        }
        repositoryInfo.element("revisions", (Collection)revisions);
        if (revisions.size() == 0) {
            Helper.markUnstable(run, listener.getLogger(), "SCM revisions not available, commit your changes and try again.", "hudson.plugins.collab.orchestrate.BuildEvent");
        }
        return repositoryInfo;
    }

    public static JSONObject getRepositoryInfo(Run run, TaskListener listener) throws IOException {
        URI repositoryURI;
        String repositoryType;
        SCM scmServer = BuildEvent.getSCM(run);
        if (scmServer == null) {
            Helper.markUnstable(run, listener.getLogger(), "SCM info not available", "hudson.plugins.collab.orchestrate.BuildEvent");
            return null;
        }
        String serverType = scmServer.getType();
        if ("hudson.scm.SubversionSCM".equals(serverType)) {
            repositoryType = "svn";
            repositoryURI = BuildEvent.getSVNRepository(run, listener);
        } else if ("hudson.plugins.git.GitSCM".equals(serverType)) {
            repositoryType = "git";
            repositoryURI = BuildEvent.getGitRepository(run, scmServer);
        } else {
            logger.warning("Unknown repository type " + serverType);
            return null;
        }
        return new JSONObject().element("type", (Object)repositoryType).element("url", (Object)repositoryURI.toString());
    }

    protected static URI getSVNRepository(Run run, TaskListener listener) throws IOException {
        JSONObject changeSet = BuildEvent.toJson(BuildEvent.getChangeSet(run));
        if (changeSet.getJSONArray("revisions") != null) {
            JSONObject firstRevision = changeSet.getJSONArray("revisions").getJSONObject(0);
            return BuildEvent.stripUserAndPassword(firstRevision.getString("module"));
        }
        try {
            return BuildEvent.stripUserAndPassword((String)run.getEnvironment().get((Object)"SVN_URL"));
        }
        catch (Exception e) {
            Helper.markUnstable(run, listener.getLogger(), "SCM info not available", "hudson.plugins.collab.orchestrate.BuildEvent");
            return null;
        }
    }

    protected static URI getGitRepository(Run run, SCM scm) throws IOException {
        String repositoryString;
        Action buildDataAction = BuildEvent.getActionByClassName(run, "hudson.plugins.git.util.BuildData");
        if (buildDataAction == null) {
            logger.warning("Git plugin not found");
            return null;
        }
        JSONObject actionObject = BuildEvent.toJson(buildDataAction);
        JSONArray remoteUrls = actionObject.getJSONArray("remoteUrls");
        if (remoteUrls != null && remoteUrls.size() > 0) {
            repositoryString = remoteUrls.getString(0);
        } else {
            logger.fine("Falling back to old repository detection.");
            JSONObject scmInfo = BuildEvent.toJson(scm);
            JSONArray userRemoteConfigs = scmInfo.getJSONArray("userRemoteConfigs");
            repositoryString = userRemoteConfigs.getJSONObject(0).getString("url");
        }
        return BuildEvent.stripUserAndPassword(repositoryString);
    }

    protected static Action getActionByClassName(Run run, String actionName) {
        for (Action action : run.getAllActions()) {
            if (!actionName.equals(action.getClass().getName())) continue;
            return action;
        }
        return null;
    }

    private static String getBuildURL(Run run) {
        String buildURL = null;
        try {
            URI buildURI = BuildEvent.getBuildURI(run);
            buildURL = buildURI.toString();
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Failed to parse build URL", e);
        }
        catch (NullPointerException e) {
            return buildURL;
        }
        return buildURL;
    }

    private static String getTestResultsURL(Run run, AbstractTestResultAction testResultAction) {
        String resultsURL = null;
        try {
            URI uri = BuildEvent.getBuildURI(run);
            URI testURI = uri.resolve(testResultAction.getUrlName());
            resultsURL = testURI.toString();
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Unable to parse URL", e);
        }
        return resultsURL;
    }

    private static ChangeLogSet<? extends ChangeLogSet.Entry> findChangeSet(Run run) {
        ChangeLogSet<? extends ChangeLogSet.Entry> cs = BuildEvent.getChangeSet(run);
        if (run != null && cs.isEmptySet()) {
            return BuildEvent.findChangeSet(run.getPreviousBuild());
        }
        return cs;
    }

    private static ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet(Run run) {
        List changeSets;
        if (run == null) {
            return ChangeLogSet.createEmpty((Run)run);
        }
        if (run instanceof AbstractBuild) {
            return ((AbstractBuild)run).getChangeSet();
        }
        if (run instanceof WorkflowRun && !(changeSets = ((WorkflowRun)run).getChangeSets()).isEmpty()) {
            return (ChangeLogSet)changeSets.get(changeSets.size() - 1);
        }
        try {
            changeSets = (List)run.getClass().getMethod("getChangeSets", new Class[0]).invoke((Object)run, new Object[0]);
            if (changeSets != null && !changeSets.isEmpty()) {
                for (ChangeLogSet clEntry : changeSets) {
                    if (clEntry.isEmptySet()) continue;
                    return clEntry;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ChangeLogSet.createEmpty((Run)run);
    }

    private static SCM getSCM(Run build) {
        SCM scmServer = null;
        if (build.getParent() instanceof AbstractProject) {
            scmServer = ((AbstractProject)build.getParent()).getScm();
        } else if (build.getParent() instanceof WorkflowJob) {
            WorkflowJob parentWJ = (WorkflowJob)build.getParent();
            scmServer = parentWJ.getTypicalSCM();
        }
        if (scmServer == null) {
            logger.warning("Failed to get repository info for " + build.getId());
        }
        return scmServer;
    }

    private static Run getRawBuild(Run build) {
        Run rawBuild = null;
        try {
            rawBuild = Run.fromExternalizableId((String)build.getExternalizableId());
        }
        catch (Exception e) {
            logger.warning("Failed to get raw build for " + (build == null ? "???" : Integer.valueOf(build.getNumber())));
        }
        return rawBuild;
    }
}

