/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.NullSCM;
import hudson.util.AdaptedIterator;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

public class FakeChangeLogSCM
extends NullSCM {
    private List<Commit> commits = new ArrayList<Commit>();

    public Commit commit(String ... paths) {
        Commit c = new Commit();
        c.paths.addAll(Arrays.asList(paths));
        this.commits.add(c);
        return c;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath remoteDir, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(changeLogFile));
        oos.writeObject(this.commits);
        oos.close();
        this.commits.clear();
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeLogParser(){

            public ChangeLogSet<? extends ChangeLogSet.Entry> parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(changelogFile));
                    final List commits = (List)ois.readObject();
                    ois.close();
                    return new ChangeLogSet<ChangeLogSet.Entry>((Run)build, null){
                        private final ChangeLogSet THIS;
                        {
                            super(x0, x1);
                            this.THIS = this;
                        }

                        public boolean isEmptySet() {
                            return commits.isEmpty();
                        }

                        public Iterator<ChangeLogSet.Entry> iterator() {
                            return new AdaptedIterator<Commit, ChangeLogSet.Entry>(commits.iterator()){

                                protected ChangeLogSet.Entry adapt(final Commit item) {
                                    return new ChangeLogSet.Entry(){
                                        {
                                            this.setParent(THIS);
                                        }

                                        public String getMsg() {
                                            return item.message;
                                        }

                                        public User getAuthor() {
                                            return User.get((String)item.user);
                                        }

                                        public Collection<String> getAffectedPaths() {
                                            return item.paths;
                                        }
                                    };
                                }
                            };
                        }
                    };
                }
                catch (ClassNotFoundException e) {
                    throw new IOException2((Throwable)e);
                }
            }
        };
    }

    public static final class Commit
    implements Serializable {
        private String message = "a commit";
        private String user = "someone";
        private List<String> paths = new ArrayList<String>();
        private static final long serialVersionUID = 1L;

        public Commit by(String user) {
            this.user = user;
            return this;
        }

        public Commit says(String message) {
            this.message = message;
            return this;
        }
    }
}

