/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.AbstractProject;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.rmi.RemoteException;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractTeamForgeNotifier
extends Notifier {
    private boolean override_auth = true;
    private String url;
    private String username;
    private Secret password;
    private String project;

    public AbstractTeamForgeNotifier(ConnectionFactory connectionFactory, String project) {
        boolean bl = this.override_auth = connectionFactory != null;
        if (this.override_auth) {
            this.url = connectionFactory.getUrl();
            this.username = connectionFactory.getUsername();
            this.password = connectionFactory.getPassword();
        }
        this.project = project;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.override_auth ? new ConnectionFactory(this.url, this.username, this.password) : null;
    }

    public boolean overrideAuth() {
        return this.override_auth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.url;
        }
        return AbstractTeamForgeNotifier.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return AbstractTeamForgeNotifier.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return Secret.toString((Secret)this.password);
        }
        return AbstractTeamForgeNotifier.getTeamForgeShareDescriptor().getPassword();
    }

    public CollabNetApp connect() {
        return CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
    }

    public String getProject() {
        return this.project;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        return TeamForgeShare.getTeamForgeShareDescriptor();
    }

    public static abstract class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean canInheritAuth() {
            return AbstractTeamForgeNotifier.getTeamForgeShareDescriptor().useGlobal();
        }

        public FormValidation doCheckProject(CollabNetApp app, @QueryParameter String value) throws RemoteException {
            return CNFormFieldValidator.projectCheck(app, value);
        }

        public ComboBoxModel doFillProjectItems(CollabNetApp cna) {
            ComboBoxModel projects = ComboBoxUpdater.getProjectList(cna);
            CNHudsonUtil.logoff(cna);
            return projects;
        }
    }
}

