/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap60.webservices.cemain.ItemSoapDO;
import com.collabnet.ce.soap60.webservices.docman.DocumentSoapDO;
import com.collabnet.ce.soap60.webservices.docman.DocumentSoapRow;
import com.collabnet.ce.soap60.webservices.docman.IDocumentAppSoap;
import com.collabnet.ce.webservices.CTFFile;
import com.collabnet.ce.webservices.CTFItem;
import com.collabnet.ce.webservices.CTFObject;
import java.rmi.RemoteException;

public class CTFDocument
extends CTFItem {
    private final String description;

    public CTFDocument(CTFObject parent, DocumentSoapRow data) {
        super(parent, CTFDocument.toItemSoapDO(data));
        this.description = data.getDescription();
    }

    public CTFDocument(CTFObject parent, DocumentSoapDO data) {
        super(parent, (ItemSoapDO)data);
        this.description = data.getDescription();
    }

    private static ItemSoapDO toItemSoapDO(DocumentSoapRow data) {
        ItemSoapDO r = new ItemSoapDO();
        r.setTitle(data.getTitle());
        r.setId(data.getId());
        return r;
    }

    public String getDescription() {
        return this.description;
    }

    public void update(CTFFile file) throws RemoteException {
        IDocumentAppSoap soap = this.app.getDocumentAppSoap();
        DocumentSoapDO docData = soap.getDocumentData(this.app.getSessionId(), this.getId(), 0);
        docData.setCurrentVersion(docData.getLatestVersion() + 1);
        soap.setDocumentData(this.app.getSessionId(), docData, file.getId());
    }

    public String getURL() {
        return this.app.getServerUrl() + "/sf/go/" + this.getId();
    }
}

