/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.collabnet.steps;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.orchestrate.AmqpOrchestrateClient;
import hudson.plugins.collabnet.orchestrate.BuildToOrchestrateAPI;
import hudson.plugins.collabnet.orchestrate.DefaultBuildToJSON;
import hudson.plugins.collabnet.orchestrate.DefaultBuildToOrchestrateAPI;
import hudson.plugins.collabnet.orchestrate.OrchestrateClient;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.plugins.collabnet.steps.SynchNonBlockingStepExecution;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PublishEventQStep
extends Step {
    private final String serverUrl;
    private String credentialsId;
    @DataBoundSetter
    public String sourceKey;
    @DataBoundSetter
    public boolean markUnstable;
    @DataBoundSetter
    public String status;
    @DataBoundSetter
    public boolean excludeCommitInfo;

    @DataBoundConstructor
    public PublishEventQStep(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public StepExecution start(StepContext context) throws Exception {
        PublishEventQStepExecution execution = new PublishEventQStepExecution(this, context);
        return execution;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public static class PublishEventQStepExecution
    extends SynchNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = Logger.getLogger(PublishEventQStepExecution.class.getName());
        private transient PublishEventQStep step;
        private transient TaskListener listener;
        private transient Run<?, ?> run;
        private transient BuildToOrchestrateAPI converter;
        private transient OrchestrateClient eventqClient;
        public static String LOG_MESSAGE_PREFIX = "TeamForge EventQ Build Notifier - ";
        public static String LOG_MESSAGE_INVALID_URL = "The URL to the TeamForge EventQ server is missing.";
        public static String LOG_MESSAGE_INVALID_SOURCE_KEY = "The source key for the TeamForge EventQ build source is missing.";

        public PublishEventQStepExecution(PublishEventQStep step, @Nonnull StepContext ctx) throws IOException, InterruptedException {
            super(ctx);
            this.step = step;
            this.listener = (TaskListener)this.getContext().get(TaskListener.class);
            this.run = (Run)this.getContext().get(Run.class);
        }

        @Override
        protected Void run() throws Exception {
            PrintStream consoleLogger = this.listener.getLogger();
            String serverUrl = this.step.getServerUrl();
            if (StringUtils.isBlank((String)serverUrl)) {
                this.markUnstable(consoleLogger, "Build information NOT sent: " + LOG_MESSAGE_INVALID_URL);
                return null;
            }
            String srcKey = this.step.sourceKey;
            if (StringUtils.isBlank((String)srcKey)) {
                this.markUnstable(consoleLogger, "Build information NOT sent: " + LOG_MESSAGE_INVALID_SOURCE_KEY);
                return null;
            }
            try {
                String password;
                String username;
                this.initialize();
                this.log("Sending build information using " + this.eventqClient.getClass().getSimpleName(), consoleLogger);
                String json = this.converter.toOrchestrateAPI(this.run, srcKey.trim(), this.step.status, this.step.excludeCommitInfo);
                StandardUsernamePasswordCredentials c = this.getCredentials();
                String string = username = c == null ? null : c.getUsername();
                String string2 = c == null ? null : (password = c.getPassword() == null ? null : c.getPassword().getPlainText());
                if (c == null) {
                    TeamForgeShare.TeamForgeShareDescriptor d = TeamForgeShare.getTeamForgeShareDescriptor();
                    username = d.getUsername();
                    password = d.getPassword();
                }
                this.eventqClient.postBuild(serverUrl.trim(), username, password, json);
                this.log("Build information sent", consoleLogger);
            }
            catch (IllegalStateException ise) {
                this.markUnstable(consoleLogger, "Build information NOT sent: this step needs a Jenkins URL (go to Manage Jenkins > Configure System; click Save)");
                ise.printStackTrace(consoleLogger);
            }
            catch (Exception e) {
                this.markUnstable(consoleLogger, e.getMessage());
                this.log("Build information NOT sent, details below", consoleLogger);
                e.printStackTrace(consoleLogger);
            }
            return null;
        }

        private void markUnstable(PrintStream consoleLogger, String message) {
            this.log(message, consoleLogger);
            logger.warning(message);
            if ((this.step == null || this.step.markUnstable) && this.run != null) {
                this.run.setResult(Result.UNSTABLE);
            }
        }

        private void initialize() throws URISyntaxException {
            if (this.converter == null) {
                this.converter = new DefaultBuildToOrchestrateAPI(new DefaultBuildToJSON());
            }
            if (this.eventqClient == null) {
                this.eventqClient = new AmqpOrchestrateClient();
            }
        }

        private void log(String msg, PrintStream printStream) {
            printStream.print(LOG_MESSAGE_PREFIX);
            printStream.println(msg);
        }

        public StandardUsernamePasswordCredentials getCredentials() {
            return PublishEventQStepExecution.getCredentials((Item)this.run.getParent(), this.step.getCredentialsId(), this.step.getServerUrl());
        }

        public static StandardUsernamePasswordCredentials getCredentials(Item owner, String credentialsId, String serverUrl) {
            StandardUsernamePasswordCredentials result = null;
            if (!StringUtils.isBlank((String)credentialsId)) {
                for (StandardUsernamePasswordCredentials c : PublishEventQStepExecution.lookupCredentials(owner, serverUrl)) {
                    if (!c.getId().equals(credentialsId)) continue;
                    result = c;
                    break;
                }
            }
            return result;
        }

        public static List<StandardUsernamePasswordCredentials> lookupCredentials(Item owner, String serverUrl) {
            URIRequirementBuilder rBuilder = StringUtils.isBlank((String)serverUrl) ? URIRequirementBuilder.create() : URIRequirementBuilder.fromUri((String)serverUrl);
            return CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, null, (List)rBuilder.build());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "publishEventQ";
        }

        public String getDisplayName() {
            return "Notify TeamForge EventQ";
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().withEmptySelection();
            }
            String useServerUrl = null;
            return new StandardUsernameListBoxModel().withEmptySelection().withAll(PublishEventQStepExecution.lookupCredentials(owner, useServerUrl));
        }

        public ListBoxModel doFillStatusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("-- Auto --", "");
            items.add("SUCCESS", "SUCCESS");
            items.add("UNSTABLE", "UNSTABLE");
            items.add("ABORTED", "ABORTED");
            items.add("FAILURE", "FAILURE");
            return items;
        }

        public FormValidation doCheckServerUrl(@QueryParameter String serverUrl) {
            return FormValidation.validateRequired((String)serverUrl);
        }

        public FormValidation doCheckSourceKey(@QueryParameter String sourceKey) {
            return FormValidation.validateRequired((String)sourceKey);
        }

        public FormValidation doCheckStatus(@QueryParameter String status) {
            if (StringUtils.isBlank((String)status) || status.toLowerCase().startsWith("success") || status.toLowerCase().equals("unstable") || status.toLowerCase().equals("aborted") || status.toLowerCase().startsWith("fail")) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid EventQ status value");
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId, @AncestorInPath Item owner) {
            return FormValidation.ok();
        }
    }
}

