/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.tracker;

import com.collabnet.ce.webservices.CTFArtifact;
import com.collabnet.ce.webservices.CTFFile;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFRelease;
import com.collabnet.ce.webservices.CTFTracker;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.AbstractTeamForgeNotifier;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.tracker.Priority;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.tasks.BuildStepMonitor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CNTracker
extends AbstractTeamForgeNotifier {
    private static int DEFAULT_PRIORITY = Priority.DEFAULT.n;
    private transient BuildListener listener = null;
    private String tracker = null;
    private String title = null;
    private String assign_user = null;
    private int priority = DEFAULT_PRIORITY;
    private boolean attach_log = true;
    private boolean always_update = false;
    private boolean close_issue = true;
    private String release;
    private transient CollabNetApp cna = null;

    @DataBoundConstructor
    public CNTracker(ConnectionFactory connectionFactory, String project, String tracker, String title, String assignUser, Priority priority, boolean attachLog, boolean alwaysUpdate, boolean closeOnSuccess, String release) {
        super(connectionFactory, project);
        this.tracker = tracker;
        this.title = title;
        this.assign_user = assignUser;
        this.priority = priority.n;
        this.attach_log = attachLog;
        this.always_update = alwaysUpdate;
        this.close_issue = closeOnSuccess;
        this.release = release;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void log(String message) {
        if (this.listener != null) {
            message = "CollabNet Tracker: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void log(String methodName, RemoteException re) {
        this.log(methodName + " failed due to " + re.getClass().getName() + ": " + re.getMessage());
    }

    public String getTracker() {
        return this.tracker;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAssignUser() {
        return Util.fixEmpty((String)this.assign_user);
    }

    public Priority getPriority() {
        return Priority.valueOf(this.priority);
    }

    public boolean getAttachLog() {
        return this.attach_log;
    }

    public boolean getAlwaysUpdate() {
        return this.always_update;
    }

    public boolean getCloseOnSuccess() {
        return this.close_issue;
    }

    public String getRelease() {
        return this.release;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.setupLogging(listener);
        this.cna = this.connect();
        if (this.cna == null) {
            this.log("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            build.setResult(Result.UNSTABLE);
            return false;
        }
        try {
            String description;
            CTFProject p = this.cna.getProjectByTitle(this.getProject());
            if (p == null) {
                this.log("Critical Error: projectId cannot be found for " + this.getProject() + ".  This could mean that the project does not exist OR that the user logging in does not have access to that project.  Setting build status to UNSTABLE (or worse).");
                build.setResult(Result.UNSTABLE);
                boolean bl = false;
                return bl;
            }
            CTFTracker t = p.getTrackers().byTitle(this.tracker);
            if (t == null) {
                this.log("Critical Error: trackerId cannot be found for " + this.tracker + ".  This could mean the tracker does not exist OR that the user logging in does not have access to that tracker.  Setting build status to UNSTABLE (or worse).");
                build.setResult(Result.UNSTABLE);
                boolean bl = false;
                return bl;
            }
            CTFArtifact issue = this.findTrackerArtifact(t, build);
            Result buildStatus = build.getResult();
            if (issue == null) {
                if (buildStatus.isWorseThan(Result.SUCCESS)) {
                    this.log("Build is not successful; opening a new issue.");
                    description = "The build has failed.  Latest build status: " + build.getResult() + ".  For more info, see " + this.getBuildUrl(build);
                    this.createNewTrackerArtifact(t, "Open", description, build);
                } else {
                    this.log("Build is successful!");
                    if (this.getAlwaysUpdate()) {
                        description = "The build has succeeded.  For more info, see " + this.getBuildUrl(build);
                        this.createNewTrackerArtifact(t, "Closed", description, build);
                    }
                }
            } else {
                issue.refill();
                if (issue.getStatusClass().equals("Open") && buildStatus.isWorseThan(Result.SUCCESS)) {
                    this.log("Build is continuing to fail; updating issue.");
                    this.updateFailingBuild(issue, build);
                } else if (issue.getStatusClass().equals("Open") && buildStatus.isBetterOrEqualTo(Result.SUCCESS)) {
                    if (this.getCloseOnSuccess()) {
                        this.log("Build succeeded; closing issue.");
                        this.closeSucceedingBuild(issue, build);
                    } else {
                        this.log("Build succeeded; updating issue.");
                        this.updateSucceedingBuild(issue, build);
                    }
                } else if (issue.getStatusClass().equals("Close") && buildStatus.isWorseThan(Result.SUCCESS)) {
                    if (this.getAlwaysUpdate()) {
                        this.log("Build is not successful; re-opening issue.");
                        this.updateFailingBuild(issue, build);
                    } else {
                        this.log("Build is not successful; opening a new issue.");
                        description = "The build has failed.  Latest build status: " + build.getResult() + ".  For more info, see " + this.getBuildUrl(build);
                        this.createNewTrackerArtifact(t, "Open", description, build);
                    }
                } else if (issue.getStatusClass().equals("Close") && buildStatus.isBetterOrEqualTo(Result.SUCCESS)) {
                    this.log("Build continues to be successful!");
                    if (this.getAlwaysUpdate()) {
                        this.updateSucceedingBuild(issue, build);
                    }
                } else {
                    this.log("Unexpected state:  result is: " + buildStatus + ".  Issue status class is: " + issue.getStatusClass() + ".");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.logoff();
        }
    }

    public void logoff() {
        CNHudsonUtil.logoff(this.cna);
        this.cna = null;
    }

    public CTFArtifact findTrackerArtifact(CTFTracker tracker, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call findTrackerArtifact, not logged in!");
            return null;
        }
        String title = this.getInterpreted(build, this.getTitle());
        List<CTFArtifact> r = tracker.getArtifactsByTitle(title);
        Collections.sort(r, new Comparator<CTFArtifact>(){

            @Override
            public int compare(CTFArtifact o1, CTFArtifact o2) {
                return o2.getLastModifiedDate().compareTo(o1.getLastModifiedDate());
            }
        });
        if (r.size() > 0) {
            return r.get(0);
        }
        return null;
    }

    public CTFArtifact createNewTrackerArtifact(CTFTracker t, String status, String description, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call createNewTrackerArtifact, not logged in!");
            return null;
        }
        CTFFile buildLog = null;
        if (this.getAttachLog()) {
            buildLog = this.uploadBuildLog(build);
            if (buildLog != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String assignTo = this.getValidAssignUser(t.getProject());
        String title = this.getInterpreted(build, this.getTitle());
        CTFRelease release = CNHudsonUtil.getProjectReleaseId(t.getProject(), this.getRelease());
        try {
            CTFArtifact asd = t.createArtifact(title, description, null, null, status, null, this.priority, 0, assignTo, release != null ? release.getId() : null, null, build.getLogFile().getName(), "text/plain", buildLog);
            this.log("Created tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + asd.getURL() + ".");
            return asd;
        }
        catch (RemoteException re) {
            this.log("createNewTrackerArtifact", re);
            return null;
        }
    }

    private String getValidAssignUser(CTFProject p) throws RemoteException {
        if (!p.hasMember(this.assign_user)) {
            this.log("User (" + this.assign_user + ") is not a member of the project (" + this.getProject() + ").  Instead any new issues filed will be assigned to 'None'.");
            return null;
        }
        return this.assign_user;
    }

    public void updateFailingBuild(CTFArtifact issue, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call updateFailingBuild, not logged in!");
            return;
        }
        CTFFile buildLog = null;
        if (this.getAttachLog()) {
            buildLog = this.uploadBuildLog(build);
            if (buildLog != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String update = "Updated";
        if (!issue.getStatus().equals("Open")) {
            issue.setStatus("Open");
            update = "Updated and reopened";
        }
        String comment = "The build is continuing to fail.  Latest build status: " + build.getResult() + ".  For more info, see " + this.getBuildUrl(build);
        String title = this.getInterpreted(build, this.getTitle());
        try {
            issue.update(comment, build.getLogFile().getName(), "text/plain", buildLog);
            this.log(update + " tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + issue.getURL() + " with failed status.");
        }
        catch (RemoteException re) {
            this.log("updateFailingBuild", re);
        }
        catch (IOException ioe) {
            this.log("updateFailingBuild failed due to IOException:" + ioe.getMessage());
        }
    }

    public void updateSucceedingBuild(CTFArtifact issue, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return;
        }
        CTFFile buildLog = null;
        if (this.getAttachLog()) {
            buildLog = this.uploadBuildLog(build);
            if (buildLog != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String comment = "The build is succeeding.  For more info, see " + this.getBuildUrl(build);
        String title = this.getInterpreted(build, this.getTitle());
        try {
            issue.update(comment, build.getLogFile().getName(), "text/plain", buildLog);
            this.log("Updated tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + issue.getURL() + " with successful status.");
        }
        catch (RemoteException re) {
            this.log("updateSucceedingBuild", re);
        }
        catch (IOException ioe) {
            this.log("updateSuccedingBuild failed due to IOException:" + ioe.getMessage());
        }
    }

    public void closeSucceedingBuild(CTFArtifact issue, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return;
        }
        CTFFile buildLog = null;
        if (this.getAttachLog()) {
            buildLog = this.uploadBuildLog(build);
            if (buildLog != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String comment = "The build succeeded!  Closing issue.  For more info, see " + this.getBuildUrl(build);
        issue.setStatusClass("Close");
        issue.setStatus("Closed");
        String title = this.getInterpreted(build, this.getTitle());
        try {
            issue.update(comment, build.getLogFile().getName(), "text/plain", buildLog);
            this.log("Closed tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + issue.getURL() + " with successful status.");
        }
        catch (RemoteException re) {
            this.log("closeSucceedingBuild", re);
        }
    }

    private String getBuildUrl(AbstractBuild<?, ?> build) {
        Hudson hudson = Hudson.getInstance();
        String rootUrl = hudson.getRootUrl();
        if (rootUrl == null) {
            return "Jenkins Build #" + build.number;
        }
        return hudson.getRootUrl() + build.getUrl();
    }

    private CTFFile uploadBuildLog(AbstractBuild<?, ?> build) {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return null;
        }
        try {
            return this.cna.upload(build.getLogFile());
        }
        catch (RemoteException re) {
            this.log("uploadBuildLog", re);
            return null;
        }
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) throws IOException, InterruptedException {
        try {
            return CommonUtil.getInterpreted((Map<String, String>)build.getEnvironment(TaskListener.NULL), str);
        }
        catch (IllegalArgumentException iae) {
            this.log(iae.getMessage());
            throw iae;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractTeamForgeNotifier.DescriptorImpl {
        private static Logger log = Logger.getLogger("CNTrackerDescriptor");

        public String getDisplayName() {
            return "CollabNet Tracker";
        }

        public FormValidation doCheckTracker(CollabNetApp cna, @QueryParameter String project, @QueryParameter String tracker) throws RemoteException {
            return CNFormFieldValidator.trackerCheck(cna, project, tracker);
        }

        public FormValidation doCheckAssignUser(CollabNetApp cna, @QueryParameter String project, @QueryParameter String assignUser) throws RemoteException {
            return CNFormFieldValidator.assignCheck(cna, project, assignUser);
        }

        public FormValidation doRequiredInterpretedCheck(@QueryParameter String value, @QueryParameter String name) throws FormValidation {
            return CNFormFieldValidator.requiredInterpretedCheck(value, name);
        }

        public FormValidation doCheckRelease(CollabNetApp cna, @QueryParameter String project, @QueryParameter(value="package") String rpackage, @QueryParameter String release) throws RemoteException {
            return CNFormFieldValidator.releaseCheck(cna, project, rpackage, release, false);
        }

        public ComboBoxModel doFillTrackerItems(CollabNetApp cna, @QueryParameter String project) throws RemoteException {
            return ComboBoxUpdater.getTrackerList(cna == null ? null : cna.getProjectByTitle(project));
        }

        public ComboBoxModel doFillAssignUserItems(CollabNetApp cna, @QueryParameter String project) throws IOException {
            return ComboBoxUpdater.getUsers(cna, project);
        }

        public ComboBoxModel doFillReleaseItems(CollabNetApp cna, @QueryParameter String project, @QueryParameter(value="package") String _package) throws RemoteException {
            return ComboBoxUpdater.getReleases(cna, project, _package);
        }
    }
}

