/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.orchestrate.AmqpOrchestrateClient;
import hudson.plugins.collabnet.orchestrate.BuildNotifierDescriptor;
import hudson.plugins.collabnet.orchestrate.BuildToOrchestrateAPI;
import hudson.plugins.collabnet.orchestrate.DefaultBuildToJSON;
import hudson.plugins.collabnet.orchestrate.DefaultBuildToOrchestrateAPI;
import hudson.plugins.collabnet.orchestrate.OrchestrateClient;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildNotifier
extends Notifier {
    private String serverUrl;
    private String serverUsername;
    private Secret serverPassword;
    private String sourceKey;
    private String ctfUrl;
    private String ctfUser;
    private Secret ctfPassword;
    private transient BuildToOrchestrateAPI converter;
    private transient OrchestrateClient orchestrateClient;
    private static String LOG_MESSAGE_PREFIX = "TeamForge EventQ Build Notifier - ";
    private String url;
    private String username;
    private Secret password;
    private boolean override_auth = true;
    private boolean useAssociationView = false;

    @DataBoundConstructor
    public BuildNotifier(OptionalAssociationView associationView, String serverUrl, String serverUsername, Secret serverPassword, String sourceKey) {
        if (associationView != null) {
            ConnectionFactory connectionFactory = associationView.connectionFactory;
            boolean bl = this.override_auth = connectionFactory != null;
            if (this.override_auth) {
                this.url = connectionFactory.getUrl();
                this.username = connectionFactory.getUsername();
                this.password = connectionFactory.getPassword();
            }
            this.ctfUrl = this.getCollabNetUrl();
            this.ctfUser = this.getUsername();
            this.ctfPassword = Secret.fromString((String)this.getPassword());
            this.setUseAssociationView(true);
        } else {
            this.ctfUrl = null;
            this.setUseAssociationView(false);
        }
        this.serverUrl = serverUrl;
        this.serverUsername = serverUsername;
        this.serverPassword = serverPassword;
        this.sourceKey = sourceKey;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.url;
        }
        return BuildNotifier.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return BuildNotifier.getTeamForgeShareDescriptor().getUsername();
    }

    public boolean overrideAuth() {
        return this.override_auth;
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return Secret.toString((Secret)this.password);
        }
        return BuildNotifier.getTeamForgeShareDescriptor().getPassword();
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.overrideAuth()) {
            return new ConnectionFactory(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        return TeamForgeShare.getTeamForgeShareDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUsername() {
        return this.serverUsername;
    }

    public String getServerPassword() {
        String plainTextPassword = Secret.toString((Secret)this.serverPassword);
        return StringUtils.isBlank((String)plainTextPassword) ? null : plainTextPassword;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public String getCtfUrl() {
        return this.ctfUrl;
    }

    public void setCtfUrl(String ctfUrl) {
        this.ctfUrl = ctfUrl;
    }

    public String getCtfUser() {
        return this.ctfUser;
    }

    public void setCtfUser(String ctfUser) {
        this.ctfUser = ctfUser;
    }

    public String getCtfPassword() {
        String plainTextPassword = Secret.toString((Secret)this.ctfPassword);
        return StringUtils.isBlank((String)plainTextPassword) ? null : plainTextPassword;
    }

    public BuildNotifierDescriptor getDescriptor() {
        return (BuildNotifierDescriptor)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream consoleLogger = listener.getLogger();
        if (StringUtils.isBlank((String)this.getServerUrl())) {
            this.markUnstable(build, consoleLogger, "Build information NOT sent: the URL to the TeamForge EventQ server is missing.");
            return true;
        }
        if (StringUtils.isBlank((String)this.getSourceKey())) {
            this.markUnstable(build, consoleLogger, "Build information NOT sent: the source key for the TeamForge EventQ build source is missing.");
            return true;
        }
        try {
            this.initialize();
            this.log("Sending build information using " + this.orchestrateClient.getClass().getSimpleName(), consoleLogger);
            String json = this.converter.toOrchestrateAPI((Run)build, this.getSourceKey().trim());
            this.orchestrateClient.postBuild(this.getServerUrl().trim(), this.getServerUsername(), this.getServerPassword(), json);
            this.log("Build information sent", consoleLogger);
        }
        catch (IllegalStateException ise) {
            this.markUnstable(build, consoleLogger, "Build information NOT sent: plugin needs a Jenkins URL (go to Manage Jenkins > Configure System; click Save)");
        }
        catch (Exception e) {
            this.markUnstable(build, consoleLogger, e.getMessage());
            this.log("Build information NOT sent, details below", consoleLogger);
            e.printStackTrace(consoleLogger);
        }
        return true;
    }

    private void markUnstable(AbstractBuild<?, ?> build, PrintStream consoleLogger, String message) {
        this.log(message, consoleLogger);
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        logger.warning(message);
        build.setResult(Result.UNSTABLE);
    }

    private void initialize() throws URISyntaxException {
        if (this.converter == null) {
            this.converter = new DefaultBuildToOrchestrateAPI(new DefaultBuildToJSON());
        }
        if (this.orchestrateClient == null) {
            this.orchestrateClient = new AmqpOrchestrateClient();
        }
    }

    public void setConverter(BuildToOrchestrateAPI newConverter) {
        this.converter = newConverter;
    }

    public void setOrchestrateClient(OrchestrateClient client) {
        this.orchestrateClient = client;
    }

    public OrchestrateClient getOrchestrateClient() {
        return this.orchestrateClient;
    }

    private void log(String msg, PrintStream printStream) {
        printStream.print(LOG_MESSAGE_PREFIX);
        printStream.println(msg);
    }

    public boolean getUseAssociationView() {
        return this.useAssociationView;
    }

    public void setUseAssociationView(boolean useAssociationView) {
        this.useAssociationView = useAssociationView;
    }

    public static class OptionalAssociationView {
        private ConnectionFactory connectionFactory;

        @DataBoundConstructor
        public OptionalAssociationView(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }
    }
}

