/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.filerelease;

import com.collabnet.ce.webservices.CTFFile;
import com.collabnet.ce.webservices.CTFPackage;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFRelease;
import com.collabnet.ce.webservices.CTFReleaseFile;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.AbstractTeamForgeNotifier;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.documentuploader.FilePattern;
import hudson.plugins.collabnet.filerelease.CnfrResultAction;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepMonitor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.MimetypesFileTypeMap;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CNFileRelease
extends AbstractTeamForgeNotifier {
    private transient BuildListener listener = null;
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private static final String RELEASE_STATUS_ACTIVE = "active";
    private static final String MATURITY_NONE = "";
    private transient CollabNetApp cna = null;
    private String rpackage;
    private String release;
    private boolean overwrite;
    private FilePattern[] file_patterns;
    private String description = "";

    @DataBoundConstructor
    public CNFileRelease(ConnectionFactory connectionFactory, String project, String pkg, String release, boolean overwrite, FilePattern[] filePatterns) {
        super(connectionFactory, project);
        this.rpackage = pkg;
        this.release = release;
        this.overwrite = overwrite;
        this.file_patterns = filePatterns;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void logConsole(String message) {
        if (this.listener != null) {
            message = "CollabNet FileRelease: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void log(String methodName, RemoteException re) {
        this.logConsole(methodName + " failed due to " + re.getClass().getName() + ": " + re.getMessage());
    }

    public String getPkg() {
        return this.rpackage;
    }

    public String getRelease() {
        return this.release;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public FilePattern[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new FilePattern[0];
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.setupLogging(listener);
        this.cna = this.connect();
        if (this.cna == null) {
            this.logConsole("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction((Action)this.createAction(0, null));
            return false;
        }
        CTFRelease release = this.getReleaseObject();
        if (release == null) {
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            this.logoff();
            build.addAction((Action)this.createAction(0, release));
            return false;
        }
        int numUploaded = this.uploadFiles(build, release);
        build.addAction((Action)this.createAction(numUploaded, release));
        this.logoff();
        return true;
    }

    public CnfrResultAction createAction(int numUploaded, CTFRelease release) {
        String displaymsg = "Download from CollabNet File Release System";
        return new CnfrResultAction(displaymsg, "/plugin/collabnet/images/48x48/CollabNetFrs.png", "console", release.getUrl(), numUploaded);
    }

    public int uploadFiles(AbstractBuild<?, ?> build, CTFRelease release) throws IOException, InterruptedException {
        int numUploaded = 0;
        this.logConsole("Uploading file to project '" + this.getProject() + "', package '" + this.getPkg() + "', release '" + this.getRelease() + "' on host '" + this.getCollabNetUrl() + "' as user '" + this.getUsername() + "'.");
        for (FilePattern uninterp_fp : this.getFilePatterns()) {
            FilePath[] filePaths;
            String file_pattern;
            try {
                file_pattern = uninterp_fp.interpret(build, (TaskListener)this.listener);
            }
            catch (IllegalArgumentException e) {
                this.logConsole("File pattern " + (Object)((Object)uninterp_fp) + " contained a bad env var.  Skipping.");
                continue;
            }
            if (file_pattern.equals(MATURITY_NONE)) continue;
            for (FilePath uploadFilePath : filePaths = this.getFilePaths(build, file_pattern)) {
                CTFReleaseFile file = null;
                try {
                    file = release.getFileByTitle(uploadFilePath.getName());
                }
                catch (RemoteException re) {
                    this.log("find file", re);
                }
                if (file != null) {
                    if (this.isOverwrite()) {
                        try {
                            file.delete();
                            this.logConsole("Deleted previously uploaded file: " + uploadFilePath.getName());
                        }
                        catch (RemoteException re) {
                            this.log("delete file", re);
                        }
                    } else {
                        this.logConsole("File " + uploadFilePath.getName() + " already exists in the file release system and overwrite is set to false.  Skipping.");
                        continue;
                    }
                }
                try {
                    CTFFile f = new CTFFile(this.cna, (String)uploadFilePath.act((FilePath.FileCallable)new RemoteFrsFileUploader(this.getCollabNetUrl(), this.getUsername(), this.cna.getSessionId())));
                    CTFReleaseFile rf = release.addFile(uploadFilePath.getName(), CNFileRelease.getMimeType(uploadFilePath), f);
                    this.logConsole("Uploaded file " + uploadFilePath.getName() + " -> " + rf.getURL());
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.log("upload file", re);
                }
                catch (IOException ioe) {
                    this.logConsole("Could not upload file due to IOException: " + ioe.toString());
                    ioe.printStackTrace(this.listener.error("error"));
                }
                catch (InterruptedException ie) {
                    this.logConsole("Could not upload file due to InterruptedException: " + ie.getMessage());
                }
            }
        }
        return numUploaded;
    }

    private FilePath[] getFilePaths(AbstractBuild<?, ?> build, String pattern) {
        FilePath workspace = build.getWorkspace();
        String logEntry = "Searching ant pattern '" + pattern + "'";
        FilePath[] uploadFilePaths = new FilePath[]{};
        try {
            uploadFilePaths = workspace.list(pattern);
            logEntry = logEntry + " in " + workspace.absolutize().getRemote();
        }
        catch (IOException ioe) {
            this.logConsole("Could not list workspace due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.logConsole("Could not list workspace due to InterruptedException: " + ie.getMessage());
        }
        logEntry = logEntry + " : found " + uploadFilePaths.length + " entry(ies)";
        this.logConsole(logEntry);
        return uploadFilePaths;
    }

    public static String getMimeType(FilePath f) {
        return new MimetypesFileTypeMap().getContentType(f.getName());
    }

    public void logoff() {
        if (this.cna != null) {
            CNHudsonUtil.logoff(this.cna);
            this.cna = null;
        } else {
            this.logConsole("logoff failed. Not logged in!");
        }
    }

    public CTFRelease getReleaseObject() throws RemoteException {
        CTFProject projectId = this.getProjectObject();
        if (projectId == null) {
            this.logConsole("Critical Error: projectId cannot be found for " + this.getProject() + ".  This could mean that the project does not exist OR that the user logging in does not have access to that project.  Setting build status to UNSTABLE (or worse).");
            return null;
        }
        CTFPackage pkg = projectId.getPackages().byTitle(this.getPkg());
        if (pkg == null) {
            this.logConsole("Critical Error: packageId cannot be found for " + this.getPkg() + ".  Setting build status to UNSTABLE (or worse).");
            return null;
        }
        CTFRelease release = pkg.getReleaseByTitle(this.getRelease());
        if (release == null) {
            release = pkg.createRelease(this.getRelease(), this.description, RELEASE_STATUS_ACTIVE, MATURITY_NONE);
            this.logConsole("Note: releaseId cannot be found for " + this.getRelease() + ".  Creating a new release with specified releaseId. Setting build status to STABLE.");
            return release;
        }
        return release;
    }

    public CTFProject getProjectObject() throws RemoteException {
        if (this.cna == null) {
            this.logConsole("Cannot getProjectId, not logged in!");
            return null;
        }
        return this.cna.getProjectByTitle(this.getProject());
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractTeamForgeNotifier.DescriptorImpl {
        public String getDisplayName() {
            return "CollabNet File Release";
        }

        public FormValidation doCheckPkg(CollabNetApp cna, @QueryParameter String project, @QueryParameter String pkg) throws RemoteException {
            return CNFormFieldValidator.packageCheck(cna, project, pkg);
        }

        public FormValidation doCheckRelease(CollabNetApp cna, @QueryParameter String project, @QueryParameter String pkg, @QueryParameter String release) throws RemoteException {
            return CNFormFieldValidator.releaseCheck(cna, project, pkg, release, true);
        }

        public ComboBoxModel doFillPkgItems(CollabNetApp cna, @QueryParameter String project) throws RemoteException {
            return ComboBoxUpdater.getPackages(cna, project);
        }

        public ComboBoxModel doFillReleaseItems(CollabNetApp cna, @QueryParameter String project, @QueryParameter(value="pkg") String _package) throws RemoteException {
            return ComboBoxUpdater.getReleases(cna, project, _package);
        }
    }

    private static class RemoteFrsFileUploader
    implements FilePath.FileCallable<String> {
        private String mServerUrl;
        private String mUsername;
        private String mSessionId;

        public RemoteFrsFileUploader(String serverUrl, String username, String sessionId) {
            this.mServerUrl = serverUrl;
            this.mUsername = username;
            this.mSessionId = sessionId;
        }

        public String invoke(File f, VirtualChannel channel) throws IOException {
            CollabNetApp cnApp = CNHudsonUtil.recreateCollabNetApp(this.mServerUrl, this.mUsername, this.mSessionId);
            return cnApp.upload(f).getId();
        }

        public void checkRoles(RoleChecker arg0) throws SecurityException {
        }
    }
}

