/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CTFList;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFRole;
import com.collabnet.ce.webservices.CTFUser;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.auth.CNAuthorizationStrategy;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.Permission;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CNAuthProjectProperty
extends JobProperty<Job<?, ?>> {
    public static Permission CONFIGURE_PROPERTY = Item.CONFIGURE;
    private transient boolean mIsNotLoadedFromDisk = false;
    private transient String project = null;
    private String projectId = null;
    private boolean createRoles = false;
    private boolean grantDefaultRoles = false;
    private static Logger log = Logger.getLogger("CNAuthProjectProperty");
    private static Collection<String> defaultAdminRoles = Collections.emptyList();
    private static Collection<String> defaultUserRoles = Collections.emptyList();

    @DataBoundConstructor
    public CNAuthProjectProperty(String project, boolean createRoles, String storedProjectId, boolean grantDefaultRoles) {
        this.project = project;
        this.createRoles = createRoles;
        this.grantDefaultRoles = grantDefaultRoles;
        if (this.createRoles || this.grantDefaultRoles) {
            this.loadRoles();
        }
        this.mIsNotLoadedFromDisk = true;
        this.loadProjectIdIfNecessary();
        if (!CommonUtil.isEmpty(this.getProject()) && CommonUtil.isEmpty(this.getProjectId())) {
            this.setProjectId(storedProjectId);
        }
    }

    private void loadProjectIdIfNecessary() {
        if (CommonUtil.isEmpty(this.projectId) && !CommonUtil.isEmpty(this.project)) {
            CollabNetApp conn = CNConnection.getInstance();
            if (conn == null) {
                return;
            }
            try {
                CTFProject p = conn.getProjectByTitle(this.project);
                this.projectId = p != null ? p.getId() : null;
            }
            catch (RemoteException e) {
                this.projectId = null;
                log.log(Level.WARNING, "Failed to load project ID of " + this.project, e);
            }
            if (!this.mIsNotLoadedFromDisk && this.owner != null) {
                try {
                    this.mIsNotLoadedFromDisk = true;
                    this.owner.save();
                }
                catch (IOException e) {
                    log.info("Failed to modify config file for migration of project name to project id");
                }
            }
        }
    }

    public String getProject() {
        CollabNetApp conn;
        this.loadProjectIdIfNecessary();
        if (!CommonUtil.isEmpty(this.projectId) && (conn = CNConnection.getInstance()) != null) {
            try {
                CTFProject p = conn.getProjectById(this.projectId);
                if (p != null) {
                    return p.getTitle();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return this.project;
    }

    public String getProjectId() {
        this.loadProjectIdIfNecessary();
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean getCreateRoles() {
        return this.createRoles;
    }

    public boolean getGrantDefaultRoles() {
        return this.grantDefaultRoles;
    }

    public Collection<String> getDefaultUserRoles() {
        if (defaultUserRoles.isEmpty()) {
            defaultUserRoles = new ArrayList<String>();
            defaultUserRoles.add("Hudson Read");
        }
        return defaultUserRoles;
    }

    public Collection<String> getDefaultAdminRoles() {
        if (defaultAdminRoles.isEmpty()) {
            defaultAdminRoles = CNProjectACL.CollabNetRoles.getNames();
        }
        return defaultAdminRoles;
    }

    private void loadRoles() {
        String projectIdStr = this.getProjectId();
        if (!CommonUtil.isEmpty(projectIdStr)) {
            try {
                CollabNetApp conn = CNConnection.getInstance();
                if (conn == null) {
                    log.warning("Cannot loadRoles, incorrect authentication type.");
                    return;
                }
                CTFProject p = conn.getProjectById(this.getProjectId());
                if (this.getCreateRoles()) {
                    CTFList<CTFRole> existing = p.getRoles();
                    for (CollabNetRole role : CNProjectACL.CollabNetRoles.getAllRoles()) {
                        if (existing.byTitle(role.getName()) != null) continue;
                        p.createRole(role.getName(), role.getDescription());
                    }
                }
                if (this.getGrantDefaultRoles()) {
                    this.grantRoles(p, this.getDefaultUserRoles(), p.getMembers());
                    this.grantRoles(p, this.getDefaultAdminRoles(), p.getAdmins());
                }
            }
            catch (RemoteException e) {
                log.log(Level.WARNING, "Cannot loadRoles, incorrect authentication type.", e);
            }
        }
    }

    private void grantRoles(CTFProject p, Collection<String> roleNames, List<CTFUser> members) throws RemoteException {
        CTFList<CTFRole> roles = p.getRoles();
        for (String name : roleNames) {
            CTFRole r = roles.byTitle(name);
            if (r == null) continue;
            CTFList<CTFUser> existing = r.getMembers();
            for (CTFUser m : members) {
                if (existing.contains(m)) continue;
                try {
                    r.grant(m);
                }
                catch (RemoteException re) {
                    log.severe("grantRoles: failed with RemoteException: " + re.getMessage());
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "Associated CollabNet Project";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Hudson.getInstance().getAuthorizationStrategy() instanceof CNAuthorizationStrategy;
        }

        public FormValidation doCheckProject(@QueryParameter String value) throws RemoteException {
            String project = value;
            if (CommonUtil.isEmpty(project)) {
                return FormValidation.warning((String)"If left empty, all users will be able to configure and access this build");
            }
            CNAuthentication auth = CNAuthentication.get();
            if (auth == null) {
                return FormValidation.warning((String)"Cannot check project name, improper authentication type.");
            }
            CTFProject p = auth.getCredentials().getProjectByTitle(project);
            boolean superUser = auth.isSuperUser();
            boolean hudsonAdmin = Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER);
            if (p == null) {
                if (superUser) {
                    return FormValidation.error((String)"This project does not exist.");
                }
                return FormValidation.error((String)"The current user does not have access to this project.  This setting change will not be saved.");
            }
            FormValidation ok = FormValidation.ok((String)("Currently selected project: " + p.getId() + ":" + project));
            if (superUser) {
                return ok;
            }
            if (!auth.isProjectAdmin(p)) {
                return FormValidation.warning((String)"The current user is not a project admin in the project, so he/she cannot create or grant roles.");
            }
            if (hudsonAdmin) {
                return ok;
            }
            CNProjectACL acl = new CNProjectACL(p.getId());
            if (!acl.hasPermission(CONFIGURE_PROPERTY)) {
                CollabNetRole roleNeeded = CNProjectACL.CollabNetRoles.getGrantingRole(CONFIGURE_PROPERTY);
                return FormValidation.warning((String)("The current user does not have the '" + roleNeeded.getName() + "' role in the project, which is required to configure this Jenkins job.  If this project is chosen, the current user will not have the power to change the project later, unless he/she is given this role."));
            }
            return ok;
        }

        public ComboBoxModel doFillProjectItems() throws RemoteException {
            CollabNetApp conn = CNConnection.getInstance();
            return ComboBoxUpdater.getProjectList(conn);
        }

        public String getCollabNetUrl() {
            CollabNetApp conn = CNConnection.getInstance();
            return conn.getServerUrl();
        }
    }
}

