/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CollabNetSecurityRealm;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ConnectionFactory
extends AbstractDescribableImpl<ConnectionFactory> {
    private final String url;
    private final String username;
    private final Secret password;

    @DataBoundConstructor
    public ConnectionFactory(String url, String username, String password) {
        this(url, username, Secret.fromString((String)password));
    }

    public ConnectionFactory(String url, String username, Secret password) {
        this.url = CNHudsonUtil.sanitizeCollabNetUrl(url);
        this.username = username;
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConnectionFactory that = (ConnectionFactory)((Object)o);
        if (this.password != null ? !this.password.equals((Object)that.password) : that.password != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    public static ConnectionFactory fromStapler(@QueryParameter String url, @QueryParameter String username, @QueryParameter String password) {
        if (CommonUtil.unset(url) || CommonUtil.unset(username) || CommonUtil.unset(password)) {
            return null;
        }
        return new ConnectionFactory(url, username, password);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ConnectionFactory> {
        public static String url;
        public static boolean isSiteConfigured;

        public String getDisplayName() {
            return "";
        }

        public static String getUrl() {
            if (isSiteConfigured) {
                return url;
            }
            return DescriptorImpl.getTeamForgeShareDescriptor().getCollabNetUrl();
        }

        public boolean useGlobal() {
            return DescriptorImpl.getTeamForgeShareDescriptor().useGlobal();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            return CNFormFieldValidator.soapUrlCheck(value);
        }

        public boolean isSiteConfigured() {
            try {
                SecurityRealm securityRealm = Hudson.getInstance().getSecurityRealm();
                CollabNetSecurityRealm cnRealm = (CollabNetSecurityRealm)securityRealm;
                url = cnRealm.getCollabNetUrl();
                isSiteConfigured = true;
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
            return TeamForgeShare.getTeamForgeShareDescriptor();
        }

        public FormValidation doCheckUsername(@QueryParameter String value) {
            return CNFormFieldValidator.requiredCheck(value, "username");
        }

        public FormValidation doCheckPassword(ConnectionFactory connectionFactory, @QueryParameter String value) {
            CollabNetApp app = connectionFactory == null ? null : CNHudsonUtil.getCollabNetApp(connectionFactory.getUrl(), connectionFactory.getUsername(), connectionFactory.getPassword().getPlainText());
            return CNFormFieldValidator.loginCheck(app, value);
        }

        static {
            isSiteConfigured = false;
        }
    }
}

