/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import hudson.util.Secret;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.jenkinsci.plugins.codefresh.CFComposition;
import org.jenkinsci.plugins.codefresh.CFPipeline;

public class CFProfile {
    private final String cfUser;
    private final Secret cfToken;
    private final String cfUrl;
    private List<CFPipeline> services;
    private List<CFComposition> compositions;
    private CFApi api;
    private boolean selfSignedCert;

    public CFProfile(String cfUser, Secret cfToken, String cfUrl, boolean selfSignedCert) throws IOException {
        this.cfUser = cfUser;
        this.cfToken = cfToken;
        this.cfUrl = cfUrl;
        this.selfSignedCert = selfSignedCert;
        this.api = new CFApi();
        this.services = this.api.getPipelines();
        this.compositions = this.api.getCompositions();
    }

    public String getUser() {
        return this.cfUser;
    }

    public Secret getToken() {
        return this.cfToken;
    }

    public int testConnection() throws IOException {
        this.api = new CFApi(this.cfToken, this.cfUrl, this.selfSignedCert);
        this.api.getConnection("");
        return 0;
    }

    String getServiceIdByName(String serviceName) {
        for (CFPipeline service : this.services) {
            if (!service.getName().equals(serviceName)) continue;
            return service.getId();
        }
        return null;
    }

    String getServiceIdByPath(String gitPath) {
        String serviceName = gitPath.split("/")[2].split("\\.")[0];
        for (CFPipeline service : this.services) {
            if (!service.getName().equals(serviceName)) continue;
            return service.getId();
        }
        return null;
    }

    String getServiceRepoOwner(String serviceId) {
        for (CFPipeline service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            return service.getRepoOwner();
        }
        return null;
    }

    String getServiceRepoName(String serviceId) {
        for (CFPipeline service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            return service.getRepoName();
        }
        return null;
    }

    String getCompositionIdByName(String compositionName) {
        for (CFComposition composition : this.compositions) {
            if (!composition.getName().equals(compositionName)) continue;
            return composition.getId();
        }
        return null;
    }
}

