/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.jenkinsci.plugins.codefresh.CodefreshBuildBadgeAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class CFEnvTerminator
extends Recorder {
    private boolean terminateOnFailure;

    @DataBoundConstructor
    public CFEnvTerminator(boolean terminateOnFailure) {
        this.terminateOnFailure = terminateOnFailure;
    }

    public boolean isTerminateOnFailure() {
        return this.terminateOnFailure;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE && !this.terminateOnFailure) {
            listener.getLogger().println("Not terminating the Codefresh environment as build result was FAILURE");
            return true;
        }
        listener.getLogger().print("\nCodefresh environment termination: ");
        try {
            String envUrl = (String)build.getEnvironment((TaskListener)listener).get((Object)"CODEFRESH_ENV_URL");
            if (envUrl == null || envUrl.isEmpty()) {
                listener.getLogger().println("Couldn't get Codefresh environment url. Did you launch one?");
                return true;
            }
            CFApi api = new CFApi();
            try {
                String envId = api.getEnvIdByURL(envUrl);
                if (!api.terminateEnv(envId)) {
                    listener.getLogger().println("Couldn't terminate Codefresh environment. Did you launch one?");
                    return true;
                }
                listener.getLogger().println("Successfully terminated Codefresh environment " + envId + " at " + envUrl);
                List actions = build.getBadgeActions();
                for (BuildBadgeAction b : actions) {
                    if (!(b instanceof CodefreshBuildBadgeAction) || !((CodefreshBuildBadgeAction)b).getType().equals("Environment")) continue;
                    ((CodefreshBuildBadgeAction)b).setDisplayName("Codefresh Environment Terminated");
                    ((CodefreshBuildBadgeAction)b).setUrl(null);
                }
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(CFEnvTerminator.class.getName()).log(Level.SEVERE, null, ex);
                return true;
            }
        }
        catch (IOException e) {
            listener.getLogger().println("Couldn't get Codefresh configuration. Did you define one?");
            return true;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> type) {
            return true;
        }

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Terminate Codefresh Environment";
        }
    }
}

