/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.codedx.api.client.CodeDxClient;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.CodeDxRepeatingClient;
import com.codedx.api.client.CountGroup;
import com.codedx.api.client.Filter;
import com.codedx.api.client.GitConfigResponse;
import com.codedx.api.client.Project;
import com.codedx.api.client.ProjectContext;
import com.codedx.api.client.StartAnalysisResponse;
import com.codedx.api.client.TriageStatus;
import com.codedx.security.JenkinsSSLConnectionSocketFactoryFactory;
import com.codedx.util.CodeDxVersion;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jenkinsci.plugins.codedx.AnalysisResultChecker;
import org.jenkinsci.plugins.codedx.AnalysisResultConfiguration;
import org.jenkinsci.plugins.codedx.Archiver;
import org.jenkinsci.plugins.codedx.BuildErrorBehavior;
import org.jenkinsci.plugins.codedx.BuildPolicyBehavior;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.DeferredFilePathInputStream;
import org.jenkinsci.plugins.codedx.GitFetchConfiguration;
import org.jenkinsci.plugins.codedx.ProjectResolver;
import org.jenkinsci.plugins.codedx.TargetBranchChecker;
import org.jenkinsci.plugins.codedx.Util;
import org.jenkinsci.plugins.codedx.ValueResolver;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.jenkinsci.plugins.codedx.model.CodeDxReportStatistics;
import org.jenkinsci.plugins.codedx.monitor.AnalysisMonitor;
import org.jenkinsci.plugins.codedx.monitor.DirectAnalysisMonitor;
import org.jenkinsci.plugins.codedx.monitor.GitJobAnalysisMonitor;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class CodeDxPublisher
extends Recorder
implements SimpleBuildStep {
    private final String url;
    private final String keyCredentialId;
    private volatile String projectId = null;
    private ProjectSelection project = null;
    private String sourceAndBinaryFiles;
    private String toolOutputFiles;
    private String excludedSourceAndBinaryFiles;
    private String analysisName;
    private AnalysisResultConfiguration analysisResultConfiguration;
    private transient CodeDxClient client;
    private String selfSignedCertificateFingerprint;
    private String targetBranchName;
    private String baseBranchName;
    private BuildErrorBehavior errorHandlingBehavior;
    private GitFetchConfiguration gitFetchConfiguration;
    private static final Logger logger = Logger.getLogger(CodeDxPublisher.class.getName());

    protected Object readResolve() {
        if (this.project == null && this.projectId != null) {
            this.project = new SpecificProject(this.projectId);
        }
        return this;
    }

    @DataBoundConstructor
    public CodeDxPublisher(String url, String keyCredentialId, String analysisName) {
        this.url = url;
        this.keyCredentialId = keyCredentialId;
        this.analysisName = analysisName.trim();
        this.sourceAndBinaryFiles = "";
        this.excludedSourceAndBinaryFiles = "";
        this.toolOutputFiles = "";
        this.analysisResultConfiguration = null;
        this.selfSignedCertificateFingerprint = null;
        this.targetBranchName = null;
        this.baseBranchName = null;
        this.errorHandlingBehavior = BuildErrorBehavior.MarkFailed;
        this.gitFetchConfiguration = null;
    }

    public AnalysisResultConfiguration getAnalysisResultConfiguration() {
        return this.analysisResultConfiguration;
    }

    @DataBoundSetter
    public void setAnalysisResultConfiguration(AnalysisResultConfiguration analysisResultConfiguration) {
        this.analysisResultConfiguration = analysisResultConfiguration;
    }

    public ProjectSelection getProject() {
        return this.project;
    }

    @DataBoundSetter
    public void setProject(ProjectSelection project) {
        this.project = project;
    }

    public DescriptorExtensionList<ProjectSelection, Descriptor<ProjectSelection>> getProjectDescriptors() {
        return Jenkins.get().getDescriptorList(ProjectSelection.class);
    }

    @Deprecated
    public String getProjectId() {
        return this.projectId;
    }

    @Deprecated
    @DataBoundSetter
    public void setProjectId(String projectId) {
        this.project = new SpecificProject(projectId);
    }

    public String getUrl() {
        return this.url;
    }

    public String getKeyCredentialId() {
        return this.keyCredentialId;
    }

    public String getSourceAndBinaryFiles() {
        return this.sourceAndBinaryFiles;
    }

    @DataBoundSetter
    public void setSourceAndBinaryFiles(String sourceAndBinaryFiles) {
        this.sourceAndBinaryFiles = sourceAndBinaryFiles;
    }

    public String getToolOutputFiles() {
        return this.toolOutputFiles;
    }

    @DataBoundSetter
    public void setToolOutputFiles(String toolOutputFiles) {
        this.toolOutputFiles = toolOutputFiles;
    }

    public String getExcludedSourceAndBinaryFiles() {
        return this.excludedSourceAndBinaryFiles;
    }

    @DataBoundSetter
    public void setExcludedSourceAndBinaryFiles(String excludedSourceAndBinaryFiles) {
        this.excludedSourceAndBinaryFiles = excludedSourceAndBinaryFiles;
    }

    public String getSelfSignedCertificateFingerprint() {
        return this.selfSignedCertificateFingerprint;
    }

    @DataBoundSetter
    public void setSelfSignedCertificateFingerprint(String selfSignedCertificateFingerprint) {
        this.selfSignedCertificateFingerprint = selfSignedCertificateFingerprint;
        this.client = null;
    }

    public String getAnalysisName() {
        return this.analysisName;
    }

    public String getTargetBranchName() {
        return this.targetBranchName;
    }

    @DataBoundSetter
    public void setTargetBranchName(String targetBranchName) {
        if (targetBranchName != null) {
            targetBranchName = targetBranchName.trim();
        }
        this.targetBranchName = targetBranchName != null && targetBranchName.length() > 0 ? targetBranchName : null;
    }

    public String getBaseBranchName() {
        return this.baseBranchName;
    }

    @DataBoundSetter
    public void setBaseBranchName(String baseBranchName) {
        if (baseBranchName != null) {
            baseBranchName = baseBranchName.trim();
        }
        this.baseBranchName = baseBranchName != null && baseBranchName.length() > 0 ? baseBranchName : null;
    }

    public BuildErrorBehavior getErrorHandlingBehavior() {
        return this.errorHandlingBehavior;
    }

    @DataBoundSetter
    public void setErrorHandlingBehavior(BuildErrorBehavior behavior) {
        this.errorHandlingBehavior = behavior;
    }

    public GitFetchConfiguration getGitFetchConfiguration() {
        return this.gitFetchConfiguration;
    }

    @DataBoundSetter
    public void setGitFetchConfiguration(GitFetchConfiguration config) {
        this.gitFetchConfiguration = config;
    }

    private Boolean handleCodeDxError(Run<?, ?> build, PrintStream buildOutput, String cause) throws AbortException {
        buildOutput.println(cause);
        BuildErrorBehavior behavior = this.errorHandlingBehavior;
        if (behavior == null) {
            behavior = BuildErrorBehavior.Default;
        }
        if (behavior != BuildErrorBehavior.None) {
            build.setResult(behavior.getEquivalentResult());
            return false;
        }
        buildOutput.println("This will be ignored since errorHandlingBehavior is set to " + behavior.getLabel());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String status;
        AnalysisMonitor analysisMonitor;
        FilePath sourceAndBinaryZip;
        ProjectContext projectContext;
        CodeDxVersion cdxVersion;
        CodeDxRepeatingClient repeatingClient;
        PrintStream buildOutput;
        Date startingDate;
        block67: {
            String[] files;
            startingDate = new Date();
            StringCredentials apiCredentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.keyCredentialId, StringCredentials.class, build, (List)URIRequirementBuilder.fromUri((String)this.url).build());
            if (apiCredentials == null) {
                throw new AbortException("Unable to load credential for API Key");
            }
            String apiKey = apiCredentials.getSecret().getPlainText();
            this.client = CodeDxPublisher.buildClient(this.url, apiKey, this.selfSignedCertificateFingerprint);
            HashMap<String, InputStream> toSend = new HashMap<String, InputStream>();
            buildOutput = listener.getLogger();
            buildOutput.println("Publishing build to Code Dx:");
            if (this.errorHandlingBehavior == null) {
                this.errorHandlingBehavior = BuildErrorBehavior.Default;
            }
            buildOutput.println("Error handling set to: " + this.errorHandlingBehavior.getLabel());
            buildOutput.println("Publishing to Code Dx server at: " + this.url);
            repeatingClient = new CodeDxRepeatingClient(this.client, buildOutput);
            cdxVersion = null;
            try {
                cdxVersion = repeatingClient.getCodeDxVersion();
                buildOutput.println("Got Code Dx version: " + cdxVersion);
            }
            catch (Exception e) {
                e.printStackTrace(buildOutput);
                if (this.handleCodeDxError(build, buildOutput, "An error occurred fetching the Code Dx version") == false) return;
                buildOutput.println("The Code Dx plugin cannot continue without verifying the Code Dx version, exiting");
                return;
            }
            buildOutput.println("Resolving Code Dx project...");
            if (this.project == null || this.project.isEmpty()) {
                buildOutput.println("No project has been selected");
                return;
            }
            ValueResolver valueResolver = new ValueResolver(build, workspace, listener, buildOutput);
            String resolvedBaseBranchName = this.baseBranchName != null ? valueResolver.resolve("base branch", this.baseBranchName) : null;
            String resolvedTargetBranchName = this.targetBranchName != null ? valueResolver.resolve("target branch", this.targetBranchName) : null;
            try {
                int projectId = new ProjectResolver(buildOutput, this.client).resolveProjectId(this.project, resolvedBaseBranchName);
                buildOutput.println(String.format("Resolved final project ID '%d'", projectId));
                projectContext = new ProjectContext(projectId);
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace(buildOutput);
                this.handleCodeDxError(build, buildOutput, "An error occurred while resolving the Code Dx project");
                return;
            }
            TargetBranchChecker branchChecker = new TargetBranchChecker(projectContext, repeatingClient, buildOutput);
            try {
                branchChecker.validate(cdxVersion, resolvedTargetBranchName, resolvedBaseBranchName);
            }
            catch (AbortException e) {
                throw e;
            }
            catch (IOException e) {
                e.printStackTrace(buildOutput);
                this.handleCodeDxError(build, buildOutput, "An error occurred while validating branch selection");
                return;
            }
            projectContext = projectContext.withBranch(branchChecker.getTargetBranchName());
            buildOutput.println("Creating source/binary zip...");
            sourceAndBinaryZip = Archiver.archive(workspace, Util.commaSeparatedToArray(this.sourceAndBinaryFiles), Util.commaSeparatedToArray(this.excludedSourceAndBinaryFiles), "source");
            if (sourceAndBinaryZip != null) {
                buildOutput.println("Adding source/binary zip...");
                toSend.put("Jenkins-SourceAndBinary.zip", new DeferredFilePathInputStream(sourceAndBinaryZip));
            } else {
                buildOutput.println("No matching source/binary files.");
            }
            for (String file : files = Util.commaSeparatedToArray(this.toolOutputFiles)) {
                if (file.length() == 0) continue;
                FilePath path = workspace.child(file);
                if (path.exists()) {
                    buildOutput.println("Add tool output file " + path.getRemote() + " to request.");
                    toSend.put(path.getName(), new DeferredFilePathInputStream(path));
                    continue;
                }
                buildOutput.println("Path specified but could not be found: " + path);
            }
            GitFetchConfiguration effectiveGitConfig = this.gitFetchConfiguration;
            if (effectiveGitConfig != null) {
                buildOutput.println("Verifying git config for Code Dx project...");
                try {
                    GitConfigResponse response = repeatingClient.getProjectGitConfig(projectContext);
                    if (response.getUrl().isEmpty()) {
                        buildOutput.println("'Include Git Source' was enabled but the project does not have a Git config assigned. 'Include Git Source' will be disabled for this run.");
                        effectiveGitConfig = null;
                    }
                }
                catch (Exception e) {
                    if (!this.handleCodeDxError(build, buildOutput, "There was a problem fetching the project's Git config").booleanValue()) {
                        return;
                    }
                    buildOutput.println("'Include Git Source' will be disabled for this run.");
                    effectiveGitConfig = null;
                }
            }
            if (toSend.size() <= 0) {
                if (effectiveGitConfig == null) throw new AbortException("Nothing to send, this doesn't seem right! Please check your 'Code Dx > Source and Binary Files' configuration.");
            }
            try {
                buildOutput.println("Submitting files to Code Dx for analysis");
                try {
                    StartAnalysisResponse response;
                    boolean includeGitSource = effectiveGitConfig != null;
                    String targetGitBranch = null;
                    if (includeGitSource) {
                        targetGitBranch = effectiveGitConfig.getSpecificBranch();
                        if (targetGitBranch != null) {
                            targetGitBranch = valueResolver.resolve("Git branch", targetGitBranch);
                            buildOutput.println("Using Git branch for Code Dx: " + targetGitBranch);
                        } else {
                            buildOutput.println("No Git branch specified, using Code Dx project's default Git branch");
                        }
                    }
                    if ((response = repeatingClient.startAnalysis(projectContext.getProjectId(), includeGitSource, targetGitBranch, branchChecker.getBaseBranchName(), branchChecker.getTargetBranchName(), toSend)) == null) {
                        this.handleCodeDxError(build, buildOutput, "Received null data for the analysis job");
                        return;
                    }
                    analysisMonitor = effectiveGitConfig != null ? new GitJobAnalysisMonitor(response, buildOutput) : new DirectAnalysisMonitor(response, buildOutput);
                }
                catch (CodeDxClientException e) {
                    String errorSpecificMessage;
                    switch (e.getHttpCode()) {
                        case 400: {
                            errorSpecificMessage = " (Bad Request: have you included files from unsupported Tools? Code Dx Standard Edition does not support uploading tool results)";
                            break;
                        }
                        case 403: {
                            errorSpecificMessage = " (Forbidden: have you configured your key and permissions correctly?)";
                            break;
                        }
                        case 404: {
                            errorSpecificMessage = " (Project Not Found: is it possible it was deleted?)";
                            break;
                        }
                        case 500: {
                            errorSpecificMessage = " (Internal Server Error: Please check your Code Dx server logs for more details)";
                            break;
                        }
                        default: {
                            errorSpecificMessage = "";
                        }
                    }
                    String message = String.format("Failed to start analysis%s.", errorSpecificMessage) + '\n' + String.format("Response Status: %d: %s", e.getHttpCode(), e.getResponseMessage()) + '\n' + String.format("Response Content: %s", e.getResponseContent()) + '\n' + Util.getStackTrace(e);
                    buildOutput.println(message);
                    this.handleCodeDxError(build, buildOutput, "Failed to start analysis");
                    if (sourceAndBinaryZip == null) return;
                    sourceAndBinaryZip.delete();
                    return;
                }
                finally {
                    Iterator entry = toSend.entrySet().iterator();
                    while (true) {
                        if (!entry.hasNext()) {
                        }
                        Map.Entry entry2 = entry.next();
                        IOUtils.closeQuietly((InputStream)((InputStream)entry2.getValue()));
                    }
                }
                buildOutput.println("Code Dx accepted files for analysis");
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace(buildOutput);
                this.handleCodeDxError(build, buildOutput, "An unexpected error occurred");
                return;
            }
            int analysisId = analysisMonitor.waitForStart(repeatingClient);
            if (this.analysisName == null || this.analysisName.length() == 0) {
                buildOutput.println("No 'Analysis Name' was chosen.");
            } else if (analysisId == -1) {
                buildOutput.println("Code Dx did not provide an analysis ID - the 'Analysis Name' will not be applied.");
            } else {
                String expandedAnalysisName = valueResolver.resolve("analysis name", this.analysisName);
                buildOutput.println("Analysis Name: " + expandedAnalysisName);
                buildOutput.println("Analysis Id: " + analysisId);
                if (cdxVersion.compareTo(CodeDxVersion.MIN_FOR_ANALYSIS_NAMES) < 0) {
                    buildOutput.println("The connected Code Dx server is only version " + cdxVersion + ", which doesn't support naming analyses (minimum supported version is " + CodeDxVersion.MIN_FOR_ANALYSIS_NAMES + "). The analysis name will not be set.");
                } else {
                    try {
                        repeatingClient.setAnalysisName(projectContext, analysisId, expandedAnalysisName);
                        buildOutput.println("Successfully updated analysis name.");
                    }
                    catch (CodeDxClientException e) {
                        e.printStackTrace(buildOutput);
                        if (this.handleCodeDxError(build, buildOutput, "Got error from Code Dx API Client while trying to set the analysis name").booleanValue()) break block67;
                        if (sourceAndBinaryZip == null) return;
                        sourceAndBinaryZip.delete();
                        return;
                    }
                }
            }
        }
        if (this.analysisResultConfiguration == null) {
            logger.info("Project not configured to wait on analysis results");
            return;
        }
        try {
            status = analysisMonitor.waitForFinish(repeatingClient);
        }
        catch (CodeDxClientException e) {
            e.printStackTrace(buildOutput);
            this.handleCodeDxError(build, buildOutput, "There was an error querying for the analysis status");
            if (sourceAndBinaryZip == null) return;
            sourceAndBinaryZip.delete();
            return;
        }
        if ("completed".equals(status)) {
            try {
                buildOutput.println("Analysis succeeded");
                buildOutput.println("Fetching severity counts");
                Filter notGoneFilter = new Filter();
                notGoneFilter.setNotStatus(new String[]{"gone"});
                List<CountGroup> severityCounts = repeatingClient.getFindingsGroupedCounts(projectContext, notGoneFilter, "severity");
                buildOutput.println("Fetching status counts");
                Filter notAssignedFilter = new Filter();
                notAssignedFilter.setNotStatus(new String[]{"assigned", "gone"});
                List<CountGroup> statusCounts = repeatingClient.getFindingsGroupedCounts(projectContext, notAssignedFilter, "status");
                Filter assignedFilter = new Filter();
                assignedFilter.setStatus(new String[]{"assigned"});
                buildOutput.println("Fetching assigned count");
                int assignedCount = repeatingClient.getFindingsCount(projectContext, assignedFilter);
                if (assignedCount > 0) {
                    CountGroup assignedGroup = new CountGroup();
                    assignedGroup.setName("Assigned");
                    assignedGroup.setCount(assignedCount);
                    statusCounts.add(assignedGroup);
                }
                buildOutput.println("Building table and charts");
                HashMap<String, CodeDxReportStatistics> statMap = new HashMap<String, CodeDxReportStatistics>();
                statMap.put("severity", this.createStatistics(severityCounts));
                statMap.put("status", this.createStatistics(statusCounts));
                CodeDxResult result = new CodeDxResult(statMap, build);
                buildOutput.println("Adding CodeDx build action");
                build.addAction((Action)new CodeDxBuildAction(build, this.analysisResultConfiguration, this.client.buildLatestFindingsUrl(projectContext.getProjectId()), result));
                AnalysisResultChecker checker = new AnalysisResultChecker(repeatingClient, cdxVersion, this.analysisResultConfiguration.getFailureSeverity(), this.analysisResultConfiguration.getUnstableSeverity(), startingDate, this.analysisResultConfiguration.isFailureOnlyNew(), this.analysisResultConfiguration.isUnstableOnlyNew(), this.analysisResultConfiguration.getPolicyBreakBuildBehavior(), projectContext, buildOutput);
                Result buildResult = checker.checkResult();
                build.setResult(buildResult);
                return;
            }
            catch (CodeDxClientException e) {
                e.printStackTrace(buildOutput);
                this.handleCodeDxError(build, buildOutput, "There was an error fetching/processing analysis results");
                return;
            }
        }
        buildOutput.println("Analysis status: " + status);
        this.handleCodeDxError(build, buildOutput, "Analysis status was non-success");
        return;
        finally {
            if (sourceAndBinaryZip != null) {
                sourceAndBinaryZip.delete();
            }
        }
    }

    public static CodeDxClient buildClient(String url, String key, String fingerprint) {
        CodeDxClient client = new CodeDxClient(url, key);
        try {
            if (fingerprint != null) {
                fingerprint = fingerprint.replaceAll("[^a-fA-F0-9]", "");
            }
            URL parsedUrl = new URL(url);
            SSLConnectionSocketFactory socketFactory = JenkinsSSLConnectionSocketFactoryFactory.getFactory(fingerprint, parsedUrl.getHost());
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            client = new CodeDxClient(url, key, builder);
        }
        catch (MalformedURLException e) {
            logger.warning("A valid CodeDxClient could not be built. Malformed URL: " + url);
        }
        catch (GeneralSecurityException e) {
            logger.warning("A valid CodeDxClient could not be built. GeneralSecurityException: url: " + url + ", fingerprint: " + fingerprint);
        }
        catch (Exception e) {
            logger.warning("An exception was thrown while building the client " + e);
            e.printStackTrace();
        }
        return client;
    }

    private String[] getUsers(Map<String, TriageStatus> assignedStatuses) {
        ArrayList<String> users = new ArrayList<String>();
        for (TriageStatus status : assignedStatuses.values()) {
            if (!status.getType().equals("user")) continue;
            users.add(status.getDisplay());
        }
        return users.toArray(new String[0]);
    }

    private CodeDxReportStatistics createStatistics(List<CountGroup> countGroups) {
        ArrayList<CodeDxGroupStatistics> groupStatsList = new ArrayList<CodeDxGroupStatistics>();
        for (CountGroup group : countGroups) {
            CodeDxGroupStatistics stats = new CodeDxGroupStatistics(group.getName(), group.getCount());
            groupStatsList.add(stats);
        }
        return new CodeDxReportStatistics(groupStatsList);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static void checkPermissionForRemoteRequests(Item item) {
        if (item != null) {
            item.checkPermission(Item.CONFIGURE);
        } else {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        }
    }

    private static String loadApiKeyCredential(Item context, String serverUrl, String credentialId) {
        StringCredentials keyCredential = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (keyCredential == null) {
            return null;
        }
        return keyCredential.getSecret().getPlainText();
    }

    private static boolean isFingerprintMismatch(SSLHandshakeException exception) {
        return exception.getMessage().contains("None of the TrustManagers trust this certificate chain");
    }

    public static class NamedProject
    extends ProjectSelection {
        private String projectName = null;
        private boolean autoCreate = false;

        @DataBoundConstructor
        public NamedProject() {
        }

        public String getProjectName() {
            return this.projectName;
        }

        @DataBoundSetter
        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }

        @DataBoundSetter
        public void setAutoCreate(boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Override
        public boolean isEmpty() {
            return this.projectName == null || this.projectName.isEmpty();
        }

        @Extension
        public static final class DescriptorImpl
        extends ProjectSelectionDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "Project Name";
            }

            @POST
            public FormValidation doCheckProjectName(@RelativePath(value="..") @QueryParameter String url, @RelativePath(value="..") @QueryParameter String selfSignedCertificateFingerprint, @RelativePath(value="..") @QueryParameter String keyCredentialId, @QueryParameter String value, @AncestorInPath Item item) throws IOException {
                CodeDxPublisher.checkPermissionForRemoteRequests(item);
                if (StringUtils.isBlank((String)keyCredentialId) || StringUtils.isBlank((String)url)) {
                    return FormValidation.ok();
                }
                String apiKey = CodeDxPublisher.loadApiKeyCredential(item, url, keyCredentialId);
                if (apiKey == null) {
                    return FormValidation.ok();
                }
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)"Please specify a project name.");
                }
                CodeDxClient client = CodeDxPublisher.buildClient(url, apiKey, selfSignedCertificateFingerprint);
                try {
                    List<Project> projects = client.getProjects();
                    int numMatching = 0;
                    for (Project project : projects) {
                        if (!project.getName().equals(value)) continue;
                        ++numMatching;
                    }
                    if (numMatching == 1) {
                        return FormValidation.ok();
                    }
                    if (numMatching == 0) {
                        return FormValidation.warning((String)"Found no matching projects. The job will fail if no project is matched and auto-create is disabled.");
                    }
                    return FormValidation.warning((String)"Found %d matching projects. The job will fail if multiple projects are matched.", (Object[])new Object[]{numMatching});
                }
                catch (CodeDxClientException e) {
                    if (e.getHttpCode() == 403 || e.getHttpCode() == 401) {
                        return FormValidation.error((String)"The request failed; the API key may be incorrect or disabled.");
                    }
                    return FormValidation.error((String)"An unexpected error occurred while listing available projects.");
                }
            }
        }
    }

    public static class SpecificProject
    extends ProjectSelection {
        private String projectId;

        @DataBoundConstructor
        public SpecificProject() {
            this.projectId = null;
        }

        public SpecificProject(String projectId) {
            this.projectId = projectId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        @DataBoundSetter
        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public boolean isEmpty() {
            return this.projectId == null || this.projectId.isEmpty() || this.projectId.equals("-1");
        }

        @Extension
        public static final class DescriptorImpl
        extends ProjectSelectionDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "Specific Project";
            }

            @POST
            public FormValidation doCheckProjectId(@RelativePath(value="..") @QueryParameter String url, @RelativePath(value="..") @QueryParameter String selfSignedCertificateFingerprint, @RelativePath(value="..") @QueryParameter String keyCredentialId, @QueryParameter String value, @AncestorInPath Item item) throws IOException, ServletException {
                CodeDxPublisher.checkPermissionForRemoteRequests(item);
                if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)keyCredentialId)) {
                    return FormValidation.ok();
                }
                try {
                    String apiKey = CodeDxPublisher.loadApiKeyCredential(item, url, keyCredentialId);
                    if (apiKey == null) {
                        return FormValidation.error((String)"Cannot find currently selected credentials.");
                    }
                    CodeDxClient client = CodeDxPublisher.buildClient(url, apiKey, selfSignedCertificateFingerprint);
                    List<Project> projects = client.getProjects();
                    if (value.length() == 0) {
                        return FormValidation.error((String)"Please set a project.");
                    }
                    int projectId = Integer.parseInt(value);
                    if (projectId == -2) {
                        return FormValidation.error((String)"No projects are visible for the given API key.");
                    }
                    for (Project project : projects) {
                        if (project.getId() != projectId) continue;
                        return FormValidation.ok();
                    }
                    return FormValidation.error((String)"The specified project could not be found.");
                }
                catch (CodeDxClientException e) {
                    if (e.getHttpCode() == 403 || e.getHttpCode() == 401) {
                        return FormValidation.error((String)"The request failed; the API key may be incorrect or disabled.");
                    }
                    return FormValidation.error((String)"An unexpected error occurred while listing available projects.");
                }
            }

            @POST
            public ListBoxModel doFillProjectIdItems(@RelativePath(value="..") @QueryParameter String url, @RelativePath(value="..") @QueryParameter String selfSignedCertificateFingerprint, @RelativePath(value="..") @QueryParameter String keyCredentialId, @AncestorInPath Item item) {
                CodeDxPublisher.checkPermissionForRemoteRequests(item);
                ListBoxModel listBox = new ListBoxModel();
                if (StringUtils.isBlank((String)keyCredentialId) || StringUtils.isBlank((String)url)) {
                    return listBox;
                }
                String apiKey = CodeDxPublisher.loadApiKeyCredential(item, url, keyCredentialId);
                if (apiKey == null) {
                    return listBox;
                }
                CodeDxClient client = CodeDxPublisher.buildClient(url, apiKey, selfSignedCertificateFingerprint);
                try {
                    List<Project> projects = client.getProjects();
                    HashMap<String, Boolean> duplicates = new HashMap<String, Boolean>();
                    for (Project proj : projects) {
                        if (!duplicates.containsKey(proj.getName())) {
                            duplicates.put(proj.getName(), false);
                            continue;
                        }
                        duplicates.put(proj.getName(), true);
                    }
                    for (Project proj : projects) {
                        if (!((Boolean)duplicates.get(proj.getName())).booleanValue()) {
                            listBox.add(proj.getName(), Integer.toString(proj.getId()));
                            continue;
                        }
                        listBox.add(proj.getName() + " (id:" + proj.getId() + ")", Integer.toString(proj.getId()));
                    }
                }
                catch (Exception e) {
                    logger.warning("Exception when populating projects dropdown " + e);
                    listBox.add("", "-1");
                }
                if (listBox.isEmpty()) {
                    listBox.add("", "-2");
                }
                return listBox;
            }
        }
    }

    public static class ProjectSelectionDescriptor
    extends Descriptor<ProjectSelection> {
    }

    public static abstract class ProjectSelection
    implements ExtensionPoint,
    Describable<ProjectSelection> {
        public abstract boolean isEmpty();

        public Descriptor<ProjectSelection> getDescriptor() {
            return Jenkins.get().getDescriptor(this.getClass());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish to Code Dx";
        }

        public ListBoxModel doFillKeyCredentialIdItems(@QueryParameter String url, @QueryParameter String keyCredentialId, @AncestorInPath Item item) {
            if (url == null || url.trim().isEmpty()) {
                return new StandardListBoxModel();
            }
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(keyCredentialId);
            }
            return result.includeMatchingAs(ACL.SYSTEM, item, StringCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), CredentialsMatchers.always()).includeCurrentValue(keyCredentialId);
        }

        public FormValidation doCheckKeyCredentialId(@QueryParameter String url, @QueryParameter String keyCredentialId, @AncestorInPath Item item) throws IOException, ServletException {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.ok();
            }
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)keyCredentialId)) {
                return FormValidation.error((String)"API Key credential cannot be blank");
            }
            if (keyCredentialId.startsWith("${") && keyCredentialId.endsWith("}")) {
                return FormValidation.warning((String)"Cannot validate expression based credentials");
            }
            if (CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)CredentialsMatchers.withId((String)keyCredentialId)).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUrl(@QueryParameter String value, @QueryParameter String selfSignedCertificateFingerprint, @AncestorInPath Item item) throws IOException, ServletException {
            CodeDxPublisher.checkPermissionForRemoteRequests(item);
            CodeDxClient client = CodeDxPublisher.buildClient(value, "", selfSignedCertificateFingerprint);
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a URL.");
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                return FormValidation.error((String)"Malformed URL");
            }
            if (!value.toLowerCase().startsWith("http:") && !value.toLowerCase().startsWith("https:")) {
                return FormValidation.error((String)"Invalid protocol, please use HTTPS or HTTP.");
            }
            try {
                client.getCodeDxVersion();
            }
            catch (CodeDxClientException e) {
                logger.warning("Exception when attempting to check URL for codedx version: " + e.getMessage());
                return FormValidation.error((String)"The given URL does not appear to point to Code Dx.");
            }
            catch (Exception e) {
                if (e instanceof SSLHandshakeException) {
                    return FormValidation.warning((String)"The SSL Certificate presented by the server is invalid. If this is expected, please input an SHA1 Fingerprint in the \"Advanced\" option");
                }
                logger.warning("Unexpected error when checking for codedx version: " + e.getMessage());
                return FormValidation.error((String)"An unexpected error occurred, please check the URL.");
            }
            if (value.toLowerCase().startsWith("http:")) {
                return FormValidation.warning((String)"HTTP is considered insecure, it is recommended that you use HTTPS.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSelfSignedCertificateFingerprint(@QueryParameter String value, @QueryParameter String url, @AncestorInPath Item item) {
            block4: {
                CodeDxPublisher.checkPermissionForRemoteRequests(item);
                if (url != null && !url.isEmpty() && value != null && !value.isEmpty()) {
                    CodeDxClient client = CodeDxPublisher.buildClient(url, "", value);
                    try {
                        client.getProjects();
                    }
                    catch (Exception e) {
                        if (!(e instanceof SSLHandshakeException)) break block4;
                        logger.warning("When retrieving projects: " + e);
                        e.printStackTrace();
                        if (CodeDxPublisher.isFingerprintMismatch((SSLHandshakeException)e)) {
                            return FormValidation.warning((String)"The fingerprint doesn't match the fingerprint of the certificate presented by the server");
                        }
                        return FormValidation.warning((String)"A secure connection to the server could not be established");
                    }
                }
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSourceAndBinaryFiles(@QueryParameter String value, @QueryParameter boolean gitFetchConfiguration, @QueryParameter String toolOutputFiles, @AncestorInPath AbstractProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            project.checkPermission(AbstractProject.CONFIGURE);
            if (value.length() == 0) {
                if (gitFetchConfiguration) {
                    return FormValidation.ok();
                }
                if (toolOutputFiles.length() == 0) {
                    return FormValidation.error((String)"You must specify \"Tool Output Files\" and/or \"Source and Binary Files\", or enable \"Include Git Source\"");
                }
                return FormValidation.warning((String)"It is recommended that at least source files are provided to Code Dx.");
            }
            return Util.checkCSVGlobMatches(value, project.getSomeWorkspace());
        }

        @POST
        public FormValidation doCheckExcludedSourceAndBinaryFiles(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            project.checkPermission(AbstractProject.CONFIGURE);
            return Util.checkCSVGlobMatches(value, project.getSomeWorkspace());
        }

        @POST
        public FormValidation doCheckToolOutputFiles(@QueryParameter String value, @QueryParameter String sourceAndBinaryFiles, @QueryParameter boolean gitFetchConfiguration, @AncestorInPath AbstractProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            project.checkPermission(AbstractProject.CONFIGURE);
            if (value.length() == 0 && sourceAndBinaryFiles.length() == 0 && !gitFetchConfiguration) {
                return FormValidation.error((String)"You must specify \"Tool Output Files\" and/or \"Source and Binary Files\", or enable \"Include Git Source\"");
            }
            return Util.checkCSVFileMatches(value, project.getSomeWorkspace());
        }

        public ListBoxModel doFillErrorHandlingBehaviorItems() {
            ListBoxModel listBox = new ListBoxModel();
            listBox.add(BuildErrorBehavior.None.getLabel(), BuildErrorBehavior.None.name());
            listBox.add(BuildErrorBehavior.MarkUnstable.getLabel(), BuildErrorBehavior.MarkUnstable.name());
            listBox.add(BuildErrorBehavior.MarkFailed.getLabel(), BuildErrorBehavior.MarkFailed.name());
            return listBox;
        }

        public ListBoxModel doFillPolicyBreakBuildBehaviorItems() {
            ListBoxModel listBox = new ListBoxModel();
            listBox.add(BuildPolicyBehavior.NoAction.getLabel(), BuildPolicyBehavior.NoAction.name());
            listBox.add(BuildPolicyBehavior.MarkUnstable.getLabel(), BuildPolicyBehavior.MarkUnstable.name());
            listBox.add(BuildPolicyBehavior.MarkFailed.getLabel(), BuildPolicyBehavior.MarkFailed.name());
            return listBox;
        }

        public ListBoxModel doFillFailureSeverityItems() {
            return this.getSeverityItems();
        }

        public ListBoxModel doFillUnstableSeverityItems() {
            return this.getSeverityItems();
        }

        private ListBoxModel getSeverityItems() {
            ListBoxModel listBox = new ListBoxModel();
            listBox.add("None", "None");
            listBox.add("Info or Higher", "Info");
            listBox.add("Low or Higher", "Low");
            listBox.add("Medium or Higher", "Medium");
            listBox.add("High or Higher", "High");
            listBox.add("Critical", "Critical");
            return listBox;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

