/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx.monitor;

import com.codedx.api.client.CodeDxClient;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.StartAnalysisResponse;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.plugins.codedx.monitor.AnalysisMonitor;

public class DirectAnalysisMonitor
implements AnalysisMonitor {
    StartAnalysisResponse analysisResponse;
    PrintStream logger;

    public DirectAnalysisMonitor(StartAnalysisResponse analysisResponse, PrintStream logger) {
        this.analysisResponse = analysisResponse;
        this.logger = logger;
    }

    @Override
    public int waitForStart(CodeDxClient client) {
        return this.analysisResponse.getAnalysisId();
    }

    @Override
    public String waitForFinish(CodeDxClient client) throws IOException, InterruptedException, CodeDxClientException {
        String status = null;
        String oldStatus = null;
        do {
            Thread.sleep(3000L);
            oldStatus = status;
            status = client.getJobStatus(this.analysisResponse.getJobId());
            if (status == null || status.equals(oldStatus)) continue;
            if ("queued".equals(status)) {
                this.logger.println("Code Dx analysis is queued");
                continue;
            }
            if (!"running".equals(status)) continue;
            this.logger.println("Code Dx analysis is running");
        } while ("queued".equals(status) || "running".equals(status));
        return status;
    }
}

