/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.codedx.api.client.Branch;
import com.codedx.api.client.CodeDxClient;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.ProjectContext;
import com.codedx.util.CodeDxVersion;
import hudson.AbortException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jenkinsci.plugins.codedx.ValueResolver;

public class TargetBranchChecker {
    private final ProjectContext project;
    private final CodeDxClient client;
    private final ValueResolver resolver;
    private final PrintStream logger;
    private String targetBranchName;
    private String baseBranchName;

    public TargetBranchChecker(ProjectContext project, CodeDxClient client, ValueResolver resolver, PrintStream logger) {
        this.project = project;
        this.client = client;
        this.resolver = resolver;
        this.logger = logger;
        this.baseBranchName = null;
        this.targetBranchName = null;
    }

    public String getTargetBranchName() {
        return this.targetBranchName;
    }

    public String getBaseBranchName() {
        return this.baseBranchName;
    }

    public void validate(CodeDxVersion codedxVersion, String targetBranch, String baseBranch) throws IOException, InterruptedException {
        List<Branch> availableBranches;
        if (targetBranch == null) {
            return;
        }
        if (codedxVersion.compareTo(CodeDxVersion.MIN_FOR_BRANCHING) < 0) {
            this.logger.println("The connected Code Dx server with version " + codedxVersion + " does not support project branches. The minimum required version is " + CodeDxVersion.MIN_FOR_BRANCHING + ". The target branch and base branch options will be ignored.");
            return;
        }
        this.targetBranchName = this.resolver.resolve("target branch", targetBranch);
        if (baseBranch != null) {
            this.baseBranchName = this.resolver.resolve("base branch", baseBranch);
        }
        this.logger.println("Validating base branch selection...");
        try {
            availableBranches = this.client.getProjectBranches(this.project);
        }
        catch (CodeDxClientException e) {
            throw new IOException("An error occurred when fetching available branches for project " + this.project.getProjectId(), e);
        }
        boolean targetBranchExists = false;
        boolean baseBranchExists = false;
        for (Branch branch : availableBranches) {
            if (branch.getName().equals(this.baseBranchName)) {
                baseBranchExists = true;
                continue;
            }
            if (!branch.getName().equals(this.targetBranchName)) continue;
            targetBranchExists = true;
        }
        if (targetBranchExists) {
            this.logger.println("Using existing Code Dx branch: " + this.targetBranchName);
            this.baseBranchName = null;
        } else {
            if (this.baseBranchName == null) {
                throw new AbortException("A parent branch must be specified when using a target branch");
            }
            if (!baseBranchExists) {
                throw new AbortException("The specified parent branch does not exist: " + this.baseBranchName);
            }
            this.logger.println("Analysis will create a new branch named '" + this.targetBranchName + "' based on the branch '" + this.baseBranchName + "'");
        }
    }
}

