/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.api.client;

import com.codedx.api.client.Branch;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.CountGroup;
import com.codedx.api.client.CountRequest;
import com.codedx.api.client.CountResponse;
import com.codedx.api.client.Filter;
import com.codedx.api.client.GetProjectsResponse;
import com.codedx.api.client.GitConfigResponse;
import com.codedx.api.client.GroupedCountRequest;
import com.codedx.api.client.Job;
import com.codedx.api.client.Project;
import com.codedx.api.client.ProjectContext;
import com.codedx.api.client.StartAnalysisResponse;
import com.codedx.util.CodeDxVersion;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class CodeDxClient {
    private static final String KEY_HEADER = "API-Key";
    protected String key;
    protected String url;
    private String serverUrl;
    protected HttpClientBuilder httpClientBuilder;
    private Gson gson;

    public CodeDxClient(String url, String key) {
        this(url, key, HttpClientBuilder.create());
    }

    public CodeDxClient(String url, String key, HttpClientBuilder clientBuilder) {
        this.key = key;
        if (url == null) {
            throw new NullPointerException("Argument url is null");
        }
        if (key == null) {
            throw new NullPointerException("Argument key is null");
        }
        if (!(url = url.trim()).endsWith("/")) {
            url = url + "/";
        }
        if (!url.endsWith("api/")) {
            url = url + "api/";
        }
        this.url = url;
        this.serverUrl = url.replace("/api/", "/");
        this.httpClientBuilder = clientBuilder;
        this.gson = new Gson();
    }

    @Deprecated
    public String buildBrowsableAnalysisRunUrl(int projectId) {
        return this.serverUrl + "projects/" + projectId;
    }

    public String buildLatestFindingsUrl(int projectId) {
        return this.serverUrl + "projects/" + projectId;
    }

    public List<Project> getProjects() throws CodeDxClientException, IOException {
        GetProjectsResponse response = (GetProjectsResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects", false, new TypeToken<GetProjectsResponse>(){}.getType(), null);
        return response.getProjects();
    }

    public Project getProject(ProjectContext project) throws CodeDxClientException, IOException {
        return (Project)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects/" + project.getProjectId(), true, new TypeToken<Project>(){}.getType(), null);
    }

    public Job getJob(String id) throws CodeDxClientException, IOException {
        return (Job)this.doHttpRequest((HttpRequestBase)new HttpGet(), "jobs/" + id, false, new TypeToken<Job>(){}.getType(), null);
    }

    public StartAnalysisResponse getGitJobResult(String id) throws CodeDxClientException, IOException {
        return (StartAnalysisResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "jobs/" + id + "/result", false, new TypeToken<StartAnalysisResponse>(){}.getType(), null);
    }

    public String getJobStatus(String id) throws CodeDxClientException, IOException {
        return this.getJob(id).getStatus();
    }

    public int getFindingsCount(ProjectContext project, Filter filter) throws CodeDxClientException, IOException {
        CountResponse resp = (CountResponse)this.doHttpRequest((HttpRequestBase)new HttpPost(), "projects/" + project.toString() + "/findings/count", true, new TypeToken<CountResponse>(){}.getType(), new CountRequest(filter));
        return resp.getCount();
    }

    public List<CountGroup> getFindingsGroupedCounts(ProjectContext project, Filter filter, String countBy) throws CodeDxClientException, IOException {
        return (List)this.doHttpRequest((HttpRequestBase)new HttpPost(), "projects/" + project.toString() + "/findings/grouped-counts", true, new TypeToken<List<CountGroup>>(){}.getType(), new GroupedCountRequest(filter, countBy));
    }

    public void setAnalysisName(ProjectContext project, int analysisId, String name) throws IOException, CodeDxClientException {
        JsonObject reqBody = new JsonObject();
        reqBody.addProperty("name", name);
        this.doHttpRequest((HttpRequestBase)new HttpPut(), "projects/" + project.getProjectId() + "/analyses/" + analysisId, true, null, reqBody);
    }

    public CodeDxVersion getCodeDxVersion() throws IOException, CodeDxClientException {
        CodeDxVersionResponse resp = (CodeDxVersionResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "system-info", true, new TypeToken<CodeDxVersionResponse>(){}.getType(), null);
        return CodeDxVersion.fromString(resp.version);
    }

    public List<Branch> getProjectBranches(ProjectContext project) throws IOException, CodeDxClientException {
        return (List)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects/" + project.getProjectId() + "/branches", true, new TypeToken<List<Branch>>(){}.getType(), null);
    }

    public boolean projectPolicyShouldBreakTheBuild(ProjectContext project) throws IOException, CodeDxClientException {
        return (Boolean)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects/" + project.toString() + "/policies/any/build-broken", true, new TypeToken<Boolean>(){}.getType(), null);
    }

    public GitConfigResponse getProjectGitConfig(ProjectContext project) throws IOException, CodeDxClientException {
        return (GitConfigResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "gitconf/" + project.getProjectId(), true, new TypeToken<GitConfigResponse>(){}.getType(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doHttpRequest(HttpRequestBase request, String path, boolean isXApi, Type responseType, Object requestBody) throws IOException, CodeDxClientException {
        String apiPath = (isXApi ? this.url.replace("/api/", "/x/") : this.url) + path;
        request.setURI(URI.create(apiPath));
        request.addHeader(KEY_HEADER, this.key);
        if (requestBody != null && request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
            StringEntity requestBodyEntity = new StringEntity(this.gson.toJson(requestBody));
            entityRequest.setEntity((HttpEntity)requestBodyEntity);
        }
        try (CloseableHttpClient client = this.httpClientBuilder.build();
             CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            int responseCode = response.getStatusLine().getStatusCode();
            boolean isSuccess = responseCode / 100 == 2;
            String responseBody = response.getEntity() == null ? null : IOUtils.toString((InputStream)response.getEntity().getContent());
            if (!isSuccess) throw new CodeDxClientException(request.getMethod(), apiPath, response.getStatusLine().getReasonPhrase(), responseCode, responseBody);
            if (responseType == null || responseBody == null) {
                T t = null;
                return t;
            }
            Object object = this.gson.fromJson(responseBody, responseType);
            return (T)object;
        }
    }

    public StartAnalysisResponse startAnalysis(int projectId, boolean includeGitSource, String specificGitBranch, String parentBranchName, String targetBranchName, Map<String, InputStream> artifacts) throws IOException, CodeDxClientException {
        ProjectContext project = new ProjectContext(projectId, parentBranchName);
        ArrayList<String> queryParams = new ArrayList<String>();
        if (targetBranchName != null && targetBranchName.length() > 0) {
            queryParams.add("branchName=" + targetBranchName);
        }
        if (includeGitSource) {
            queryParams.add("includeGitSource=true");
            if (specificGitBranch != null) {
                queryParams.add("gitBranchName=" + specificGitBranch);
            }
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("projects/");
        pathBuilder.append(project);
        pathBuilder.append("/analysis");
        if (!queryParams.isEmpty()) {
            for (int i = 0; i < queryParams.size(); ++i) {
                String param = (String)queryParams.get(i);
                if (i == 0) {
                    pathBuilder.append('?');
                } else {
                    pathBuilder.append('&');
                }
                pathBuilder.append(param);
            }
        }
        String path = pathBuilder.toString();
        HttpPost postRequest = new HttpPost(this.url + path);
        postRequest.addHeader(KEY_HEADER, this.key);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, InputStream> artifact : artifacts.entrySet()) {
            builder.addPart("file[]", (ContentBody)new InputStreamBody(artifact.getValue(), artifact.getKey()));
        }
        HttpEntity entity = builder.build();
        postRequest.setEntity(entity);
        CloseableHttpResponse response = this.httpClientBuilder.build().execute((HttpUriRequest)postRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 202) {
            throw new CodeDxClientException("POST", path, response.getStatusLine().getReasonPhrase(), responseCode, IOUtils.toString((InputStream)response.getEntity().getContent()));
        }
        String data = IOUtils.toString((InputStream)response.getEntity().getContent());
        return (StartAnalysisResponse)this.gson.fromJson(data, new TypeToken<StartAnalysisResponse>(){}.getType());
    }

    public static class CodeDxVersionResponse {
        public String version;
        public String date;
    }
}

