/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.model.Action;
import hudson.model.Build;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.codedx.AnalysisResultConfiguration;
import org.jenkinsci.plugins.codedx.CodeDxDiffGroup;
import org.jenkinsci.plugins.codedx.CodeDxDiffSummary;
import org.jenkinsci.plugins.codedx.CodeDxProjectAction;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.model.CodeDxReportStatistics;
import org.kohsuke.stapler.StaplerProxy;

public class CodeDxBuildAction
implements Action,
SimpleBuildStep.LastBuildAction,
StaplerProxy {
    public static final String URL_NAME = "codedxResult";
    private Build<?, ?> build;
    private final Run<?, ?> run;
    private final CodeDxResult result;
    private final List<CodeDxProjectAction> projectActions;

    public CodeDxBuildAction(Run<?, ?> run, AnalysisResultConfiguration analysisResultConfiguration, String latestAnalysisUrl, CodeDxResult result) {
        this.run = run;
        this.result = result;
        ArrayList<CodeDxProjectAction> projectActions = new ArrayList<CodeDxProjectAction>();
        projectActions.add(new CodeDxProjectAction(run, analysisResultConfiguration, latestAnalysisUrl));
        this.projectActions = projectActions;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.projectActions == null) {
            return new ArrayList();
        }
        return this.projectActions;
    }

    public CodeDxDiffSummary getSeverityDiffSummary() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("Critical");
        order.add("High");
        order.add("Medium");
        order.add("Low");
        order.add("Info");
        order.add("Unspecified");
        HashMap<String, String> iconMap = new HashMap<String, String>();
        iconMap.put("Critical", "/plugin/codedx/icons/critical.png");
        iconMap.put("High", "/plugin/codedx/icons/high.png");
        iconMap.put("Medium", "/plugin/codedx/icons/medium.png");
        iconMap.put("Low", "/plugin/codedx/icons/low.png");
        iconMap.put("Info", "/plugin/codedx/icons/info.png");
        iconMap.put("Unspecified", "/plugin/codedx/icons/unspecified.png");
        return CodeDxDiffSummary.getDiffSummary(this.getPreviousSeverityStats(), this.result.getStatistics("severity"), "Severity", new DiffGroupComparator(order), iconMap);
    }

    public CodeDxDiffSummary getStatusDiffSummary() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("Fixed");
        order.add("Mitigated");
        order.add("Ignored");
        order.add("False Positive");
        order.add("Unresolved");
        order.add("Escalated");
        order.add("Assigned");
        order.add("New");
        order.add("Reopened");
        order.add("Gone");
        return CodeDxDiffSummary.getDiffSummary(this.getPreviousStatusStats(), this.result.getStatistics("status"), "Status", new DiffGroupComparator(order), new HashMap<String, String>());
    }

    public CodeDxResult getResult() {
        return this.result;
    }

    private CodeDxReportStatistics getPreviousSeverityStats() {
        CodeDxResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getStatistics("severity");
    }

    private CodeDxReportStatistics getPreviousStatusStats() {
        CodeDxResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getStatistics("status");
    }

    CodeDxResult getPreviousResult() {
        CodeDxBuildAction previousAction = this.getPreviousAction();
        CodeDxResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    CodeDxBuildAction getPreviousAction() {
        Run<?, ?> currentRun = null;
        if (this.run != null) {
            currentRun = this.run;
        } else if (this.build != null) {
            currentRun = this.build;
        }
        if (currentRun == null) {
            return null;
        }
        for (Run previousBuild = currentRun.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
            CodeDxResult result;
            CodeDxBuildAction action = (CodeDxBuildAction)previousBuild.getAction(CodeDxBuildAction.class);
            if (action == null || (result = action.getResult()) == null || result.isEmpty()) continue;
            return action;
        }
        return null;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public Build<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }

    private static class DiffGroupComparator
    implements Comparator<CodeDxDiffGroup> {
        List<String> groupOrdering = new ArrayList<String>();

        public DiffGroupComparator(List<String> groupOrdering) {
            this.groupOrdering = groupOrdering;
        }

        @Override
        public int compare(CodeDxDiffGroup o1, CodeDxDiffGroup o2) {
            int index1 = this.groupOrdering.indexOf(o1.getName());
            int index2 = this.groupOrdering.indexOf(o2.getName());
            return Integer.compare(index1, index2);
        }
    }
}

