/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.FilePath;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class.getName());

    public static String[] commaSeparatedToArray(String str) {
        return str.split("\\s*,\\s*");
    }

    public static FormValidation checkCSVGlobMatches(String value, FilePath workspace) {
        if (value.length() != 0 && workspace != null) {
            for (String path : Util.commaSeparatedToArray(value)) {
                try {
                    if (path.length() != 0 && workspace.list(path).length != 0) continue;
                    return FormValidation.warning((String)(path + " doesn't match anything in the workspace."));
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("Expecting Ant GLOB pattern")) {
                        return FormValidation.error((String)(path + " is not a valid Ant GLOB pattern. Note that patterns must not begin with a '/'"));
                    }
                    log.log(Level.SEVERE, "Unexpected error in form validation", e);
                    return FormValidation.error((String)"An unexpected error occurred while validating this field. Check the logs for more detail.");
                }
            }
        }
        return FormValidation.ok();
    }

    public static FormValidation checkCSVFileMatches(String value, FilePath workspace) {
        if (value.length() != 0 && workspace != null) {
            for (String path : Util.commaSeparatedToArray(value)) {
                try {
                    if (path.length() == 0 || !new FilePath(workspace, path).exists()) {
                        return FormValidation.warning((String)(path + " does not exist in the workspace."));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return FormValidation.ok();
    }
}

