/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.FilePath;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Archiver {
    private static final Logger log = Logger.getLogger(Archiver.class.getName());

    public static FilePath Archive(FilePath workspace, String[] paths, String[] excludePaths, String prefix, PrintStream logger) throws IOException, InterruptedException {
        final HashSet<String> includeFiles = new HashSet<String>();
        final HashSet<String> excludeFiles = new HashSet<String>();
        for (String path : paths) {
            if (path == null || path.length() <= 0) continue;
            for (FilePath match : workspace.list(path)) {
                includeFiles.add(match.getRemote());
            }
        }
        for (String path : excludePaths) {
            if (path == null || path.length() <= 0) continue;
            for (FilePath match : workspace.list(path)) {
                excludeFiles.add(match.getRemote());
            }
        }
        if (includeFiles.size() == 0) {
            return null;
        }
        FilePath result = workspace.createTempFile(prefix, ".zip");
        workspace.zip(result.write(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean include;
                boolean bl = include = includeFiles.contains(file.getAbsolutePath()) && !excludeFiles.contains(file.getAbsolutePath());
                if (include) {
                    log.log(Level.FINE, "Adding" + file + " to zip");
                }
                return include;
            }
        });
        return result;
    }
}

