/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.ChartUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.jenkinsci.plugins.codedx.AnalysisResultConfiguration;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxChartBuilder;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.model.StatisticGroup;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDxProjectAction
implements Action,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final String URL_NAME = "codedxResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    public AbstractProject<?, ?> project;
    private final String latestAnalysisUrl;
    private AnalysisResultConfiguration analysisResultConfiguration;

    public CodeDxProjectAction(AbstractProject<?, ?> project, AnalysisResultConfiguration analysisResultConfiguration, String latestAnalysisUrl) {
        this.project = project;
        this.analysisResultConfiguration = analysisResultConfiguration;
        this.latestAnalysisUrl = latestAnalysisUrl;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getLatestAnalysisUrl() {
        return this.latestAnalysisUrl;
    }

    public AnalysisResultConfiguration getAnalysisResultConfiguration() {
        return this.analysisResultConfiguration;
    }

    public boolean showTablesAndCharts() {
        return this.analysisResultConfiguration != null;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        } else {
            response.sendRedirect2("..");
        }
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(CodeDxBuildAction.class) == null); lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public CodeDxBuildAction getLastFinishedBuildAction() {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        return lastBuild != null ? (CodeDxBuildAction)lastBuild.getAction(CodeDxBuildAction.class) : null;
    }

    public final boolean hasValidResults() {
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            int nbr_results = 0;
            for (CodeDxBuildAction resultAction = (CodeDxBuildAction)build.getAction(CodeDxBuildAction.class); resultAction != null; resultAction = resultAction.getPreviousAction()) {
                CodeDxResult result = resultAction.getResult();
                if (result == null || ++nbr_results <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public void doSeverityTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        CodeDxBuildAction lastAction = (CodeDxBuildAction)lastBuild.getAction(CodeDxBuildAction.class);
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        colorMap.put("High", new Color(12386342));
        colorMap.put("Medium", new Color(16616764));
        colorMap.put("Low", new Color(16701814));
        colorMap.put("Info", new Color(0x888888));
        colorMap.put("Unspecified", new Color(0xADADAD));
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)CodeDxChartBuilder.buildChart(lastAction, this.analysisResultConfiguration.getNumBuildsInGraph(), "severity", colorMap), (int)500, (int)200);
    }

    public void doStatusTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        CodeDxBuildAction lastAction = (CodeDxBuildAction)lastBuild.getAction(CodeDxBuildAction.class);
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        colorMap.put(StatisticGroup.New.toString(), new Color(5515144));
        colorMap.put(StatisticGroup.Unresolved.toString(), new Color(10063555));
        colorMap.put(StatisticGroup.Fixed.toString(), new Color(3311805));
        colorMap.put(StatisticGroup.Assigned.toString(), new Color(91742));
        colorMap.put(StatisticGroup.Escalated.toString(), new Color(5944492));
        colorMap.put(StatisticGroup.Ignored.toString(), new Color(14201701));
        colorMap.put(StatisticGroup.FalsePositive.toString(), new Color(0xD9D9D9));
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)CodeDxChartBuilder.buildChart(lastAction, this.analysisResultConfiguration.getNumBuildsInGraph(), "status", colorMap), (int)500, (int)200);
    }
}

