/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.FilePath;
import hudson.util.FormValidation;
import java.io.IOException;

public class Util {
    public static String[] commaSeparatedToArray(String str) {
        return str.split("\\s*,\\s*");
    }

    public static FormValidation checkCSVGlobMatches(String value, FilePath workspace) {
        if (value.length() != 0 && workspace != null) {
            for (String path : Util.commaSeparatedToArray(value)) {
                try {
                    if (path.length() != 0 && workspace.list(path).length != 0) continue;
                    return FormValidation.warning((String)(path + " doesn't match anything in the workspace."));
                }
                catch (Exception e) {
                    return FormValidation.error((String)(path + " is not a valid Ant GLOB pattern. Note that patterns must not begin with a '/'"));
                }
            }
        }
        return FormValidation.ok();
    }

    public static FormValidation checkCSVFileMatches(String value, FilePath workspace) {
        if (value.length() != 0 && workspace != null) {
            for (String path : Util.commaSeparatedToArray(value)) {
                try {
                    if (path.length() == 0 || !new FilePath(workspace, value).exists()) {
                        return FormValidation.warning((String)(path + " does not exist in the workspace."));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return FormValidation.ok();
    }
}

