/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.codedx.CodeDxAreaRenderer;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDxChartBuilder
implements Serializable {
    private static final long serialVersionUID = 0L;

    private CodeDxChartBuilder() {
    }

    public static JFreeChart buildChart(CodeDxBuildAction action, int numBuildsInGraph, String statisticsName, Map<String, Color> colors) {
        CategoryDataset dataset = CodeDxChartBuilder.buildDataset(action, numBuildsInGraph, statisticsName);
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Findings", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        List rows = dataset.getRowKeys();
        ArrayList<Color> colorList = new ArrayList<Color>();
        if (colors != null) {
            for (Object row : rows) {
                if (!colors.containsKey(row)) continue;
                colorList.add(colors.get(row));
            }
        }
        if (colorList.size() == rows.size()) {
            plot.setRenderer((CategoryItemRenderer)new CodeDxAreaRenderer(colorList));
        } else {
            plot.setRenderer((CategoryItemRenderer)new CodeDxAreaRenderer(null));
        }
        return chart;
    }

    private static CategoryDataset buildDataset(CodeDxBuildAction lastAction, int numBuildsInGraph, String statisticsName) {
        DataSetBuilder builder = new DataSetBuilder();
        HashSet<String> allGroups = new HashSet<String>();
        int numBuilds = 0;
        for (CodeDxBuildAction action = lastAction; action != null && (numBuildsInGraph <= 1 || numBuilds < numBuildsInGraph); action = action.getPreviousAction()) {
            CodeDxResult result = action.getResult();
            if (result == null) continue;
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
            allGroups.addAll(result.getStatistics(statisticsName).getAllGroups());
            HashSet remainingGroups = new HashSet(allGroups);
            for (CodeDxGroupStatistics groupStats : result.getStatistics(statisticsName).getStatistics()) {
                builder.add((Number)groupStats.getFindings(), (Comparable)((Object)groupStats.getGroup()), (Comparable)buildLabel);
                remainingGroups.remove(groupStats.getGroup());
            }
            for (String group : remainingGroups) {
                builder.add((Number)0, (Comparable)((Object)group), (Comparable)buildLabel);
            }
            ++numBuilds;
        }
        return builder.build();
    }
}

