/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.api.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.secdec.codedx.api.client.AnalysisRun;
import com.secdec.codedx.api.client.CodeDxClientException;
import com.secdec.codedx.api.client.CountGroup;
import com.secdec.codedx.api.client.CountRequest;
import com.secdec.codedx.api.client.CountResponse;
import com.secdec.codedx.api.client.Filter;
import com.secdec.codedx.api.client.GetProjectsResponse;
import com.secdec.codedx.api.client.GroupedCountRequest;
import com.secdec.codedx.api.client.Job;
import com.secdec.codedx.api.client.Project;
import com.secdec.codedx.api.client.StartAnalysisResponse;
import com.secdec.codedx.api.client.TriageStatus;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDxClient {
    private final String KEY_HEADER = "API-Key";
    private String key;
    private String url;
    private String serverUrl;
    private DefaultHttpClient httpClient;
    private Gson gson;

    public CodeDxClient(String url, String key) {
        this.key = key;
        if (url == null) {
            throw new NullPointerException("Argument url is null");
        }
        if (key == null) {
            throw new NullPointerException("Argument key is null");
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!url.endsWith("api/")) {
            url = url + "api/";
        }
        this.url = url;
        this.serverUrl = url.replace("/api/", "/");
        this.httpClient = new DefaultHttpClient();
        this.gson = new Gson();
    }

    public String buildBrowsableAnalysisRunUrl(int analysisRunId) {
        return this.serverUrl + "run/" + analysisRunId + "/";
    }

    public String buildLatestAnalysisRunUrl(int projectId) {
        return this.serverUrl + "projects/" + projectId + "/latest";
    }

    public List<Project> getProjects() throws CodeDxClientException, ClientProtocolException, IOException {
        GetProjectsResponse response = (GetProjectsResponse)this.doGet("projects", new TypeToken<GetProjectsResponse>(){}.getType(), false);
        return response.getProjects();
    }

    public Project getProject(int id) throws CodeDxClientException, ClientProtocolException, IOException {
        return (Project)this.doGet("projects/" + id, new TypeToken<Project>(){}.getType(), true);
    }

    public Map<String, TriageStatus> getTriageStatuses(int id) throws CodeDxClientException, ClientProtocolException, IOException {
        return (Map)this.doGet("projects/" + id + "/statuses", new TypeToken<Map<String, TriageStatus>>(){}.getType(), true);
    }

    public AnalysisRun getAnalysisRun(int id) throws CodeDxClientException, ClientProtocolException, IOException {
        return (AnalysisRun)this.doGet("runs/" + id, new TypeToken<AnalysisRun>(){}.getType(), true);
    }

    public List<AnalysisRun> getAnalysisRuns(int id) throws CodeDxClientException, ClientProtocolException, IOException {
        return (List)this.doGet("projects/" + id + "/runs" + id, new TypeToken<List<AnalysisRun>>(){}.getType(), true);
    }

    public Job getJob(String id) throws CodeDxClientException, ClientProtocolException, IOException {
        return (Job)this.doGet("jobs/" + id, new TypeToken<Job>(){}.getType(), false);
    }

    public String getJobStatus(String id) throws CodeDxClientException, ClientProtocolException, IOException {
        return this.getJob(id).getStatus();
    }

    public int getFindingsCount(String id) throws CodeDxClientException, ClientProtocolException, IOException {
        CountResponse resp = (CountResponse)this.doGet("runs/" + id + "/findings/count", new TypeToken<CountResponse>(){}.getType(), true);
        return resp.getCount();
    }

    public int getFindingsCount(int id, Filter filter) throws CodeDxClientException, ClientProtocolException, IOException {
        CountResponse resp = (CountResponse)this.doPost("runs/" + id + "/findings/count", new TypeToken<CountResponse>(){}.getType(), new CountRequest(filter), true);
        return resp.getCount();
    }

    public List<CountGroup> getFindingsGroupedCounts(int id, Filter filter, String countBy) throws CodeDxClientException, ClientProtocolException, IOException {
        return (List)this.doPost("runs/" + id + "/findings/grouped-counts", new TypeToken<List<CountGroup>>(){}.getType(), new GroupedCountRequest(filter, countBy), true);
    }

    private <T> T doGet(String path, Type typeOfT, boolean experimental) throws ClientProtocolException, IOException, CodeDxClientException {
        HttpGet getRequest = experimental ? new HttpGet(this.url.replace("/api/", "/x/") + path) : new HttpGet(this.url + path);
        getRequest.addHeader("API-Key", this.key);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)getRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            throw new CodeDxClientException("failed to get from: " + path, responseCode);
        }
        String data = IOUtils.toString((InputStream)response.getEntity().getContent());
        return (T)this.gson.fromJson(data, typeOfT);
    }

    private <T> T doPost(String path, Type typeOfT, Object payload, boolean experimental) throws ClientProtocolException, IOException, CodeDxClientException {
        HttpPost postRequest = experimental ? new HttpPost(this.url.replace("/api/", "/x/") + path) : new HttpPost(this.url + path);
        postRequest.addHeader("API-Key", this.key);
        postRequest.setEntity((HttpEntity)new StringEntity(this.gson.toJson(payload)));
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            throw new CodeDxClientException("failed to get from: " + path, responseCode);
        }
        String data = IOUtils.toString((InputStream)response.getEntity().getContent());
        return (T)this.gson.fromJson(data, typeOfT);
    }

    public StartAnalysisResponse startAnalysis(int projectId, InputStream[] artifacts) throws ClientProtocolException, IOException, CodeDxClientException {
        HttpPost postRequest = new HttpPost(this.url + "projects/" + projectId + "/analysis");
        postRequest.addHeader("API-Key", this.key);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (InputStream artifact : artifacts) {
            builder.addPart("file[]", (ContentBody)new InputStreamBody(artifact, "file[]"));
        }
        HttpEntity entity = builder.build();
        postRequest.setEntity(entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 202) {
            throw new CodeDxClientException("Failed to start analysis.  " + IOUtils.toString((InputStream)response.getEntity().getContent()), responseCode);
        }
        String data = IOUtils.toString((InputStream)response.getEntity().getContent());
        return (StartAnalysisResponse)this.gson.fromJson(data, new TypeToken<StartAnalysisResponse>(){}.getType());
    }
}

