/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.cloudfoundryjenkins;

import com.hpe.cloudfoundryjenkins.CloudFoundryPushPublisher;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.ApplicationManifestUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class ManifestUtils {
    private static final int GIBI = 1024;

    public static List<ApplicationManifest> loadManifests(FilePath filesPath, CloudFoundryPushPublisher.ManifestChoice manifestChoice, boolean isOnSlave, Run run, FilePath workspace, TaskListener taskListener) throws IOException, InterruptedException, MacroEvaluationException {
        switch (manifestChoice.value) {
            case "manifestFile": {
                return ManifestUtils.loadManifestFiles(filesPath, manifestChoice, run, workspace, taskListener);
            }
            case "jenkinsConfig": {
                return ManifestUtils.jenkinsConfig(filesPath, manifestChoice, isOnSlave, run, workspace, taskListener);
            }
        }
        throw new IllegalArgumentException("manifest choice must be either 'manifestFile' or 'jenkinsConfig', but was " + manifestChoice.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ApplicationManifest> loadManifestFiles(FilePath filesPath, CloudFoundryPushPublisher.ManifestChoice manifestChoice, Run run, FilePath workspace, TaskListener taskListener) throws IOException, InterruptedException, MacroEvaluationException {
        String tokenExpandedManifestPath = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.getManifestFile());
        File f = new File(tokenExpandedManifestPath);
        FilePath manifestPath = f.isAbsolute() ? new FilePath(f) : new FilePath(filesPath, tokenExpandedManifestPath);
        List manifestContents = IOUtils.readLines((InputStream)manifestPath.read());
        StringBuilder sb = new StringBuilder();
        for (String line : manifestContents) {
            String tokenExpandedLine = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)line);
            sb.append(tokenExpandedLine).append(System.lineSeparator());
        }
        FilePath actualSourceManifestFilePath = filesPath;
        if (manifestChoice.getManifestFile().contains(File.separator)) {
            int pos = manifestChoice.getManifestFile().lastIndexOf(File.separator);
            actualSourceManifestFilePath = new FilePath(actualSourceManifestFilePath, manifestChoice.getManifestFile().substring(0, pos));
        }
        FilePath tokenExpandedManifestFile = actualSourceManifestFilePath.createTextTempFile("cf-jenkins-plugin-generated-manifest", ".yml", sb.toString(), true);
        try {
            List<ApplicationManifest> list = ApplicationManifestUtils.read((Path)Paths.get(tokenExpandedManifestFile.toURI())).stream().map(manifest -> ManifestUtils.fixManifest(filesPath, manifest)).collect(Collectors.toList());
            return list;
        }
        finally {
            tokenExpandedManifestFile.delete();
        }
    }

    private static ApplicationManifest fixManifest(FilePath filesPath, ApplicationManifest manifest) {
        if (manifest.getPath() == null && (manifest.getDocker() == null || StringUtils.isEmpty((String)manifest.getDocker().getImage()))) {
            try {
                return ApplicationManifest.builder().from(manifest).path(Paths.get(filesPath.toURI())).build();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return manifest;
    }

    private static List<ApplicationManifest> jenkinsConfig(FilePath filesPath, CloudFoundryPushPublisher.ManifestChoice manifestChoice, boolean isOnSlave, Run run, FilePath workspace, TaskListener taskListener) throws IOException, InterruptedException, MacroEvaluationException {
        ApplicationManifest.Builder manifestBuilder = ApplicationManifest.builder();
        ApplicationManifest.Builder builder = manifestBuilder = !StringUtils.isBlank((String)manifestChoice.appName) ? manifestBuilder.name(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.appName)) : manifestBuilder;
        manifestBuilder = isOnSlave ? (!StringUtils.isBlank((String)manifestChoice.appPath) ? manifestBuilder.path(Paths.get(Paths.get(filesPath.toURI()).toString(), new String[0])) : manifestBuilder.path(Paths.get(filesPath.toURI()))) : (!StringUtils.isBlank((String)manifestChoice.appPath) ? manifestBuilder.path(Paths.get(Paths.get(filesPath.toURI()).toString(), TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.appPath))) : manifestBuilder.path(Paths.get(filesPath.toURI())));
        manifestBuilder = !StringUtils.isBlank((String)manifestChoice.buildpack) ? manifestBuilder.buildpack(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.buildpack)) : manifestBuilder;
        manifestBuilder = !StringUtils.isBlank((String)manifestChoice.command) ? manifestBuilder.command(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.command)) : manifestBuilder;
        ApplicationManifest.Builder builder2 = manifestBuilder = !StringUtils.isBlank((String)manifestChoice.domain) ? manifestBuilder.domain(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.domain)) : manifestBuilder;
        if (!CollectionUtils.isEmpty(manifestChoice.envVars)) {
            HashMap<String, String> tokenMacroExpandedEnvVars = new HashMap<String, String>(manifestChoice.envVars.size());
            for (CloudFoundryPushPublisher.EnvironmentVariable envVar : manifestChoice.getEnvVars()) {
                String key = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)envVar.key);
                String value = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)envVar.value);
                tokenMacroExpandedEnvVars.put(key, value);
            }
            manifestBuilder = manifestBuilder.environmentVariables(tokenMacroExpandedEnvVars);
        }
        ApplicationManifest.Builder builder3 = manifestBuilder = !StringUtils.isBlank((String)manifestChoice.hostname) ? manifestBuilder.host(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.hostname)) : manifestBuilder;
        if (!StringUtils.isBlank((String)manifestChoice.instances)) {
            String instances = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.instances);
            manifestBuilder = manifestBuilder.instances(Integer.valueOf(instances));
        }
        if (!StringUtils.isBlank((String)manifestChoice.memory)) {
            String memory = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.memory);
            Integer memoryMb = ManifestUtils.asMemoryInteger(memory);
            manifestBuilder = manifestBuilder.memory(memoryMb);
        }
        if (!StringUtils.isBlank((String)manifestChoice.noRoute)) {
            String s = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.noRoute);
            Boolean noRoute = Boolean.parseBoolean(s);
            manifestBuilder = manifestBuilder.noRoute(noRoute);
        }
        if (!CollectionUtils.isEmpty(manifestChoice.servicesNames)) {
            ArrayList<String> servicesNames = new ArrayList<String>(manifestChoice.servicesNames.size());
            for (CloudFoundryPushPublisher.ServiceName serviceName : manifestChoice.servicesNames) {
                servicesNames.add(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)serviceName.name));
            }
            manifestBuilder = manifestBuilder.services(servicesNames);
        }
        ApplicationManifest.Builder builder4 = manifestBuilder = !StringUtils.isBlank((String)manifestChoice.stack) ? manifestBuilder.stack(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.stack)) : manifestBuilder;
        if (!StringUtils.isBlank((String)manifestChoice.timeout)) {
            String timeout = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)taskListener, (String)manifestChoice.timeout);
            manifestBuilder = manifestBuilder.timeout(Integer.valueOf(timeout));
        }
        return Collections.singletonList(manifestBuilder.build());
    }

    public static int asMemoryInteger(String text) {
        if (text.toUpperCase().endsWith("G")) {
            return Integer.parseInt(text.substring(0, text.length() - 1)) * 1024;
        }
        if (text.toUpperCase().endsWith("GB")) {
            return Integer.parseInt(text.substring(0, text.length() - 2)) * 1024;
        }
        if (text.toUpperCase().endsWith("M")) {
            return Integer.parseInt(text.substring(0, text.length() - 1));
        }
        if (text.toUpperCase().endsWith("MB")) {
            return Integer.parseInt(text.substring(0, text.length() - 2));
        }
        return Integer.parseInt(text);
    }
}

