/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.config;

import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Saveable;
import hudson.security.Permission;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"defaultFolderConfiguration"})
public class AbstractFolderConfiguration
extends GlobalConfiguration {
    private List<FolderHealthMetric> healthMetrics;

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }

    @NonNull
    public static AbstractFolderConfiguration get() {
        AbstractFolderConfiguration instance = (AbstractFolderConfiguration)((Object)GlobalConfiguration.all().get(AbstractFolderConfiguration.class));
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    private static boolean getHealthMetricsProperty() {
        return Boolean.getBoolean(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS");
    }

    @DataBoundConstructor
    public AbstractFolderConfiguration() {
        this.load();
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void autoConfigure() {
        if (AbstractFolderConfiguration.getHealthMetricsProperty()) {
            AbstractFolderConfiguration abstractFolderConfiguration = AbstractFolderConfiguration.get();
            if (abstractFolderConfiguration.healthMetrics == null) {
                ArrayList<FolderHealthMetric> metrics = new ArrayList<FolderHealthMetric>();
                for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                    FolderHealthMetric metric = d.createDefault();
                    if (metric == null) continue;
                    metrics.add(metric);
                }
                abstractFolderConfiguration.setHealthMetrics((List<FolderHealthMetric>)new DescribableList((Saveable)abstractFolderConfiguration, metrics));
            }
        }
    }

    @NonNull
    public List<FolderHealthMetric> getHealthMetrics() {
        return this.healthMetrics == null ? Collections.emptyList() : this.healthMetrics;
    }

    @DataBoundSetter
    public void setHealthMetrics(List<FolderHealthMetric> healthMetrics) {
        this.healthMetrics = healthMetrics;
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        if (json.containsKey((Object)"healthMetrics")) {
            req.bindJSON((Object)this, json);
            this.save();
        } else {
            this.setHealthMetrics(Collections.emptyList());
        }
        return true;
    }
}

