/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TopLevelItem;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public abstract class ChildNameGenerator<P extends AbstractFolder<I>, I extends TopLevelItem> {
    private static final Logger LOGGER = Logger.getLogger(ChildNameGenerator.class.getName());
    private static final Map<Trace, String> idealNames = new WeakHashMap<Trace, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Trace beforeCreateItem(@NonNull AbstractFolder<?> project, @NonNull String itemName, @NonNull String idealName) {
        Trace trace = new Trace(project, itemName);
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            idealNames.put(trace, idealName);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void afterItemCreated(@NonNull Trace trace) {
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            idealNames.remove(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    protected final String idealNameFromItem(@NonNull P parent, @NonNull I item) {
        String itemName = item.getName();
        if (itemName == null) {
            return null;
        }
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            return idealNames.get(new Trace((AbstractFolder<?>)((Object)parent), itemName));
        }
    }

    @CheckForNull
    public abstract String itemNameFromItem(@NonNull P var1, @NonNull I var2);

    @CheckForNull
    public abstract String dirNameFromItem(@NonNull P var1, @NonNull I var2);

    @NonNull
    final String dirName(@NonNull P parent, @NonNull I item) {
        String name = this.dirNameFromItem(parent, item);
        if (name == null) {
            name = this.dirNameFromLegacy(parent, item.getName());
        }
        return name;
    }

    @NonNull
    final File ensureItemDirectory(@NonNull P parent, @NonNull I item, @NonNull File legacyDir) throws IOException {
        String legacyName = legacyDir.getName();
        String dirName = this.dirNameFromItem(parent, item);
        if (dirName == null) {
            dirName = this.dirNameFromLegacy(parent, legacyName);
        }
        File newSubdir = ((AbstractFolder)((Object)parent)).getRootDirFor(dirName);
        if (!legacyName.equals(dirName)) {
            throw new IllegalStateException("Actual directory name '" + legacyName + "' does not match expected name '" + dirName + "'");
        }
        return newSubdir;
    }

    @NonNull
    public abstract String itemNameFromLegacy(@NonNull P var1, @NonNull String var2);

    @NonNull
    public abstract String dirNameFromLegacy(@NonNull P var1, @NonNull String var2);

    public static final class Trace
    implements Closeable {
        @NonNull
        private final AbstractFolder<?> folder;
        @NonNull
        private final String itemName;

        private Trace(@NonNull AbstractFolder<?> folder, @NonNull String itemName) {
            this.folder = folder;
            this.itemName = itemName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trace that = (Trace)o;
            return this.folder == that.folder && this.itemName.equals(that.itemName);
        }

        public int hashCode() {
            int result = ((Object)this.folder).hashCode();
            result = 31 * result + this.itemName.hashCode();
            return result;
        }

        @Override
        public void close() {
            ChildNameGenerator.afterItemCreated(this);
        }
    }
}

