/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import org.jvnet.localizer.Localizable;

@Extension
public class ThrottleComputationQueueTaskDispatcher
extends QueueTaskDispatcher {
    private static final long ONE_SECOND_OF_NANOS = TimeUnit.SECONDS.toNanos(1L);
    static int LIMIT = Math.max(1, Math.min(Integer.getInteger(ThrottleComputationQueueTaskDispatcher.class.getName() + ".LIMIT", 5), Runtime.getRuntime().availableProcessors() * 4));
    @GuardedBy(value="self")
    private final List<TimestamppedWeakReference> recent = new ArrayList<TimestamppedWeakReference>(LIMIT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CauseOfBlockage canRun(Queue.Item item) {
        if (item.task instanceof ComputedFolder) {
            boolean found;
            int approvedCount;
            long now = System.nanoTime();
            Queue queue = Queue.getInstance();
            List<TimestamppedWeakReference> list = this.recent;
            synchronized (list) {
                approvedCount = 0;
                found = false;
                Iterator<TimestamppedWeakReference> i = this.recent.iterator();
                while (i.hasNext()) {
                    TimestamppedWeakReference details = i.next();
                    Queue.Item task = (Queue.Item)details.get();
                    if (task == null) {
                        i.remove();
                        continue;
                    }
                    if (now - details.when > ONE_SECOND_OF_NANOS || queue.getItem(task.getId()) instanceof Queue.LeftItem) {
                        i.remove();
                        continue;
                    }
                    ++approvedCount;
                    found = found || task == item;
                }
            }
            if (!found && this.computationCount() + approvedCount >= LIMIT) {
                return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleComputationQueueTaskDispatcher_MaxConcurrentIndexing());
            }
            if (!found) {
                list = this.recent;
                synchronized (list) {
                    this.recent.add(new TimestamppedWeakReference(now, item));
                }
            }
        }
        return null;
    }

    @Deprecated
    public int indexingCount() {
        return this.computationCount();
    }

    public int computationCount() {
        Jenkins j = Jenkins.get();
        int result = this.computationCount((Node)j);
        for (Node n : j.getNodes()) {
            result += this.computationCount(n);
        }
        return result;
    }

    @Deprecated
    public int indexingCount(@CheckForNull Node node) {
        return this.computationCount(node);
    }

    public int computationCount(@CheckForNull Node node) {
        Computer computer;
        int result = 0;
        Computer computer2 = computer = node == null ? null : node.toComputer();
        if (computer != null) {
            for (Executor e : computer.getExecutors()) {
                if (!(e.getCurrentExecutable() instanceof FolderComputation)) continue;
                ++result;
            }
            for (Executor e : computer.getOneOffExecutors()) {
                if (!(e.getCurrentExecutable() instanceof FolderComputation)) continue;
                ++result;
            }
        }
        return result;
    }

    private static class TimestamppedWeakReference
    extends WeakReference<Queue.Item> {
        final long when;

        TimestamppedWeakReference(long when, Queue.Item task) {
            super(task);
            this.when = when;
        }
    }
}

