/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.BulkChange;
import hudson.Util;
import hudson.XmlFile;
import hudson.console.AnnotatedLargeText;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.Items;
import hudson.model.Messages;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.Charsets;
import org.apache.commons.jelly.XMLOutput;

public class FolderComputation<I extends TopLevelItem>
extends Actionable
implements Queue.Executable,
Saveable {
    private static final Logger LOGGER = Logger.getLogger(FolderComputation.class.getName());
    @Nonnull
    private final transient ComputedFolder<I> folder;
    @CheckForNull
    private final transient FolderComputation<I> previous;
    @CheckForNull
    private volatile Result result;
    @CheckForNull
    private List<Long> durations;
    private long timestamp;
    private long duration;

    protected FolderComputation(@Nonnull ComputedFolder<I> folder, @CheckForNull FolderComputation<I> previous) {
        this.folder = folder;
        this.previous = previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamBuildListener listener;
        try {
            listener = new StreamBuildListener((OutputStream)new FileOutputStream(this.getLogFile()), Charsets.UTF_8);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            this.result = Result.FAILURE;
            return;
        }
        this.timestamp = System.currentTimeMillis();
        listener.started(this.getCauses());
        Result _result = Result.NOT_BUILT;
        try {
            this.folder.updateChildren((TaskListener)listener);
            _result = Result.SUCCESS;
        }
        catch (InterruptedException x) {
            listener.getLogger().println("Aborted");
            _result = Result.ABORTED;
        }
        catch (Exception x) {
            x.printStackTrace(listener.fatalError("Failed to recompute children of " + this.getDisplayName()));
            _result = Result.FAILURE;
        }
        finally {
            this.duration = System.currentTimeMillis() - this.timestamp;
            if (this.durations == null) {
                this.durations = new ArrayList<Long>();
            }
            while (this.durations.size() > 32) {
                this.durations.remove(0);
            }
            this.durations.add(this.duration);
            listener.finished(_result);
            listener.closeQuietly();
            this.result = _result;
            try {
                this.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        XmlFile dataFile = this.getDataFile();
        dataFile.write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)dataFile);
    }

    @Nonnull
    public File getLogFile() {
        return new File(this.folder.getComputationDir(), "computation.log");
    }

    @Nonnull
    protected XmlFile getDataFile() {
        return new XmlFile(Items.XSTREAM, new File(this.folder.getComputationDir(), "computation.xml"));
    }

    public List<Cause> getCauses() {
        CauseAction a = (CauseAction)this.getAction(CauseAction.class);
        if (a == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(a.getCauses());
    }

    public String getDisplayName() {
        return "Folder Computation";
    }

    public String getSearchUrl() {
        return "computation/";
    }

    public ComputedFolder<I> getParent() {
        return this.folder;
    }

    public long getEstimatedDuration() {
        if (this.durations == null || this.durations.isEmpty()) {
            return -1L;
        }
        long total = 0L;
        for (Long d : this.durations) {
            total += d.longValue();
        }
        return total / (long)this.durations.size();
    }

    public boolean isBuilding() {
        return Executor.of((Queue.Executable)this) != null;
    }

    public boolean isLogUpdated() {
        return this.result == null;
    }

    @Nonnull
    public AnnotatedLargeText<FolderComputation<I>> getLogText() {
        return new AnnotatedLargeText(this.getLogFile(), Charsets.UTF_8, !this.isLogUpdated(), (Object)this);
    }

    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        this.getLogText().writeHtmlTo(offset, out.asWriter());
    }

    public void writeWholeLogTo(@Nonnull OutputStream out) throws IOException, InterruptedException {
        AnnotatedLargeText<FolderComputation<I>> logText;
        long pos = 0L;
        do {
            logText = this.getLogText();
            pos = logText.writeLogTo(pos, out);
        } while (!logText.isComplete());
    }

    @CheckForNull
    public Result getResult() {
        return this.result;
    }

    @Nonnull
    public Calendar getTimestamp() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(this.timestamp);
        return c;
    }

    @Nonnull
    public String getDurationString() {
        if (this.isBuilding()) {
            return Messages.Run_InProgressDuration((Object)Util.getTimeSpanString((long)(System.currentTimeMillis() - this.timestamp)));
        }
        return Util.getTimeSpanString((long)this.duration);
    }

    @Nonnull
    public String getUrl() {
        return this.folder.getUrl() + "computation/";
    }

    @CheckForNull
    public Result getPreviousResult() {
        return this.previous == null ? null : this.previous.result;
    }

    @Nonnull
    public BallColor getIconColor() {
        Result _result = this.result;
        if (_result != null) {
            return _result.color;
        }
        Result previousResult = this.getPreviousResult();
        if (previousResult == null) {
            return BallColor.GREY_ANIME;
        }
        return previousResult.color.anime();
    }

    public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    static {
        Items.XSTREAM.alias("folder-computation", FolderComputation.class);
    }
}

