/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategyDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultOrphanedItemStrategy
extends OrphanedItemStrategy {
    private static final Logger LOGGER = Logger.getLogger(DefaultOrphanedItemStrategy.class.getName());
    private final boolean pruneDeadBranches;
    private final int daysToKeep;
    private final int numToKeep;

    @DataBoundConstructor
    public DefaultOrphanedItemStrategy(boolean pruneDeadBranches, @CheckForNull String daysToKeepStr, @CheckForNull String numToKeepStr) {
        this.pruneDeadBranches = pruneDeadBranches;
        this.daysToKeep = pruneDeadBranches ? DefaultOrphanedItemStrategy.fromString(daysToKeepStr) : -1;
        this.numToKeep = pruneDeadBranches ? DefaultOrphanedItemStrategy.fromString(numToKeepStr) : -1;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public boolean isPruneDeadBranches() {
        return this.pruneDeadBranches;
    }

    @NonNull
    public String getDaysToKeepStr() {
        return DefaultOrphanedItemStrategy.toString(this.daysToKeep);
    }

    @NonNull
    public String getNumToKeepStr() {
        return DefaultOrphanedItemStrategy.toString(this.numToKeep);
    }

    @NonNull
    private static String toString(int i) {
        if (i == -1) {
            return "";
        }
        return String.valueOf(i);
    }

    private static int fromString(@CheckForNull String s) {
        if (StringUtils.isBlank((String)s)) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long lastBuildTime(TopLevelItem item) {
        long t = 0L;
        for (Job j : item.getAllJobs()) {
            Run b = j.getLastBuild();
            if (b == null) continue;
            t = Math.max(t, b.getTimeInMillis());
        }
        return t;
    }

    @Override
    public <I extends TopLevelItem> Collection<I> orphanedItems(ComputedFolder<I> owner, Collection<I> orphaned, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<TopLevelItem> toRemove = new ArrayList<TopLevelItem>();
        LOGGER.log(Level.FINE, "Running the dead item cleanup for {0}", owner.getFullName());
        if (this.pruneDeadBranches && (this.numToKeep != -1 || this.daysToKeep != -1)) {
            ArrayList<I> candidates = new ArrayList<I>(orphaned);
            Collections.sort(candidates, new Comparator<I>(){

                @Override
                public int compare(I i1, I i2) {
                    long ms1 = DefaultOrphanedItemStrategy.lastBuildTime(i1);
                    long ms2 = DefaultOrphanedItemStrategy.lastBuildTime(i2);
                    return ms2 < ms1 ? -1 : (ms2 == ms1 ? 0 : 1);
                }
            });
            int count = 0;
            if (this.numToKeep != -1) {
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext()) {
                    TopLevelItem item = (TopLevelItem)iterator.next();
                    if (++count <= this.numToKeep) continue;
                    LOGGER.log(Level.FINER, "{0} is to be removed", item.getFullName());
                    toRemove.add(item);
                    iterator.remove();
                }
            }
            if (this.daysToKeep != -1) {
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(6, -this.daysToKeep);
                for (TopLevelItem item : candidates) {
                    if (DefaultOrphanedItemStrategy.lastBuildTime(item) > cal.getTimeInMillis()) {
                        LOGGER.log(Level.FINER, "{0} is not GC-ed because it is still new", item.getFullName());
                        continue;
                    }
                    LOGGER.log(Level.FINER, "{0} is to be removed", item.getFullName());
                    toRemove.add(item);
                }
            }
        }
        return toRemove;
    }

    @Extension
    public static class DescriptorImpl
    extends OrphanedItemStrategyDescriptor {
        public String getDisplayName() {
            return "Default";
        }
    }
}

