/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketReviewer;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequestDestination;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequestSource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitbucketServerPullRequest
implements BitbucketPullRequest {
    private String id;
    @JsonProperty(value="fromRef")
    private BitbucketServerPullRequestSource source;
    @JsonProperty(value="toRef")
    private BitbucketServerPullRequestDestination destination;
    private String title;
    private String link;
    private String authorLogin;
    private String authorEmail;
    private String authorIdentifier;
    private List<BitbucketReviewer> reviewers;
    private Boolean canMerge;
    @JsonProperty
    @JsonDeserialize(keyAs=String.class, contentUsing=BitbucketHref.Deserializer.class)
    private Map<String, List<BitbucketHref>> links;

    @Override
    public BitbucketServerPullRequestSource getSource() {
        return this.source;
    }

    public void setSource(BitbucketServerPullRequestSource source) {
        this.source = source;
    }

    @Override
    public BitbucketServerPullRequestDestination getDestination() {
        return this.destination;
    }

    public void setDestination(BitbucketServerPullRequestDestination destination) {
        this.destination = destination;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getLink() {
        Map<String, BitbucketHref> links;
        BitbucketHref self;
        if (this.link == null && (self = (links = this.getLinks()).get("self")) != null) {
            return self.getHref();
        }
        return this.link;
    }

    @Override
    public String getAuthorLogin() {
        return this.authorLogin;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<BitbucketReviewer> getReviewers() {
        return this.reviewers;
    }

    public void setReviewers(List<BitbucketReviewer> reviewers) {
        this.reviewers = reviewers;
    }

    @Override
    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @Override
    public String getAuthorIdentifier() {
        return this.authorIdentifier;
    }

    @JsonProperty
    public void setAuthor(Author author) {
        if (author != null && author.getUser() != null) {
            this.authorLogin = author.getUser().getDisplayName();
            this.authorEmail = author.getUser().getEmailAddress();
            this.authorIdentifier = author.getUser().getName();
        } else {
            this.authorLogin = null;
            this.authorEmail = null;
            this.authorIdentifier = null;
        }
    }

    @CheckForNull
    public Boolean isCanMerge() {
        return this.canMerge;
    }

    public void setCanMerge(Boolean canMerge) {
        this.canMerge = canMerge;
    }

    @JsonIgnore
    public Map<String, BitbucketHref> getLinks() {
        if (this.links == null) {
            return null;
        }
        HashMap<String, BitbucketHref> result = new HashMap<String, BitbucketHref>();
        for (Map.Entry<String, List<BitbucketHref>> entry : this.links.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), entry.getValue().get(0));
        }
        return result;
    }

    @JsonIgnore
    public void setLinks(Map<String, BitbucketHref> links) {
        if (links == null) {
            this.links = null;
        } else {
            this.links = new HashMap<String, List<BitbucketHref>>();
            for (Map.Entry<String, BitbucketHref> entry : links.entrySet()) {
                this.links.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
    }

    public static class User {
        private String name;
        private String displayName;
        private String emailAddress;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }
    }

    public static class Author {
        private User user;

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }
    }
}

